/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Configuration;
import com.gitlab.qolq.powershot.PowerableCapability;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="powershot")
public final class Powershot {
    public static final String MOD_ID = "powershot";
    static final Logger log = LogManager.getLogger((String)"powershot");
    private static Configuration config;

    public Powershot() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        Path dir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        log.debug("Loading configs from {}", (Object)dir);
        config = new Configuration(dir);
        config.init();
        CapabilityManager.INSTANCE.register(PowerableCapability.IPowerable.class, (Capability.IStorage)new PowerableCapability.Serializer(), PowerableCapability.Powerable::new);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::addCapability);
    }

    private void addCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).field_70170_p.field_72995_K && event.getObject() instanceof AbstractArrowEntity) {
            event.addCapability(PowerableCapability.KEY, (ICapabilityProvider)new PowerableCapability.Powerable());
        }
    }

    public static void setPower(AbstractArrowEntity arrow, float speed) {
        if (!arrow.field_70170_p.field_72995_K) {
            arrow.getCapability(PowerableCapability.instance).ifPresent(p -> p.setPower(Powershot.calculatePower(arrow, speed)));
        }
    }

    private static float calculatePower(AbstractArrowEntity arrow, float speed) {
        LivingEntity livingShooter;
        ItemStack stack;
        float power = Powershot.config.basePower * speed;
        Entity shooter = arrow.func_212360_k();
        if (shooter instanceof LivingEntity && !(stack = (livingShooter = (LivingEntity)shooter).func_184586_b(livingShooter.func_184600_cs())).func_190926_b()) {
            ListNBT enchantments = stack.func_77986_q();
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundNBT enchantment = enchantments.func_150305_b(i);
                ResourceLocation id = ResourceLocation.func_208304_a((String)enchantment.func_74779_i("id"));
                if (id == null || !Powershot.config.enchantmentToMultiplier.containsKey((Object)id)) continue;
                power += (float)MathHelper.func_76125_a((int)enchantment.func_74762_e("lvl"), (int)0, (int)255) * Powershot.config.enchantmentToMultiplier.getFloat((Object)id);
            }
        }
        return power;
    }

    public static RayTraceResult trace(World world, RayTraceContext context, AbstractArrowEntity arrow) {
        if (world.field_72995_K) {
            return world.func_217299_a(context);
        }
        LazyOptional powerable = arrow.getCapability(PowerableCapability.instance);
        BiFunction<RayTraceContext, BlockPos, RayTraceResult> traceFn = (traceContext, position) -> {
            BlockRayTraceResult result;
            Vec3d start = traceContext.func_222253_b();
            Vec3d end = traceContext.func_222250_a();
            ISelectionContext entityContext = traceContext.field_222258_e;
            BlockState state = world.func_180495_p(position);
            VoxelShape shape = state.func_215685_b((IBlockReader)world, position, entityContext);
            BreakableBlockStateProperties properties = Powershot.config.breakableStateToProperties.get(state);
            if (properties == null) {
                result = world.func_217296_a(start, end, position, shape, state);
            } else {
                boolean breakable;
                boolean bl = breakable = ((Float)powerable.map(PowerableCapability.IPowerable::getPower).orElse((Object)Float.valueOf(0.0f))).floatValue() >= properties.powerRequirement;
                if (breakable && shape.func_197766_b()) {
                    shape = state.func_215700_a((IBlockReader)world, position, entityContext);
                }
                result = world.func_217296_a(start, end, position, shape, state);
                if (breakable && result != null) {
                    world.func_225521_a_(position, true, arrow.func_212360_k());
                    powerable.ifPresent(p -> p.setPower(p.getPower() - properties.powerReduction));
                    result = null;
                }
            }
            if (result != null) {
                powerable.ifPresent(p -> p.setPower(0.0f));
            }
            return result;
        };
        Function<RayTraceContext, RayTraceResult> missFn = traceContext -> {
            Vec3d start = traceContext.func_222253_b();
            Vec3d end = traceContext.func_222250_a();
            Vec3d dir = start.func_178788_d(end);
            return BlockRayTraceResult.func_216352_a((Vec3d)end, (Direction)Direction.func_210769_a((double)dir.field_72450_a, (double)dir.field_72448_b, (double)dir.field_72449_c), (BlockPos)new BlockPos(start));
        };
        return (RayTraceResult)IBlockReader.func_217300_a((RayTraceContext)context, traceFn, missFn);
    }
}

