function initializeCoreMod() {
    return {
        "abstractarrowentity::shoot": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.projectile.AbstractArrowEntity",
                "methodName": "func_70186_c",
                "methodDesc": "(DDDFF)V"
            },
            "transformer": function (methodNode) {
                var ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");

                ASMAPI.log("DEBUG", "Running Powershot transformer");

                var InsnList = Java.type("org.objectweb.asm.tree.InsnList");
                var MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");
                var VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
                var Opcodes = Java.type("org.objectweb.asm.Opcodes");

                var insns = new InsnList();
                insns.add(new VarInsnNode(Opcodes.ALOAD, 0));
                insns.add(new VarInsnNode(Opcodes.FLOAD, 7));
                insns.add(new MethodInsnNode(
                    Opcodes.INVOKESTATIC,
                    "com/gitlab/qolq/powershot/Powershot",
                    "setPower",
                    "(Lnet/minecraft/entity/projectile/AbstractArrowEntity;F)V"
                ));

                ASMAPI.log("TRACE", "Inserting new instructions");
                methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), insns);

                return methodNode;
            }
        },
        "abstractarrowentity::tick": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.projectile.AbstractArrowEntity",
                "methodName": "func_70071_h_",
                "methodDesc": "()V"
            },
            "transformer": function (methodNode) {
                var ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");

                ASMAPI.log("DEBUG", "Running Powershot transformer");

                var InsnList = Java.type("org.objectweb.asm.tree.InsnList");
                var MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");
                var VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
                var Opcodes = Java.type("org.objectweb.asm.Opcodes");

                var insns = new InsnList();
                insns.add(new VarInsnNode(Opcodes.ALOAD, 0));
                insns.add(new MethodInsnNode(
                    Opcodes.INVOKESTATIC,
                    "com/gitlab/qolq/powershot/Powershot",
                    "trace",
                    "(Lnet/minecraft/world/World;" +
                    "Lnet/minecraft/util/math/RayTraceContext;" +
                    "Lnet/minecraft/entity/projectile/AbstractArrowEntity;)" +
                    "Lnet/minecraft/util/math/RayTraceResult;"
                ));

                ASMAPI.log("TRACE", "Inserting new instructions");
                var inserted = ASMAPI.insertInsnList(
                    methodNode,
                    ASMAPI.MethodType.VIRTUAL,
                    "net/minecraft/world/World",
                    ASMAPI.mapMethod("func_217299_a"), // rayTraceBlocks
                    "(Lnet/minecraft/util/math/RayTraceContext;)Lnet/minecraft/util/math/BlockRayTraceResult;",
                    insns,
                    ASMAPI.InsertMode.REMOVE_ORIGINAL
                );

                if (!inserted)
                    ASMAPI.log("WARN", "Marker instruction not found. Method not modified.");

                return methodNode;
            }
        }
    }
}
