/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3503;
import net.minecraft.class_5323;

public final class StateToPropertyHashMap {
    private volatile Map<class_2680, BreakableBlockStateProperties> merged;
    final Map<class_2680, BreakableBlockStateProperties> states;
    final Map<class_2960, BreakableBlockStateProperties> tags;

    private StateToPropertyHashMap(Map<class_2680, BreakableBlockStateProperties> states, Map<class_2960, BreakableBlockStateProperties> tags) {
        this.states = Collections.unmodifiableMap(states);
        this.tags = Collections.unmodifiableMap(tags);
        this.reloadTags();
    }

    public BreakableBlockStateProperties get(class_2680 key) {
        return this.merged.get(key);
    }

    public synchronized void reloadTags() {
        class_3503 collection = class_5323.method_29223().method_29218();
        HashMap<class_2680, BreakableBlockStateProperties> map = new HashMap<class_2680, BreakableBlockStateProperties>();
        for (Map.Entry<class_2960, BreakableBlockStateProperties> entry : this.tags.entrySet()) {
            class_3494 tag = collection.method_15193(entry.getKey());
            if (tag == null) continue;
            for (class_2248 block : tag.method_15138()) {
                for (class_2680 state : block.method_9595().method_11662()) {
                    map.put(state, entry.getValue());
                }
            }
        }
        map.putAll(this.states);
        this.merged = Collections.unmodifiableMap(map);
    }

    public int statesSize() {
        return this.states.size();
    }

    public int tagsSize() {
        return this.tags.size();
    }

    public static final class Builder {
        private final Map<class_2680, BreakableBlockStateProperties> states = new HashMap<class_2680, BreakableBlockStateProperties>();
        private final Map<class_2960, BreakableBlockStateProperties> tags = new LinkedHashMap<class_2960, BreakableBlockStateProperties>();

        public void put(class_2680 state, BreakableBlockStateProperties properties) {
            this.states.put(state, properties);
        }

        public void put(class_2248 block, BreakableBlockStateProperties properties) {
            for (class_2680 state : block.method_9595().method_11662()) {
                this.put(state, properties);
            }
        }

        public void put(class_2960 tag, BreakableBlockStateProperties properties) {
            this.tags.put(tag, properties);
        }

        public void put(class_3494.class_5123<class_2248> tag, BreakableBlockStateProperties properties) {
            this.put(tag.method_26791(), properties);
        }

        public StateToPropertyHashMap build() {
            return new StateToPropertyHashMap(this.states, this.tags);
        }
    }
}

