/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.StateToPropertyHashMap;
import com.google.common.collect.HashMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public final class StateToPropertyHashMapSerializer
implements JsonDeserializer<StateToPropertyHashMap>,
JsonSerializer<StateToPropertyHashMap> {
    private static final String BLOCKS_KEY = "blocks";
    private static final String BLOCK_ID_KEY = "id";
    private static final String BLOCK_STATES_KEY = "states";
    private static final String TAGS_KEY = "tags";
    private static final String POWER_REQUIREMENT_KEY = "power_req";
    private static final String POWER_REDUCTION_KEY = "power_red";
    private static final String NORMAL_BLOCK_STATE_ENTRY = "normal";

    public StateToPropertyHashMap deserialize(JsonElement source, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonArray jsonEntries = class_3518.method_15252((JsonElement)source, (String)"top-level element");
        StateToPropertyHashMap.Builder builder = new StateToPropertyHashMap.Builder();
        for (JsonElement jsonEntry : jsonEntries) {
            try {
                this.deserializeTopLevelEntry(class_3518.method_15295((JsonElement)jsonEntry, (String)"top-level entry"), builder);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing top-level entry", (Throwable)e);
            }
        }
        return builder.build();
    }

    private void deserializeTopLevelEntry(JsonObject jsonEntry, StateToPropertyHashMap.Builder builder) {
        JsonElement jsonBlocks = jsonEntry.get(BLOCKS_KEY);
        JsonElement jsonTags = jsonEntry.get(TAGS_KEY);
        if (jsonBlocks == null && jsonTags == null) {
            Powershot.log.warn("Invalid top-level entry: no blocks or tags specified -> {}", (Object)jsonEntry);
            return;
        }
        BreakableBlockStateProperties properties = new BreakableBlockStateProperties(class_3518.method_15277((JsonObject)jsonEntry, (String)POWER_REQUIREMENT_KEY, (float)1.5f), class_3518.method_15277((JsonObject)jsonEntry, (String)POWER_REDUCTION_KEY, (float)1.5f));
        if (jsonBlocks != null) {
            try {
                for (class_2680 state : this.deserializeBlockEntries(jsonBlocks)) {
                    builder.put(state, properties);
                }
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing block entries", (Throwable)e);
            }
        }
        if (jsonTags != null) {
            try {
                for (class_2960 tag : this.deserializeTagEntries(jsonTags)) {
                    builder.put(tag, properties);
                }
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing tag entries", (Throwable)e);
            }
        }
    }

    private class_2960 deserializeIdentifier(JsonElement json, String name) {
        try {
            return new class_2960(class_3518.method_15287((JsonElement)json, (String)name));
        }
        catch (class_151 e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private Set<class_2960> deserializeTagEntries(JsonElement jsonTags) {
        if (jsonTags.isJsonArray()) {
            HashSet<class_2960> tags = new HashSet<class_2960>();
            for (JsonElement jsonTag : jsonTags.getAsJsonArray()) {
                try {
                    tags.add(this.deserializeIdentifier(jsonTag, "block tag entry"));
                }
                catch (JsonParseException e) {
                    Powershot.log.warn("Error while parsing tag entry", (Throwable)e);
                }
            }
            return tags;
        }
        return Collections.singleton(this.deserializeIdentifier(jsonTags, "block tag entry"));
    }

    private Set<class_2680> deserializeBlockEntries(JsonElement jsonBlocks) {
        if (jsonBlocks.isJsonObject()) {
            return this.deserializeObjectBlockEntry(jsonBlocks.getAsJsonObject());
        }
        if (jsonBlocks.isJsonArray()) {
            return this.deserializeArrayBlockEntry(jsonBlocks.getAsJsonArray());
        }
        if (jsonBlocks.isJsonPrimitive()) {
            return this.deserializeStringBlockEntry(jsonBlocks.getAsJsonPrimitive());
        }
        Powershot.log.warn("Invalid block entry: was not a string, an object, nor an array -> {}", (Object)jsonBlocks);
        return Collections.emptySet();
    }

    private Set<class_2680> deserializeArrayBlockEntry(JsonArray jsonBlocks) {
        HashSet<class_2680> states = new HashSet<class_2680>();
        for (JsonElement jsonBlock : jsonBlocks) {
            try {
                if (jsonBlock.isJsonObject()) {
                    states.addAll(this.deserializeObjectBlockEntry(jsonBlock.getAsJsonObject()));
                    continue;
                }
                if (jsonBlock.isJsonPrimitive()) {
                    states.addAll(this.deserializeStringBlockEntry(jsonBlock.getAsJsonPrimitive()));
                    continue;
                }
                Powershot.log.warn("Invalid block entry: was neither a string nor an object -> {}", (Object)jsonBlock);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing block entry", (Throwable)e);
            }
        }
        return states;
    }

    private Set<class_2680> deserializeStringBlockEntry(JsonPrimitive jsonBlock) {
        class_2960 id = this.deserializeIdentifier((JsonElement)jsonBlock, "block entry");
        if (class_2378.field_11146.method_10250(id)) {
            return new HashSet<class_2680>((Collection<class_2680>)((class_2248)class_2378.field_11146.method_10223(id)).method_9595().method_11662());
        }
        Powershot.log.warn("Invalid block entry: '{}' is not a registered block", (Object)id);
        return Collections.emptySet();
    }

    private Set<class_2680> deserializeObjectBlockEntry(JsonObject jsonBlock) {
        JsonElement jsonId = jsonBlock.get(BLOCK_ID_KEY);
        if (jsonId == null) {
            Powershot.log.warn("Invalid block entry: no block id specified -> {}", (Object)jsonBlock);
            return Collections.emptySet();
        }
        class_2960 id = this.deserializeIdentifier(jsonId, "block id entry");
        if (!class_2378.field_11146.method_10250(id)) {
            Powershot.log.warn("Invalid block entry: '{}' is not a registered block", (Object)id);
            return Collections.emptySet();
        }
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(id);
        JsonElement jsonStates = jsonBlock.get(BLOCK_STATES_KEY);
        if (jsonStates == null) {
            return new HashSet<class_2680>((Collection<class_2680>)block.method_9595().method_11662());
        }
        class_2689 stateContainer = block.method_9595();
        HashSet<class_2680> states = new HashSet<class_2680>();
        for (JsonElement jsonState : class_3518.method_15252((JsonElement)jsonStates, (String)"block states entry")) {
            try {
                String stringState = class_3518.method_15287((JsonElement)jsonState, (String)"block state entry");
                class_2680 state = this.deserializeBlockStateEntry(stringState, (class_2689<class_2248, class_2680>)stateContainer, id);
                if (state == null) continue;
                states.add(state);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing '" + id + "' state entry -> " + jsonState, (Throwable)e);
            }
        }
        return states;
    }

    private <T extends Comparable<T>> class_2680 deserializeBlockStateEntry(String stringState, class_2689<class_2248, class_2680> container, class_2960 block) {
        if (NORMAL_BLOCK_STATE_ENTRY.equals(stringState)) {
            return (class_2680)container.method_11664();
        }
        String[] stringProperties = stringState.split(",");
        class_2680 state = (class_2680)container.method_11664();
        for (String stringProperty : stringProperties) {
            String[] propertyAndValueNames = stringProperty.split("=");
            if (propertyAndValueNames.length != 2) {
                Powershot.log.warn("Invalid '{}' state entry: '{}' is not a property name and value pair", (Object)block, (Object)stringProperty);
                return null;
            }
            String propertyName = propertyAndValueNames[0];
            class_2769 property = container.method_11663(propertyName);
            if (property == null) {
                Powershot.log.warn("Invalid '{}' state entry: no property named '{}'", (Object)block, (Object)propertyName);
                return null;
            }
            String valueName = propertyAndValueNames[1];
            Comparable value = property.method_11900(valueName).orElse(null);
            if (value == null) {
                Powershot.log.warn("Invalid '{}' state entry: property '{}' has no value '{}'", (Object)block, (Object)propertyName, (Object)valueName);
                return null;
            }
            state = (class_2680)state.method_11657(property, value);
        }
        return state;
    }

    public JsonElement serialize(StateToPropertyHashMap source, Type type, JsonSerializationContext context) {
        JsonArray jsonEntries = new JsonArray();
        HashMultimap propsToStates = HashMultimap.create();
        HashMultimap propsToTags = HashMultimap.create();
        for (Map.Entry<class_2680, BreakableBlockStateProperties> entry : source.states.entrySet()) {
            propsToStates.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<class_2680, BreakableBlockStateProperties> entry : source.tags.entrySet()) {
            propsToTags.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        HashSet properties = new HashSet();
        properties.addAll(propsToStates.keySet());
        properties.addAll(propsToTags.keySet());
        for (BreakableBlockStateProperties property : properties) {
            JsonArray jsonBlocks = null;
            JsonArray jsonTags = null;
            if (propsToStates.containsKey((Object)property)) {
                jsonBlocks = this.serializeBlockEntry(propsToStates.get((Object)property));
            }
            if (propsToTags.containsKey((Object)property)) {
                jsonTags = this.serializeTagEntry(propsToTags.get((Object)property));
            }
            jsonEntries.add((JsonElement)this.serializeTopLevelEntry(jsonBlocks, jsonTags, property));
        }
        return jsonEntries;
    }

    private JsonObject serializeTopLevelEntry(JsonArray jsonBlocks, JsonArray jsonTags, BreakableBlockStateProperties properties) {
        JsonObject jsonEntry = new JsonObject();
        if (jsonBlocks != null) {
            jsonEntry.add(BLOCKS_KEY, (JsonElement)(jsonBlocks.size() == 1 ? jsonBlocks.get(0) : jsonBlocks));
        }
        if (jsonTags != null) {
            jsonEntry.add(TAGS_KEY, (JsonElement)(jsonTags.size() == 1 ? jsonTags.get(0) : jsonTags));
        }
        if (properties.powerRequirement != 1.5f) {
            jsonEntry.addProperty(POWER_REQUIREMENT_KEY, (Number)Float.valueOf(properties.powerRequirement));
        }
        if (properties.powerReduction != 1.5f) {
            jsonEntry.addProperty(POWER_REDUCTION_KEY, (Number)Float.valueOf(properties.powerReduction));
        }
        return jsonEntry;
    }

    private JsonArray serializeTagEntry(Collection<class_2960> tags) {
        JsonArray jsonTags = new JsonArray();
        for (class_2960 tag : tags) {
            jsonTags.add(tag.toString());
        }
        return jsonTags;
    }

    private JsonArray serializeBlockEntry(Collection<class_2680> states) {
        JsonArray jsonBlocks = new JsonArray();
        HashMultimap idToStates = HashMultimap.create();
        for (class_2680 class_26802 : states) {
            idToStates.put((Object)class_2378.field_11146.method_10221((Object)class_26802.method_26204()), (Object)class_26802);
        }
        for (Map.Entry entry : idToStates.asMap().entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(id);
            states = (Collection)entry.getValue();
            if (states.containsAll((Collection<?>)block.method_9595().method_11662())) {
                jsonBlocks.add(id.toString());
                continue;
            }
            JsonArray stringStates = new JsonArray();
            for (class_2680 state : states) {
                stringStates.add((JsonElement)this.serializeBlockStateEntry((Map<class_2769<?>, Comparable<?>>)state.method_11656()));
            }
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty(BLOCK_ID_KEY, id.toString());
            jsonBlock.add(BLOCK_STATES_KEY, (JsonElement)stringStates);
            jsonBlocks.add((JsonElement)jsonBlock);
        }
        return jsonBlocks;
    }

    private <T extends Comparable<T>> JsonPrimitive serializeBlockStateEntry(Map<class_2769<?>, Comparable<?>> props) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : props.entrySet()) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            class_2769<?> property = entry.getKey();
            builder.append(property.method_11899()).append("=").append(property.method_11901(entry.getValue()));
        }
        if (builder.length() == 0) {
            builder.append(NORMAL_BLOCK_STATE_ENTRY);
        }
        return new JsonPrimitive(builder.toString());
    }
}

