/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Configuration;
import com.gitlab.qolq.powershot.IPowerable;
import com.gitlab.qolq.powershot.mixin.IRayTraceContextAccessor;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="powershot")
public final class Powershot {
    public static final String MOD_ID = "powershot";
    static final Logger log = LogManager.getLogger((String)"powershot");
    private static Configuration config;

    public Powershot() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        Path dir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        log.debug("Loading configs from {}", (Object)dir);
        config = new Configuration(dir);
        config.init();
    }

    public static float calculatePower(AbstractArrowEntity arrow, float speed) {
        LivingEntity livingShooter;
        ItemStack stack;
        float power = Powershot.config.basePower * speed;
        Entity shooter = arrow.func_234616_v_();
        if (shooter instanceof LivingEntity && !(stack = (livingShooter = (LivingEntity)shooter).func_184586_b(livingShooter.func_184600_cs())).func_190926_b()) {
            ListNBT enchantments = stack.func_77986_q();
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundNBT enchantment = enchantments.func_150305_b(i);
                ResourceLocation id = ResourceLocation.func_208304_a((String)enchantment.func_74779_i("id"));
                if (id == null || !Powershot.config.enchantmentToMultiplier.containsKey((Object)id)) continue;
                power += (float)MathHelper.func_76125_a((int)enchantment.func_74762_e("lvl"), (int)0, (int)255) * Powershot.config.enchantmentToMultiplier.getFloat((Object)id);
            }
        }
        return power;
    }

    public static BlockRayTraceResult trace(World world, RayTraceContext context, AbstractArrowEntity arrow) {
        if (world.field_72995_K) {
            return world.func_217299_a(context);
        }
        IPowerable powerable = (IPowerable)arrow;
        BiFunction<RayTraceContext, BlockPos, BlockRayTraceResult> traceFn = (traceContext, position) -> {
            BlockRayTraceResult result;
            Vector3d start = traceContext.func_222253_b();
            Vector3d end = traceContext.func_222250_a();
            ISelectionContext entityContext = ((IRayTraceContextAccessor)traceContext).getEntityContext();
            BlockState state = world.func_180495_p(position);
            VoxelShape shape = state.func_215685_b((IBlockReader)world, position, entityContext);
            BreakableBlockStateProperties properties = Powershot.config.breakableStateToProperties.get(state);
            if (properties == null) {
                result = world.func_217296_a(start, end, position, shape, state);
            } else {
                boolean breakable;
                boolean bl = breakable = powerable.getPower() >= properties.powerRequirement;
                if (breakable && shape.func_197766_b()) {
                    shape = state.func_215700_a((IBlockReader)world, position, entityContext);
                }
                result = world.func_217296_a(start, end, position, shape, state);
                if (breakable && result != null) {
                    world.func_225521_a_(position, true, arrow.func_234616_v_());
                    powerable.setPower(powerable.getPower() - properties.powerReduction);
                    result = null;
                }
            }
            if (result != null) {
                powerable.setPower(0.0f);
            }
            return result;
        };
        Function<RayTraceContext, BlockRayTraceResult> missFn = traceContext -> {
            Vector3d start = traceContext.func_222253_b();
            Vector3d end = traceContext.func_222250_a();
            Vector3d dir = start.func_178788_d(end);
            return BlockRayTraceResult.func_216352_a((Vector3d)end, (Direction)Direction.func_210769_a((double)dir.field_72450_a, (double)dir.field_72448_b, (double)dir.field_72449_c), (BlockPos)new BlockPos(start));
        };
        return (BlockRayTraceResult)IBlockReader.func_217300_a((RayTraceContext)context, traceFn, missFn);
    }
}

