/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Structures.Config.Enums.AdvancedCoopOptions;
import com.wuest.prefab.Structures.Config.Enums.AdvancedHorseStableOptions;
import com.wuest.prefab.Structures.Config.Enums.AquaBaseOptions;
import com.wuest.prefab.Structures.Config.Enums.BarnOptions;
import com.wuest.prefab.Structures.Config.Enums.BaseOption;
import com.wuest.prefab.Structures.Config.Enums.DefenseBunkerOptions;
import com.wuest.prefab.Structures.Config.Enums.EnderGatewayOptions;
import com.wuest.prefab.Structures.Config.Enums.GrassyPlainOptions;
import com.wuest.prefab.Structures.Config.Enums.GreenHouseOptions;
import com.wuest.prefab.Structures.Config.Enums.JailOptions;
import com.wuest.prefab.Structures.Config.Enums.MachineryTowerOptions;
import com.wuest.prefab.Structures.Config.Enums.MagicTempleOptions;
import com.wuest.prefab.Structures.Config.Enums.MineshaftEntranceOptions;
import com.wuest.prefab.Structures.Config.Enums.NetherGateOptions;
import com.wuest.prefab.Structures.Config.Enums.SaloonOptions;
import com.wuest.prefab.Structures.Config.Enums.SkiLodgeOptions;
import com.wuest.prefab.Structures.Config.Enums.TownHallOptions;
import com.wuest.prefab.Structures.Config.Enums.WatchTowerOptions;
import com.wuest.prefab.Structures.Config.Enums.WelcomeCenterOptions;
import com.wuest.prefab.Structures.Config.Enums.WindMillOptions;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Items.ItemBasicStructure;
import com.wuest.prefab.Structures.Predefined.StructureBasic;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static String structureEnumNameTag = "structureEnumName";
    private static String structureDisplayNameTag = "structureDisplayName";
    private static String bedColorTag = "bedColor";
    private static String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public DyeColor bedColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getUnlocalizedName();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = Direction.NORTH;
        this.basicStructureName = EnumBasicStructureName.AdvancedCoop;
        this.bedColor = DyeColor.RED;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions().get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.func_74764_b(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.func_74779_i(structureEnumNameTag));
        }
        if (messageTag.func_74764_b(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.func_74779_i(structureDisplayNameTag);
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            basicConfig.bedColor = DyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
        if (messageTag.func_74764_b(chosenOptionTag)) {
            basicConfig.basicStructureName.baseOption;
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.func_74779_i(chosenOptionTag));
        }
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74778_a(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.func_74778_a(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        tag.func_74778_a(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (stack.func_190916_E() == 1) {
                player.field_71071_by.func_184437_d(stack);
            } else {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            player.field_71070_bA.func_75142_b();
        }
    }

    static {
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(10);
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(11);
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearShape().setLength(11);
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AdvancedCoop.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(5);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(8);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(17);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearShape().setLength(34);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AdvancedHorseStable.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(10);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(30);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearShape().setLength(35);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Barn.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(15);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(12);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(16);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearShape().setLength(16);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MachineryTower.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(17);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(32);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearShape().setLength(32);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.DefenseBunker.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(15);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(6);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(7);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearShape().setLength(7);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MineshaftEntrance.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(3);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(26);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(17);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearShape().setLength(17);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.EnderGateway.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(27);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(25);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearShape().setLength(38);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AquaBase.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(12);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(4);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(15);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearShape().setLength(15);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.GrassyPlain.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(13);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(12);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearShape().setLength(13);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MagicTemple.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(6);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(10);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(16);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearShape().setLength(32);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.GreenHouse.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(16);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(9);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearShape().setLength(9);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.WatchTower.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(4);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(24);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(19);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearShape().setLength(48);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(5);
        EnumBasicStructureName.WelcomeCenter.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-5);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(14);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(28);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearShape().setLength(33);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(25);
        EnumBasicStructureName.Jail.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-3);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(14);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(18);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearShape().setLength(16);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(10);
        EnumBasicStructureName.Saloon.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(25);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(46);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearShape().setLength(35);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(20);
        EnumBasicStructureName.SkiLodge.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(31);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(17);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearShape().setLength(13);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.WindMill.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(12);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(27);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearShape().setLength(27);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(20);
        EnumBasicStructureName.TownHall.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearShape().setHeight(13);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearShape().setLength(26);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearShape().setWidth(15);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setEastOffset(7);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(0).getClearPositionOffset().setHeightOffset(-2);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearShape().setDirection(Direction.SOUTH);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearShape().setHeight(20);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearShape().setLength(16);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearShape().setWidth(16);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearPositionOffset().setEastOffset(9);
        EnumBasicStructureName.NetherGate.baseOption.getSpecificOptions().get(1).getClearPositionOffset().setHeightOffset(-7);
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null),
        AdvancedCoop("advancedcoop", "item.prefab.advanced.chicken.coop", "item_advanced_chicken_coop", AdvancedCoopOptions.Default),
        AdvancedHorseStable("advanced_horse_stable", "item.prefab.advanced.horse.stable", "item_advanced_horse_stable", AdvancedHorseStableOptions.Default),
        Barn("barn", "item.prefab.barn", "item_barn", BarnOptions.Default),
        MachineryTower("machinery_tower", "item.prefab.machinery.tower", "item_machinery_tower", MachineryTowerOptions.Default),
        DefenseBunker("defense_bunker", "item.prefab.defense.bunker", "item_defense_bunker", DefenseBunkerOptions.Default),
        MineshaftEntrance("mineshaft_entrance", "item.prefab.mineshaft.entrance", "item_mineshaft_entrance", MineshaftEntranceOptions.Default),
        EnderGateway("ender_gateway", "item.prefab.ender_gateway", "item_ender_gateway", EnderGatewayOptions.Default),
        AquaBase("aqua_base", "item.prefab.aqua_base", "item_aqua_base", AquaBaseOptions.Default),
        GrassyPlain("grassy_plain", "item.prefab.grassy_plain", "item_grassy_plain", GrassyPlainOptions.Default),
        MagicTemple("magic_temple", "item.prefab.magic_temple", "item_magic_temple", MagicTempleOptions.Default),
        GreenHouse("green_house", "item.prefab.green_house", "item_green_house", GreenHouseOptions.Default),
        WatchTower("watch_tower", "item.prefab.watch_tower", "item_watch_tower", WatchTowerOptions.Default),
        WelcomeCenter("welcome_center", "item.prefab.welcome_center", "item_welcome_center", WelcomeCenterOptions.Default),
        Jail("jail", "item.prefab.jail", "item_jail", JailOptions.Default),
        Saloon("saloon", "item.prefab.saloon", "item_saloon", SaloonOptions.Default),
        SkiLodge("ski_lodge", "item.prefab.ski_lodge", "item_ski_lodge", SkiLodgeOptions.Default),
        WindMill("wind_mill", "item.prefab.wind_mill", "item_wind_mill", WindMillOptions.Default),
        TownHall("town_hall", "item.prefab.town_hall", "item_town_hall", TownHallOptions.Default),
        NetherGate("nether_gate", "item.prefab.nether_gate", "item_nether_gate", NetherGateOptions.AncientSkull);

        private String name;
        private String unlocalizedName;
        private ResourceLocation resourceLocation;
        private BaseOption baseOption;

        private EnumBasicStructureName(String name, String unlocalizedName, String resourceLocation, BaseOption baseOption) {
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            if (resourceLocation != null) {
                this.resourceLocation = new ResourceLocation("prefab", resourceLocation);
            }
            this.baseOption = baseOption;
        }

        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }
    }
}

