/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Base.EnumStairsMaterial;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.StructurePartConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructurePart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiStructurePart
extends GuiStructure {
    protected StructurePartConfiguration configuration;
    private Slider sldrStairWidth;
    private Slider sldrStairHeight;
    private Slider sldrGeneralWidth;
    private Slider sldrGeneralHeight;
    private ExtendedButton btnPartStyle;
    private ExtendedButton btnMaterialType;
    private ExtendedButton btnStairsMaterialType;

    public GuiStructurePart() {
        super("Structure Part");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Parts;
        this.modifiedInitialXAxis = 213;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Parts", StructurePartConfiguration.class);
        this.configuration.pos = this.pos;
        Tuple<Integer, Integer> adjustedValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedValue.getFirst();
        int grayBoxY = adjustedValue.getSecond();
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.sldrStairHeight = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 1.0, 9.0, this.configuration.stairHeight, false, true, this::buttonClicked);
        this.sldrStairWidth = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 1.0, 9.0, this.configuration.stairWidth, false, true, this::buttonClicked);
        this.sldrGeneralHeight = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 3.0, 9.0, this.configuration.generalHeight, false, true, this::buttonClicked);
        this.sldrGeneralWidth = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 3.0, 9.0, this.configuration.generalWidth, false, true, this::buttonClicked);
        this.btnPartStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString(this.configuration.style.translateKey));
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.partMaterial.getTranslatedName());
        this.btnStairsMaterialType = this.createAndAddButton(grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.stairsMaterial.getTranslatedName());
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(this.configuration.style.getPictureLocation());
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, this.configuration.style.imageWidth, this.configuration.style.imageHeight, this.configuration.style.imageWidth, this.configuration.style.imageHeight);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.style"), x + 10, y + 10, this.textColor);
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.material"), x + 147, y + 10, this.textColor);
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Stairs || this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.sldrStairHeight.field_230694_p_ = this.configuration.style != StructurePartConfiguration.EnumStyle.Roof;
            this.sldrStairWidth.field_230694_p_ = true;
            this.sldrGeneralHeight.field_230694_p_ = false;
            this.sldrGeneralWidth.field_230694_p_ = false;
            this.btnStairsMaterialType.field_230694_p_ = true;
            this.btnMaterialType.field_230694_p_ = false;
        } else {
            this.btnStairsMaterialType.field_230694_p_ = false;
            this.btnMaterialType.field_230694_p_ = true;
            this.sldrStairHeight.field_230694_p_ = false;
            this.sldrStairWidth.field_230694_p_ = false;
            this.sldrGeneralHeight.field_230694_p_ = true;
            this.sldrGeneralWidth.field_230694_p_ = true;
        }
        if (this.configuration.style != StructurePartConfiguration.EnumStyle.Roof) {
            if (this.configuration.style == StructurePartConfiguration.EnumStyle.Floor) {
                this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.length"), x + 147, y + 90, this.textColor);
            } else {
                this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.height"), x + 147, y + 90, this.textColor);
            }
        }
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.height"), x + 147, y + 50, this.textColor);
        } else {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.width"), x + 147, y + 50, this.textColor);
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.configuration.houseFacing = this.field_230706_i_.field_71439_g.func_174811_aO().func_176734_d();
        this.configuration.stairHeight = this.sldrStairHeight.getValueInt();
        this.configuration.stairWidth = this.sldrStairWidth.getValueInt();
        this.configuration.generalHeight = this.sldrGeneralHeight.getValueInt();
        this.configuration.generalWidth = this.sldrGeneralWidth.getValueInt();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnMaterialType) {
            this.configuration.partMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.partMaterial.getNumber() + 1);
            this.btnMaterialType.func_238482_a_((ITextComponent)new StringTextComponent(this.configuration.partMaterial.getTranslatedName()));
        }
        if (button == this.btnStairsMaterialType) {
            this.configuration.stairsMaterial = EnumStairsMaterial.getByOrdinal(this.configuration.stairsMaterial.ordinal() + 1);
            this.btnStairsMaterialType.func_238482_a_((ITextComponent)new StringTextComponent(this.configuration.stairsMaterial.getTranslatedName()));
        } else if (button == this.btnPartStyle) {
            this.configuration.style = StructurePartConfiguration.EnumStyle.getByOrdinal(this.configuration.style.ordinal() + 1);
            this.btnPartStyle.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateString(this.configuration.style.translateKey)));
        } else if (button == this.btnVisualize) {
            StructurePart structure = new StructurePart();
            structure.getClearSpace().getShape().setDirection(Direction.NORTH);
            structure.setupStructure((World)this.field_230706_i_.field_71441_e, this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, Direction.SOUTH, this.configuration);
            this.func_231175_as__();
        }
    }
}

