/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<vk, vk> textureLocations = null;
    private NbtTagValue nbtName = null;
    private bss[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bku[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bku[] COLORS_INVALID = new bku[0];
    private static final vk ANVIL_GUI_TEXTURE = new vk("textures/gui/container/anvil.png");
    private static final vk BEACON_GUI_TEXTURE = new vk("textures/gui/container/beacon.png");
    private static final vk BREWING_STAND_GUI_TEXTURE = new vk("textures/gui/container/brewing_stand.png");
    private static final vk CHEST_GUI_TEXTURE = new vk("textures/gui/container/generic_54.png");
    private static final vk CRAFTING_TABLE_GUI_TEXTURE = new vk("textures/gui/container/crafting_table.png");
    private static final vk HORSE_GUI_TEXTURE = new vk("textures/gui/container/horse.png");
    private static final vk DISPENSER_GUI_TEXTURE = new vk("textures/gui/container/dispenser.png");
    private static final vk ENCHANTMENT_TABLE_GUI_TEXTURE = new vk("textures/gui/container/enchanting_table.png");
    private static final vk FURNACE_GUI_TEXTURE = new vk("textures/gui/container/furnace.png");
    private static final vk HOPPER_GUI_TEXTURE = new vk("textures/gui/container/hopper.png");
    private static final vk INVENTORY_GUI_TEXTURE = new vk("textures/gui/container/inventory.png");
    private static final vk SHULKER_BOX_GUI_TEXTURE = new vk("textures/gui/container/shulker_box.png");
    private static final vk VILLAGER_GUI_TEXTURE = new vk("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bku[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        bku[] cols = new bku[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            bku col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static bku parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bku[] colors = bku.values();
        for (int i = 0; i < colors.length; ++i) {
            bku enumDyeColor = colors[i];
            if (enumDyeColor.a().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.c().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static vk parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new vk(basePath + "/" + tex);
    }

    private static Map<vk, vk> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<vk, vk> map = new HashMap<vk, vk>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            vk locKey = CustomGuiProperties.getGuiTextureLocation(container);
            vk locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            vk locKey = new vk(path);
            vk locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static vk getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, fx pos, brw blockAccess) {
        bss biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.v(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, fx pos, brw blockAccess, doq screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, (bqx)blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, (bqx)blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, (bqx)blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, (bqx)blockAccess);
            }
        }
        return true;
    }

    public static String getName(doq screen) {
        nr itc = screen.w();
        if (itc == null) {
            return null;
        }
        return itc.a();
    }

    private boolean matchesBeacon(fx pos, bqx blockAccess) {
        int l2;
        ccg te = blockAccess.c(pos);
        if (!(te instanceof ccb)) {
            return false;
        }
        ccb teb = (ccb)te;
        return this.levels == null || this.levels.isInRange(l2 = teb.h());
    }

    private boolean matchesChest(fx pos, bqx blockAccess) {
        ccg te = blockAccess.c(pos);
        if (te instanceof cck) {
            cck tec = (cck)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof ccs) {
            ccs teec = (ccs)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(cck tec, fx pos, bqx blockAccess) {
        cee blockState = blockAccess.d_(pos);
        cew chestType = blockState.b((cfg)bvb.c) ? (cew)blockState.c((cfg)bvb.c) : cew.a;
        boolean isLarge = chestType == cew.a;
        boolean isTrapped = tec instanceof cdk;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(ccs teec, fx pos, bqx blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(fx pos, bqx blockAccess) {
        EnumVariant var;
        ccg te = blockAccess.c(pos);
        if (!(te instanceof ccp)) {
            return false;
        }
        ccp ted = (ccp)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(ccp ted) {
        if (ted instanceof ccq) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(fx pos, bqx blockAccess) {
        bku col;
        ccg te = blockAccess.c(pos);
        if (!(te instanceof cdb)) {
            return false;
        }
        cdb tesb = (cdb)te;
        return this.colors == null || Config.equalsOne(col = tesb.k(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, apx entity, brw blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.cA(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.bT())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, (bqx)blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, (bqx)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(apx entity, bqx blockAccess) {
        int level;
        bfh vd;
        bfj vp;
        if (!(entity instanceof bfg)) {
            return false;
        }
        bfg entityVillager = (bfg)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.eX()).b(), level = vd.c(), this.professions);
    }

    private boolean matchesHorse(apx entity, bqx blockAccess) {
        bbb el;
        bku col;
        EnumVariant var;
        if (!(entity instanceof bay)) {
            return false;
        }
        bay ah = (bay)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof bbb) || Config.equalsOne(col = (el = (bbb)ah).fy(), this.colors);
    }

    private EnumVariant getHorseVariant(bay entity) {
        if (entity instanceof bba) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof baz) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof bbd) {
            return EnumVariant.MULE;
        }
        if (entity instanceof bbb) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public vk getTextureLocation(vk loc) {
        vk locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

