/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.util.Either;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<aqb, eem> originalEntityRenderMap = null;
    private static Map<cch, ebw> originalTileEntityRenderMap = null;
    private static Map<bzs.a, dun> originalSkullModelMap = null;

    public static void update() {
        Map<aqb, eem> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<cch, ebw> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map<bzs.a, dun> skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        if (!Config.isCustomEntityModels()) {
            return;
        }
        vk[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            vk loc = locs[i];
            Config.dbg("CustomEntityModel: " + loc.a());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null) continue;
            Either<aqb, cch> type = rc.getType();
            if (rc instanceof eem) {
                entityRenderMap.put(type.getLeft().get(), (eem)rc);
            } else if (rc instanceof ebw) {
                tileEntityRenderMap.put(type.getRight().get(), (ebw)rc);
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static Map<aqb, eem> getEntityRenderMap() {
        eel rm = djw.B().ab();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<aqb, eem>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<cch, ebw> getTileEntityRenderMap() {
        Map tileEntityRenderMap = ebv.a.f;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<cch, ebw>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<bzs.a, dun> getSkullModelMap() {
        HashMap skullModelMap = (HashMap)Reflector.TileEntitySkullRenderer_MODELS.getValue();
        if (skullModelMap == null) {
            Config.warn("Field not found: TileEntitySkullRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap<bzs.a, dun>(skullModelMap);
        }
        return skullModelMap;
    }

    private static vk[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<vk> resourceLocations = new ArrayList<vk>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            vk loc = new vk(path);
            if (!Config.hasResource(loc)) continue;
            resourceLocations.add(loc);
        }
        vk[] locs = resourceLocations.toArray(new vk[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(vk location) {
        try {
            JsonObject jo = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo, location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
        catch (JsonParseException e3) {
            Config.error("" + ((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage());
            return null;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Either<aqb, cch> type = modelAdapter.getType();
        CustomEntityModels.checkNull(type, "Entity type not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        dun model;
        vk textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr2 = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr2)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            r.setLocationTextureCustom(textureLocation);
        }
        return r;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dun model, CustomModelRenderer[] modelRenderers, ModelResolver mr2) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr2)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dun model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        dwf parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                dwf[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                ObjectList childModels = parent.n;
                Iterator it = childModels.iterator();
                while (it.hasNext()) {
                    dwf mr2 = (dwf)it.next();
                    if (setMrs.contains(mr2)) continue;
                    it.remove();
                }
            }
        }
        parent.b(customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

