/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final Common COMMON = Config.register(ModConfig.Type.COMMON, Common::new);
    public static final Client CLIENT = Config.register(ModConfig.Type.CLIENT, Client::new);

    static void init() {
    }

    private static <T> T register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, T> factory) {
        Pair configPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (ForgeConfigSpec)configPair.getRight());
        return (T)configPair.getLeft();
    }

    public static final class Common {
        public final ForgeConfigSpec.BooleanValue disableWeatherCommand;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> nonWinterBiomes;

        Common(ForgeConfigSpec.Builder builder) {
            this.disableWeatherCommand = builder.comment("Should the vanilla /weather be disabled? Any changes require a world restart to take effect.").worldRestart().define("disableWeatherCommand", true);
            this.nonWinterBiomes = builder.comment("A list of biome IDs that will not be forcibly converted to frozen wastelands. Any changes requires a MC restart to take effect.").worldRestart().define("nonWinterBiomes", this::getDefaultNonWinterBiomes, this::validateNonWinterBiomes);
        }

        public Predicate<Biome> getNonWinterBiomesFilter() {
            List biomes = ((List)this.nonWinterBiomes.get()).stream().map(id -> (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(id))).collect(Collectors.toList());
            return biomeIn -> biomes.stream().noneMatch(biome -> biome == biomeIn);
        }

        private boolean validateNonWinterBiomes(Object e) {
            return e instanceof String && ForgeRegistries.BIOMES.containsKey(new ResourceLocation(e.toString()));
        }

        private List<? extends String> getDefaultNonWinterBiomes() {
            return Stream.of(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_76778_j).toString(), ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_201939_S).toString(), ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_201938_R).toString(), ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_201937_Q).toString(), ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_76779_k).toString(), ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biomes.field_185440_P).toString()).collect(Collectors.toList());
        }
    }

    public static final class Client {
        public final ForgeConfigSpec.DoubleValue fogDensity;
        public final ForgeConfigSpec.IntValue snowDensity;
        public final ForgeConfigSpec.BooleanValue snowSounds;
        public final ForgeConfigSpec.BooleanValue windSounds;
        public final ForgeConfigSpec.BooleanValue weatherRenderChanges;
        public final ForgeConfigSpec.BooleanValue skyRenderChanges;
        public final ForgeConfigSpec.IntValue fogColorDay;
        public final ForgeConfigSpec.IntValue fogColorNight;

        Client(ForgeConfigSpec.Builder builder) {
            this.fogDensity = builder.comment("How dense the fog effect during a snowstorm is.").defineInRange("fogDensity", 0.1, 0.0, 1.0);
            this.snowDensity = builder.comment("How visually dense the snow weather effect is. Normally, vanilla sets this to 5 with fast graphics, and 10 with fancy graphics.").defineInRange("snowDensity", 15, 1, 15);
            this.snowSounds = builder.comment("Enable snow (actually rain) weather sounds.").define("snowSounds", true);
            this.windSounds = builder.comment("Enable wind / snow storm weather sounds.").define("windSounds", true);
            this.fogColorDay = builder.comment("This is the fog color during the day. This is a hex color code, with 8 bits each for red, green, blue.").defineInRange("fogColorDay", 12566488, 0, 0xFFFFFF);
            this.fogColorNight = builder.comment("This is the fog color during the night. This is a hex color code, with 8 bits each for red, green, blue.").defineInRange("fogColorNight", 789529, 0, 0xFFFFFF);
            this.weatherRenderChanges = builder.comment("Changes the weather renderer to one which renders faster, denser snow. Note: this requires a world reload to take effect.").define("weatherRenderChanges", true);
            this.skyRenderChanges = builder.comment("Changes the sky renderer to one which does not render sunrise or sunset effects during a snowstorm. Note: this requires a world reload to take effect.").define("skyRenderChanges", true);
        }
    }
}

