/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.util.VanillaHacks;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="primalwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandler {
    private final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        if (((Boolean)Config.COMMON.disableWeatherCommand.get()).booleanValue()) {
            event.getCommandDispatcher().getRoot().getChildren().removeIf(node -> node.getName().equals("weather"));
            event.getCommandDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"weather").executes(source -> {
                ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Not even a command can overcome this storm... (This command is disabled by Primal Winter)"), false);
                return 0;
            }));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && event.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            ServerWorld world = (ServerWorld)event.getWorld();
            ((GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223617_t)).func_223570_a(false, world.func_73046_m());
            world.func_72912_H().func_176142_i(0);
            world.func_72912_H().func_76080_g(Integer.MAX_VALUE);
            world.func_72912_H().func_76090_f(Integer.MAX_VALUE);
            world.func_72912_H().func_76084_b(true);
            world.func_72912_H().func_76069_a(true);
        }
    }

    @SubscribeEvent
    public static void onWorldPostTick(TickEvent.WorldTickEvent event) {
        ServerWorld world;
        WorldInfo worldInfo;
        if (event.phase == TickEvent.Phase.END && event.world instanceof ServerWorld && (worldInfo = (world = (ServerWorld)event.world).func_72912_H()).func_76067_t() != WorldType.field_180272_g) {
            ServerChunkProvider chunkProvider = world.func_72863_F();
            VanillaHacks.getLoadedChunksIterable(chunkProvider.field_217237_a).forEach(chunkHolder -> {
                Optional optional = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (optional.isPresent()) {
                    Chunk chunk = (Chunk)optional.get();
                    chunkHolder.func_219274_a(chunk);
                    world.func_217381_Z().func_76319_b();
                    ChunkPos chunkPos = chunkHolder.func_219277_h();
                    if (!VanillaHacks.isOutsideSpawningRadius(chunkProvider.field_217237_a, chunkPos)) {
                        VanillaHacks.tickRainAndSnow(world, chunk);
                    }
                }
            });
        }
    }
}

