/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.client;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.client.WinterWorldRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalwinter", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class ClientForgeEventHandler {
    @SubscribeEvent
    public static void onClientWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ClientWorld && event.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WinterWorldRenderer winterRenderer = WinterWorldRenderer.get();
            if (((Boolean)Config.CLIENT.weatherRenderChanges.get()).booleanValue()) {
                event.getWorld().func_201675_m().setWeatherRenderer((IRenderHandler)winterRenderer.getWeatherHandler());
            }
            if (((Boolean)Config.CLIENT.skyRenderChanges.get()).booleanValue()) {
                event.getWorld().func_201675_m().setSkyRenderer((IRenderHandler)winterRenderer.getSkyHandler());
            }
        }
    }

    @SubscribeEvent
    public static void onClientWorldTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world != null && mc.field_71460_t != null && !mc.func_147113_T() && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WinterWorldRenderer.get().addSnowParticlesAndSound(mc, (World)world, mc.field_71460_t.func_215316_n());
        }
    }

    @SubscribeEvent
    public static void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        PlayerEntity player;
        int light;
        if (event.getInfo().func_216773_g() instanceof PlayerEntity && (light = player.field_70170_p.func_226658_a_(LightType.SKY, (player = (PlayerEntity)event.getInfo().func_216773_g()).func_180425_c())) > 3 && event.getInfo().func_216771_k().func_206886_c() == Fluids.field_204541_a && player.field_71093_bK == DimensionType.field_223227_a_) {
            event.setCanceled(true);
            event.setDensity((float)(light - 3) * ((Double)Config.CLIENT.fogDensity.get()).floatValue() / 13.0f);
        }
    }

    @SubscribeEvent
    public static void onRenderFogColors(EntityViewRenderEvent.FogColors event) {
        PlayerEntity player;
        int light;
        if (event.getInfo().func_216773_g() instanceof PlayerEntity && (light = player.field_70170_p.func_226658_a_(LightType.SKY, (player = (PlayerEntity)event.getInfo().func_216773_g()).func_180425_c())) > 3 && event.getInfo().func_216771_k().func_206886_c() == Fluids.field_204541_a && player.field_71093_bK == DimensionType.field_223227_a_) {
            float partialTicks = (float)event.getRenderPartialTicks();
            float angle = player.field_70170_p.func_72826_c(partialTicks);
            float height = MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2)));
            float delta = MathHelper.func_76131_a((float)((height + 0.4f) / 0.8f), (float)0.0f, (float)1.0f);
            int colorDay = (Integer)Config.CLIENT.fogColorDay.get();
            int colorNight = (Integer)Config.CLIENT.fogColorNight.get();
            float red = (float)(colorDay >> 16 & 0xFF) * delta + (float)(colorNight >> 16 & 0xFF) * (1.0f - delta);
            float green = (float)(colorDay >> 8 & 0xFF) * delta + (float)(colorNight >> 8 & 0xFF) * (1.0f - delta);
            float blue = (float)(colorDay & 0xFF) * delta + (float)(colorNight & 0xFF) * (1.0f - delta);
            event.setRed(red / 255.0f);
            event.setGreen(green / 255.0f);
            event.setBlue(blue / 255.0f);
        }
    }
}

