/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.client;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.client.ModParticleTypes;
import com.alcatrazescapee.primalwinter.client.ModSoundEvents;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.SkyRenderHandler;
import net.minecraftforge.client.WeatherRenderHandler;

public class WinterWorldRenderer {
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private static WinterWorldRenderer INSTANCE;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private final VertexFormat skyVertexFormat = DefaultVertexFormats.field_181705_e;
    private int rainSoundTime;
    private int windSoundTime;
    private int ticks;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;

    public static WinterWorldRenderer get() {
        return INSTANCE == null ? (INSTANCE = new WinterWorldRenderer()) : INSTANCE;
    }

    public WinterWorldRenderer() {
        INSTANCE = this;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
        this.rainSoundTime = 0;
        this.windSoundTime = 0;
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    public WeatherRenderHandler getWeatherHandler() {
        return this::renderRainSnow;
    }

    public SkyRenderHandler getSkyHandler() {
        return this::renderSky;
    }

    public void renderSky(int ticks, float partialTicks, MatrixStack matrixStackIn, ClientWorld world, @Nullable Minecraft mc) {
        this.ticks = ticks;
        if (mc != null && mc.field_71460_t != null && mc.field_71439_g != null) {
            RenderSystem.disableTexture();
            BlockPos pos = mc.field_71460_t.func_215316_n().func_216780_d();
            Vec3d vec3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
            float posX = (float)vec3d.field_72450_a;
            float posY = (float)vec3d.field_72448_b;
            float posZ = (float)vec3d.field_72449_c;
            FogRenderer.func_228373_b_();
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableFog();
            RenderSystem.color3f((float)posX, (float)posY, (float)posZ);
            this.skyVBO.func_177359_a();
            this.skyVertexFormat.func_227892_a_(0L);
            this.skyVBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.skyVertexFormat.func_227895_d_();
            RenderSystem.disableFog();
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] sunriseSunsetColors = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
            if (!(sunriseSunsetColors == null || world.func_72867_j(partialTicks) > 0.0f && (double)world.func_226691_t_(pos).func_225486_c(pos) < 0.15)) {
                RenderSystem.disableTexture();
                RenderSystem.shadeModel((int)7425);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                float f4 = sunriseSunsetColors[0];
                float f5 = sunriseSunsetColors[1];
                float f6 = sunriseSunsetColors[2];
                Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, sunriseSunsetColors[3]).func_181675_d();
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = MathHelper.func_76126_a((float)f7);
                    float f9 = MathHelper.func_76134_b((float)f7);
                    bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunriseSunsetColors[3]).func_227885_a_(sunriseSunsetColors[0], sunriseSunsetColors[1], sunriseSunsetColors[2], 0.0f).func_181675_d();
                }
                bufferbuilder.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                matrixStackIn.func_227865_b_();
                RenderSystem.shadeModel((int)7424);
            }
            RenderSystem.enableTexture();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            matrixStackIn.func_227860_a_();
            float f11 = 1.0f - world.func_72867_j(partialTicks);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72826_c(partialTicks) * 360.0f));
            Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
            float f12 = 30.0f;
            mc.func_110434_K().func_110577_a(SUN_TEXTURES);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            f12 = 20.0f;
            mc.func_110434_K().func_110577_a(MOON_PHASES_TEXTURES);
            int k = world.func_72853_d();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)l / 4.0f;
            float f14 = (float)i1 / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, f12).func_225583_a_(f15, f16).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, f12).func_225583_a_(f13, f16).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, -f12).func_225583_a_(f13, f14).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, -f12).func_225583_a_(f15, f14).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.disableTexture();
            float f10 = world.func_228330_j_(partialTicks) * f11;
            if (f10 > 0.0f) {
                RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
                this.starVBO.func_177359_a();
                this.skyVertexFormat.func_227892_a_(0L);
                this.starVBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                this.skyVertexFormat.func_227895_d_();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableFog();
            matrixStackIn.func_227865_b_();
            RenderSystem.disableTexture();
            RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
            double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_228331_m_();
            if (d0 < 0.0) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, 12.0, 0.0);
                this.sky2VBO.func_177359_a();
                this.skyVertexFormat.func_227892_a_(0L);
                this.sky2VBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                this.skyVertexFormat.func_227895_d_();
                matrixStackIn.func_227865_b_();
            }
            if (world.field_73011_w.func_76561_g()) {
                RenderSystem.color3f((float)(posX * 0.2f + 0.04f), (float)(posY * 0.2f + 0.04f), (float)(posZ * 0.6f + 0.1f));
            } else {
                RenderSystem.color3f((float)posX, (float)posY, (float)posZ);
            }
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableFog();
        }
    }

    public void renderRainSnow(int ticks, float partialTicks, ClientWorld world, @Nullable Minecraft mc) {
        this.ticks = ticks;
        if (mc != null && mc.field_71460_t != null) {
            float rainStrength = world.func_72867_j(partialTicks);
            Vec3d vec3d = mc.field_71460_t.func_215316_n().func_216785_c();
            double xIn = vec3d.func_82615_a();
            double yIn = vec3d.func_82617_b();
            double zIn = vec3d.func_82616_c();
            if (rainStrength > 0.0f) {
                mc.field_71460_t.func_228384_l_().func_205109_c();
                int xPos = MathHelper.func_76128_c((double)xIn);
                int yPos = MathHelper.func_76128_c((double)yIn);
                int zPos = MathHelper.func_76128_c((double)zIn);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                RenderSystem.disableCull();
                RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int weatherAmount = (Integer)Config.CLIENT.snowDensity.get();
                int flag = -1;
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (int z = zPos - weatherAmount; z <= zPos + weatherAmount; ++z) {
                    for (int x = xPos - weatherAmount; x <= xPos + weatherAmount; ++x) {
                        int rainSizeIndex = (z - zPos + 16) * 32 + (x - xPos + 16);
                        double rainSizeXValue = (double)this.rainSizeX[rainSizeIndex] * 0.5;
                        double rainSizeZValue = (double)this.rainSizeZ[rainSizeIndex] * 0.5;
                        mutablePos.func_181079_c(x, 0, z);
                        int topYPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)mutablePos).func_177956_o();
                        int lowestYPos = yPos - weatherAmount;
                        int highestYPos = yPos + weatherAmount;
                        if (lowestYPos < topYPos) {
                            lowestYPos = topYPos;
                        }
                        if (highestYPos < topYPos) {
                            highestYPos = topYPos;
                        }
                        int y = topYPos;
                        if (topYPos < yPos) {
                            y = yPos;
                        }
                        if (lowestYPos == highestYPos) continue;
                        Random random = new Random(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                        mutablePos.func_181079_c(x, lowestYPos, z);
                        if (flag != 1) {
                            flag = 1;
                            mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = ticks + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)x + 0.5f) - xIn;
                        double d4 = (double)((float)z + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)weatherAmount;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * rainStrength;
                        mutablePos.func_181079_c(x, y, z);
                        int light = WorldRenderer.func_228421_a_((ILightReader)world, (BlockPos)mutablePos);
                        bufferbuilder.func_225582_a_((double)x - xIn - rainSizeXValue + 0.5, (double)highestYPos - yIn, (double)z - zIn - rainSizeZValue + 0.5).func_225583_a_(0.0f, (float)lowestYPos * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(light).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn + rainSizeXValue + 0.5, (double)highestYPos - yIn, (double)z - zIn + rainSizeZValue + 0.5).func_225583_a_(1.0f, (float)lowestYPos * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(light).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn + rainSizeXValue + 0.5, (double)lowestYPos - yIn, (double)z - zIn + rainSizeZValue + 0.5).func_225583_a_(1.0f, (float)highestYPos * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(light).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn - rainSizeXValue + 0.5, (double)lowestYPos - yIn, (double)z - zIn - rainSizeZValue + 0.5).func_225583_a_(0.0f, (float)highestYPos * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(light).func_181675_d();
                    }
                }
                if (flag >= 0) {
                    tessellator.func_78381_a();
                }
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.defaultAlphaFunc();
                mc.field_71460_t.func_228384_l_().func_205108_b();
            }
        }
    }

    public void addSnowParticlesAndSound(Minecraft mc, World world, ActiveRenderInfo activeRenderInfo) {
        float rainStrength = world.func_72867_j(1.0f);
        if (!mc.field_71474_y.field_74347_j) {
            rainStrength /= 2.0f;
        }
        if (rainStrength != 0.0f) {
            Random random = new Random((long)this.ticks * 312987231L);
            BlockPos blockpos = new BlockPos(activeRenderInfo.func_216785_c());
            double posX = 0.0;
            double posY = 0.0;
            double posZ = 0.0;
            int j = 0;
            int k = (int)(100.0f * rainStrength * rainStrength);
            if (mc.field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
                k >>= 1;
            } else if (mc.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
                k = 0;
            }
            for (int l = 0; l < k; ++l) {
                double d6;
                double d5;
                double d8;
                BlockPos topPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(random.nextInt(10) - random.nextInt(10), 0, random.nextInt(10) - random.nextInt(10)));
                Biome biome = world.func_226691_t_(topPos);
                BlockPos underPos = topPos.func_177977_b();
                if (topPos.func_177956_o() > blockpos.func_177956_o() + 10 || topPos.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.SNOW || !(biome.func_225486_c(topPos) < 0.15f)) continue;
                double d3 = random.nextDouble();
                double d4 = random.nextDouble();
                BlockState blockstate = world.func_180495_p(underPos);
                IFluidState ifluidstate = world.func_204610_c(topPos);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)world, underPos);
                double d7 = voxelshape.func_197760_b(Direction.Axis.Y, d3, d4);
                if (d7 >= (d8 = (double)ifluidstate.func_215679_a((IBlockReader)world, topPos))) {
                    d5 = d7;
                    d6 = voxelshape.func_197764_a(Direction.Axis.Y, d3, d4);
                } else {
                    d5 = 0.0;
                    d6 = 0.0;
                }
                if (!(d5 > -1.7976931348623157E308)) continue;
                if (!(ifluidstate.func_206884_a(FluidTags.field_206960_b) || blockstate.func_177230_c() == Blocks.field_196814_hQ || blockstate.func_177230_c() == Blocks.field_222433_lV && ((Boolean)blockstate.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue())) {
                    if (random.nextInt(++j) == 0) {
                        posX = (double)underPos.func_177958_n() + d3;
                        posY = (double)((float)underPos.func_177956_o() + 0.1f) + d5 - 1.0;
                        posZ = (double)underPos.func_177952_p() + d4;
                    }
                    world.func_195594_a((IParticleData)ModParticleTypes.SNOW.get(), (double)underPos.func_177958_n() + d3, (double)((float)underPos.func_177956_o() + 0.1f) + d5, (double)underPos.func_177952_p() + d4, 0.0, 0.0, 0.0);
                    continue;
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)topPos.func_177958_n() + d3, (double)((float)topPos.func_177956_o() + 0.1f) - d6, (double)topPos.func_177952_p() + d4, 0.0, 0.0, 0.0);
            }
            if (j > 0 && random.nextInt(3) < this.rainSoundTime++ && ((Boolean)Config.CLIENT.snowSounds.get()).booleanValue()) {
                this.rainSoundTime = 0;
                if (posY > (double)(blockpos.func_177956_o() + 1) && world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    world.func_184134_a(posX, posY, posZ, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.03f, 0.05f, false);
                } else {
                    world.func_184134_a(posX, posY, posZ, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.06f, 0.1f, false);
                }
            }
            if (this.windSoundTime-- < 0 && ((Boolean)Config.CLIENT.windSounds.get()).booleanValue()) {
                BlockPos playerPos = activeRenderInfo.func_216780_d();
                Entity entity = activeRenderInfo.func_216773_g();
                int light = activeRenderInfo.func_216773_g().field_70170_p.func_226658_a_(LightType.SKY, playerPos);
                if (light > 3 && entity.field_70170_p.func_72896_J() && entity.field_70170_p.func_226691_t_(playerPos).func_225486_c(playerPos) < 0.15f) {
                    float volumeModifier = 0.2f + (float)(light - 3) * 0.01f;
                    float pitchModifier = 0.7f;
                    if (activeRenderInfo.func_216771_k().func_206886_c() != Fluids.field_204541_a) {
                        pitchModifier = 0.3f;
                    }
                    this.windSoundTime = 60 + random.nextInt(30);
                    mc.field_71441_e.func_184156_a(playerPos, (SoundEvent)ModSoundEvents.WIND.get(), SoundCategory.WEATHER, volumeModifier, pitchModifier, true);
                } else {
                    this.windSoundTime += 5;
                }
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new VertexBuffer(this.skyVertexFormat);
        this.renderStars(bufferbuilder);
        bufferbuilder.func_178977_d();
        this.starVBO.func_227875_a_(bufferbuilder);
    }

    private void renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        this.skyVBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, 16.0f, false);
        bufferbuilder.func_178977_d();
        this.skyVBO.func_227875_a_(bufferbuilder);
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.sky2VBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, -16.0f, true);
        bufferbuilder.func_178977_d();
        this.sky2VBO.func_227875_a_(bufferbuilder);
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }
}

