/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.common.ModBlocks;
import com.alcatrazescapee.primalwinter.common.ModTags;
import com.alcatrazescapee.primalwinter.util.Helpers;
import com.alcatrazescapee.primalwinter.world.BlockReplacingConfiguredFeature;
import com.alcatrazescapee.primalwinter.world.BlockReplacingWorld;
import com.alcatrazescapee.primalwinter.world.ModFeatures;
import com.alcatrazescapee.primalwinter.world.SnowPlacingConfiguredFeature;
import com.alcatrazescapee.primalwinter.world.WinterIceAndSnowFeature;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureRadiusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.IceAndSnowFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public final class VanillaHacks {
    public static Iterable<ChunkHolder> getLoadedChunksIterable(ChunkManager chunkManager) {
        return Iterables.unmodifiableIterable((Iterable)chunkManager.field_219252_f.values());
    }

    public static boolean isOutsideSpawningRadius(ChunkManager chunkManager, ChunkPos chunkPosIn) {
        long chunkPosHash = chunkPosIn.func_201841_a();
        return !chunkManager.field_219267_u.func_223494_d(chunkPosHash) || chunkManager.field_219271_y.func_219444_a(chunkPosHash).noneMatch(playerIn -> !playerIn.func_175149_v() && VanillaHacks.getDistanceSquaredToChunk(chunkPosIn, (Entity)playerIn) < 16384.0);
    }

    public static double getDistanceSquaredToChunk(ChunkPos chunkPosIn, Entity entityIn) {
        double blockX = chunkPosIn.field_77276_a * 16 + 8;
        double blockZ = chunkPosIn.field_77275_b * 16 + 8;
        double distX = blockX - entityIn.func_226277_ct_();
        double distZ = blockZ - entityIn.func_226281_cx_();
        return distX * distX + distZ * distZ;
    }

    public static void tickRainAndSnow(ServerWorld world, Chunk chunkIn) {
        ChunkPos chunkPos = chunkIn.func_76632_l();
        boolean isRaining = world.func_72896_J();
        int blockX = chunkPos.func_180334_c();
        int blockZ = chunkPos.func_180333_d();
        if (world.field_73011_w.canDoRainSnowIce(chunkIn) && world.field_73012_v.nextInt(16) == 0) {
            BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(blockX, 0, blockZ, 15));
            BlockState state = world.func_180495_p(pos);
            if (isRaining && state.func_177230_c() == Blocks.field_150433_aE && (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208129_ad) < 5) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208129_ad) + 1)));
            }
        }
    }

    public static void hackWinterBiomes() {
        ForgeRegistries.BIOMES.getValues().stream().filter(Config.COMMON.getNonWinterBiomesFilter()).forEach(biome -> {
            biome.field_76750_F = -0.5f;
            biome.field_201878_av = Biome.RainType.SNOW;
            biome.field_76759_H = 3750089;
            biome.field_204275_aE = 329011;
            biome.field_201880_ax.computeIfAbsent(EntityClassification.MONSTER, key -> new ArrayList()).add(new Biome.SpawnListEntry(EntityType.field_200750_ap, 320, 4, 4));
            biome.field_201880_ax.computeIfAbsent(EntityClassification.CREATURE, key -> new ArrayList()).add(new Biome.SpawnListEntry(EntityType.field_200786_Z, 4, 1, 2));
            biome.field_201880_ax.computeIfAbsent(EntityClassification.CREATURE, key -> new ArrayList()).add(new Biome.SpawnListEntry(EntityType.field_200745_ak, 4, 4, 8));
            biome.func_203607_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION).removeIf(feature -> feature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222737_a instanceof IceAndSnowFeature);
            biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((WinterIceAndSnowFeature)ModFeatures.FREEZE_EVERYTHING.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_202468_e)));
            List features = biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION);
            BlockReplacingConfiguredFeature featureWrapper = new BlockReplacingConfiguredFeature(world -> new BlockReplacingWorld((IWorld)world, stateIn -> {
                Block replacementBlock = ModBlocks.SNOWY_TREE_BLOCKS.getOrDefault(stateIn.func_177230_c(), () -> null).get();
                if (replacementBlock != null) {
                    BlockState replacementState = replacementBlock.func_176223_P();
                    return Helpers.copyProperties(stateIn, replacementState);
                }
                return stateIn;
            }));
            features.forEach(featureWrapper::addDelegate);
            features.clear();
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)featureWrapper);
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                DefaultBiomeFeatures.func_222305_an((Biome)biome);
                DefaultBiomeFeatures.func_222332_ao((Biome)biome);
            }
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new SnowPlacingConfiguredFeature<NoFeatureConfig, Feature>(Feature.field_202320_T, IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(7))));
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new SnowPlacingConfiguredFeature<FeatureRadiusConfig, Feature>(Feature.field_202288_ah, new FeatureRadiusConfig(2)).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(5))));
            biome.func_226711_a_(Feature.field_202333_k.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY});
        });
    }

    public static void hackEntitySpawnPlacementRegistry() {
        VanillaHacks.replaceSpawnEntry(EntityType.field_200795_i, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200796_j, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200798_l, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200762_B, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200769_I, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200779_S, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200784_X, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200786_Z, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canPolarBearSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200736_ab, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200737_ac, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_203099_aq, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canTurtleSpawnOn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_200724_aC, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_220360_g, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_220356_B, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_220353_aa, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
        VanillaHacks.replaceSpawnEntry(EntityType.field_220354_ax, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VanillaHacks::canAnimalSpawn);
    }

    public static <T extends MobEntity> void replaceSpawnEntry(EntityType<T> entityTypeIn, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        try {
            EntitySpawnPlacementRegistry.func_209343_a(entityTypeIn, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightMapType, predicate);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static boolean canAnimalSpawn(EntityType<?> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return ModTags.Blocks.ANIMAL_SPAWNS_ON.func_199685_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static boolean canPolarBearSpawn(EntityType<PolarBearEntity> entityType, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        Biome biome = world.func_226691_t_(pos);
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return VanillaHacks.canAnimalSpawn(entityType, world, reason, pos, random);
        }
        return world.func_226659_b_(pos, 0) > 8 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150432_aD;
    }

    public static boolean canTurtleSpawnOn(EntityType<TurtleEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return pos.func_177956_o() < world.func_181545_F() + 4 && ModTags.Blocks.TURTLE_SPAWNS_ON.func_199685_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) && world.func_226659_b_(pos, 0) > 8;
    }
}

