/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.world;

import com.alcatrazescapee.primalwinter.common.ModBlocks;
import com.alcatrazescapee.primalwinter.util.Vec2i;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WinterIceAndSnowFeature
extends Feature<NoFeatureConfig> {
    public WinterIceAndSnowFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int y;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        int maxY = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                y = worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n() + x, pos.func_177952_p() + z);
                if (maxY >= y) continue;
                maxY = y;
            }
        }
        int[] skyLights = new int[256];
        int[] prevSkyLights = new int[256];
        Arrays.fill(prevSkyLights, 7);
        for (y = maxY; y >= 0; --y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int skyLight = prevSkyLights[x + 16 * z];
                    mutablePos.func_181079_c(pos.func_177958_n() + x, y, pos.func_177952_p() + z);
                    BlockState state = worldIn.func_180495_p((BlockPos)mutablePos);
                    if (state.isAir((IBlockReader)worldIn, (BlockPos)mutablePos)) {
                        skyLights[x + 16 * z] = prevSkyLights[x + 16 * z];
                        this.extendSkyLights(skyLights, x, z);
                    }
                    if (skyLight <= 0) continue;
                    this.placeSnowAndIce(worldIn, (BlockPos)mutablePos, state, rand, skyLight);
                }
            }
            boolean hasSkyLight = false;
            for (int i = 0; i < 256; ++i) {
                if (skyLights[i] <= 0) continue;
                hasSkyLight = true;
                break;
            }
            if (!hasSkyLight) break;
            System.arraycopy(skyLights, 0, prevSkyLights, 0, skyLights.length);
            Arrays.fill(skyLights, 0);
        }
        return true;
    }

    private void placeSnowAndIce(IWorld worldIn, BlockPos pos, BlockState state, Random random, int skyLight) {
        Block replacementBlock;
        IFluidState fluidState = worldIn.func_204610_c(pos);
        BlockPos posDown = pos.func_177977_b();
        BlockState stateDown = worldIn.func_180495_p(posDown);
        if (state.isAir((IBlockReader)worldIn, pos) && (replacementBlock = ModBlocks.SNOWY_SPECIAL_TERRAIN_BLOCKS.getOrDefault(stateDown.func_177230_c(), () -> null).get()) != null) {
            BlockState replacementState = replacementBlock.func_176223_P();
            worldIn.func_180501_a(posDown, replacementState, 2);
        }
        if (fluidState.func_206886_c() == Fluids.field_204546_a && (state.func_177230_c() instanceof FlowingFluidBlock || state.func_185904_a().func_76222_j())) {
            worldIn.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 2);
            if (!(state.func_177230_c() instanceof FlowingFluidBlock)) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)Blocks.field_150432_aD, 0);
            }
        } else if (fluidState.func_206886_c() == Fluids.field_204547_b && state.func_177230_c() instanceof FlowingFluidBlock) {
            worldIn.func_180501_a(pos, Blocks.field_150343_Z.func_176223_P(), 2);
        } else if (Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && state.func_185904_a().func_76222_j()) {
            BlockPos posUp = pos.func_177984_a();
            if (state.func_177230_c() instanceof DoublePlantBlock && worldIn.func_180495_p(posUp).func_177230_c() == state.func_177230_c()) {
                worldIn.func_217377_a(posUp, false);
            }
            int layers = MathHelper.func_76125_a((int)(skyLight - random.nextInt(3) - this.countExposedFaces(worldIn, pos)), (int)1, (int)7);
            worldIn.func_180501_a(pos, (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(layers)), 3);
            Block replacementBlock2 = ModBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault(stateDown.func_177230_c(), () -> null).get();
            if (replacementBlock2 != null) {
                BlockState replacementState = replacementBlock2.func_176223_P();
                worldIn.func_180501_a(posDown, replacementState, 2);
            }
        }
    }

    private int countExposedFaces(IWorld world, BlockPos pos) {
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos posAt = pos.func_177972_a(direction);
            if (world.func_180495_p(posAt).func_224755_d((IBlockReader)world, posAt, direction.func_176734_d())) continue;
            ++count;
        }
        return count;
    }

    private void extendSkyLights(int[] skyLights, int startX, int startZ) {
        ArrayList<Vec3i> positions = new ArrayList<Vec3i>();
        HashSet<Vec2i> visited = new HashSet<Vec2i>();
        positions.add(new Vec3i(startX, skyLights[startX + 16 * startZ], startZ));
        visited.add(new Vec2i(startX, startZ));
        while (!positions.isEmpty()) {
            Vec3i position = (Vec3i)positions.remove(0);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec2i nextVisited;
                int nextX = position.func_177958_n() + direction.func_82601_c();
                int nextZ = position.func_177952_p() + direction.func_82599_e();
                int nextSkyLight = position.func_177956_o() - 1;
                if (nextX < 0 || nextX >= 16 || nextZ < 0 || nextZ >= 16 || skyLights[nextX + 16 * nextZ] >= nextSkyLight || visited.contains(nextVisited = new Vec2i(nextX, nextZ))) continue;
                skyLights[nextX + 16 * nextZ] = nextSkyLight;
                positions.add(new Vec3i(nextX, nextSkyLight, nextZ));
                visited.add(nextVisited);
            }
        }
    }
}

