/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.network.MessageUpdateNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CheckStatsCommand {
    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        PlayerEntity sender = (PlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        String[] args = context.getInput().split(" ");
        if (sender == null) {
            LogHandler.LOGGER.error("Error: Pmmo checkstats sent by non-player");
            return -1;
        }
        try {
            ServerPlayerEntity target = EntityArgument.func_197089_d(context, (String)"player name");
            CompoundNBT skillsTag = XP.getSkillsTag((PlayerEntity)target);
            CompoundNBT packetSkillsTag = new CompoundNBT();
            Set keys = skillsTag.func_150296_c();
            keys.forEach(key -> packetSkillsTag.func_74780_a(key, skillsTag.func_74769_h(key)));
            packetSkillsTag.func_74778_a("UUID", target.func_110124_au().toString());
            packetSkillsTag.func_74778_a("name", target.func_200200_C_().getString());
            NetworkHandler.sendToPlayer(new MessageUpdateNBT(packetSkillsTag, 3), (ServerPlayerEntity)sender);
        }
        catch (CommandSyntaxException e) {
            LogHandler.LOGGER.error("Error: Invalid Player requested at CheckStats Command \"" + args[2] + "\"", (Throwable)e);
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.invalidPlayer", new Object[]{args[2]}).func_240703_c_(XP.textStyle.get("red")), false);
            return -1;
        }
        return 1;
    }
}

