/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClearCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        Object[] args = context.getInput().split(" ");
        try {
            Collection players = EntityArgument.func_197090_e(context, (String)"target");
            for (ServerPlayerEntity player : players) {
                String playerName = player.func_145748_c_().getString();
                AttributeHandler.updateAll((PlayerEntity)player);
                XP.updateRecipes(player);
                NetworkHandler.sendToPlayer(new MessageXp(0.0, 42069, 0.0, true), player);
                player.getPersistentData().func_74775_l("pmmo").func_218657_a("skills", (INBT)new CompoundNBT());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.skillsCleared"), false);
                LogHandler.LOGGER.info("PMMO Command Clear: " + playerName + " has had their stats wiped!");
            }
        }
        catch (CommandSyntaxException e) {
            LogHandler.LOGGER.error("Clear Command Failed to get Players [" + Arrays.toString(args) + "]", (Throwable)e);
        }
        return 1;
    }
}

