/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import java.util.HashMap;
import java.util.Map;

public enum JType {
    NONE(0),
    REQ_WEAR(1),
    REQ_TOOL(2),
    REQ_WEAPON(3),
    REQ_USE(4),
    REQ_PLACE(5),
    REQ_BREAK(6),
    REQ_BIOME(7),
    REQ_KILL(8),
    XP_VALUE_GENERAL(9),
    XP_VALUE_BREAK(10),
    XP_VALUE_CRAFT(11),
    XP_VALUE_BREED(12),
    XP_VALUE_TAME(13),
    XP_VALUE_KILL(14),
    XP_VALUE_TRIGGER(15),
    INFO_ORE(16),
    INFO_LOG(17),
    INFO_PLANT(18),
    BIOME_EFFECT(19),
    BIOME_MOB_MULTIPLIER(20),
    XP_BONUS_BIOME(21),
    XP_BONUS_HELD(22),
    XP_BONUS_WORN(23),
    SALVAGE_TO(24),
    FISH_POOL(25),
    FISH_ENCHANT_POOL(26),
    MOB_RARE_DROP(27),
    LEVEL_UP_COMMAND(28),
    PLAYER_SPECIFIC(29),
    BLOCK_SPECIFIC(30),
    VEIN_BLACKLIST(31),
    REQ_CRAFT(32),
    SALVAGE_FROM(100),
    STATS(101),
    DIMENSION(102),
    CREDITS(103),
    SETTINGS(104),
    GUI_SETTINGS(105);

    public static final Map<JType, Integer> jTypeMap;
    public static final Map<Integer, JType> intMap;
    public static final Map<String, JType> stringMap;
    private final int value;

    private JType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static JType getJType(String str) {
        return stringMap.get(str);
    }

    public static JType getJType(int i) {
        return intMap.get(i);
    }

    static {
        jTypeMap = new HashMap<JType, Integer>();
        intMap = new HashMap<Integer, JType>();
        stringMap = new HashMap<String, JType>();
        for (JType jType : JType.values()) {
            jTypeMap.put(jType, jType.value);
            intMap.put(jType.value, jType);
            stringMap.put(jType.name().toLowerCase(), jType);
        }
    }
}

