/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import harmonised.pmmo.ProjectMMOMod;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class JsonConfig {
    public static Gson gson = new Gson();
    public static final Type mapType = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
    public static Set<JType> jTypes;
    private static Map<JType, Map<String, Map<String, Object>>> rawData;
    public static Map<JType, Map<String, Map<String, Object>>> localData;
    public static Map<JType, Map<String, Map<String, Object>>> data;
    private static final ArrayList<String> validAttributes;
    private static final ArrayList<String> validFishEnchantInfo;
    private static final String dataPath = "pmmo/";
    private static final String hardDataPath = "/assets/pmmo/util/";
    private static final Effect invalidEffect;
    private static final Enchantment invalidEnchant;

    public static void init() {
        validAttributes.add("speedBonus");
        validAttributes.add("hpBonus");
        validAttributes.add("damageBonus");
        JsonConfig.initMaps();
        JsonConfig.initJTypes();
        JsonConfig.initData();
        JsonConfig.readRawData();
        JsonConfig.processRawData();
        data = localData;
    }

    private static void initMaps() {
        JsonConfig.initMap(localData);
        JsonConfig.initMap(data);
    }

    private static void initMap(Map<JType, Map<String, Map<String, Object>>> map) {
        for (Map.Entry<JType, Integer> entry : JType.jTypeMap.entrySet()) {
            if (map.containsKey((Object)entry.getKey())) {
                map.replace(entry.getKey(), new HashMap());
                continue;
            }
            map.put(entry.getKey(), new HashMap());
        }
    }

    private static void initJTypes() {
        jTypes = new HashSet<JType>();
        if (Config.forgeConfig.wearReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_WEAR);
        }
        if (Config.forgeConfig.toolReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_TOOL);
        }
        if (Config.forgeConfig.weaponReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_WEAPON);
        }
        if (Config.forgeConfig.useReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_USE);
        }
        if (Config.forgeConfig.xpValueGeneralEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_GENERAL);
        }
        if (Config.forgeConfig.xpValueBreakingEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_BREAK);
        }
        if (Config.forgeConfig.xpValueCraftingEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_CRAFT);
        }
        if (Config.forgeConfig.breedingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_BREED);
        }
        if (Config.forgeConfig.tamingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_TAME);
        }
        jTypes.add(JType.XP_VALUE_TRIGGER);
        if (Config.forgeConfig.placeReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_PLACE);
        }
        if (Config.forgeConfig.breakReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_BREAK);
        }
        if (Config.forgeConfig.biomeReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_BIOME);
        }
        if (Config.forgeConfig.biomeEffectEnabled.get().booleanValue()) {
            jTypes.add(JType.BIOME_EFFECT);
        }
        if (Config.forgeConfig.biomeXpBonusEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_BIOME);
        }
        if (Config.forgeConfig.biomeMobMultiplierEnabled.get().booleanValue()) {
            jTypes.add(JType.BIOME_MOB_MULTIPLIER);
        }
        if (Config.forgeConfig.oreEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_ORE);
        }
        if (Config.forgeConfig.logEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_LOG);
        }
        if (Config.forgeConfig.plantEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_PLANT);
        }
        if (Config.forgeConfig.salvageEnabled.get().booleanValue()) {
            jTypes.add(JType.SALVAGE_TO);
        }
        if (Config.forgeConfig.fishPoolEnabled.get().booleanValue()) {
            jTypes.add(JType.FISH_POOL);
        }
        if (Config.forgeConfig.fishEnchantPoolEnabled.get().booleanValue()) {
            jTypes.add(JType.FISH_ENCHANT_POOL);
        }
        if (Config.forgeConfig.killReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_KILL);
        }
        if (Config.forgeConfig.killXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_KILL);
        }
        if (Config.forgeConfig.mobRareDropEnabled.get().booleanValue()) {
            jTypes.add(JType.MOB_RARE_DROP);
        }
        if (Config.forgeConfig.levelUpCommandEnabled.get().booleanValue()) {
            jTypes.add(JType.LEVEL_UP_COMMAND);
        }
        if (Config.forgeConfig.heldItemXpBoostEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_HELD);
        }
        if (Config.forgeConfig.wornItemXpBoostEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_WORN);
        }
        jTypes.add(JType.BLOCK_SPECIFIC);
        jTypes.add(JType.PLAYER_SPECIFIC);
        jTypes.add(JType.VEIN_BLACKLIST);
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_CRAFT);
        }
    }

    private static void initData() {
        for (JType jType : jTypes) {
            String fileName = jType.name().toLowerCase() + ".json";
            File dataFile = FMLPaths.CONFIGDIR.get().resolve(dataPath + fileName).toFile();
            if (dataFile.exists()) continue;
            JsonConfig.createData(dataFile, fileName);
        }
    }

    private static void readRawData() {
        rawData = new HashMap<JType, Map<String, Map<String, Object>>>();
        for (JType jType : jTypes) {
            String fileName = jType.name().toLowerCase() + ".json";
            File file = FMLPaths.CONFIGDIR.get().resolve(dataPath + fileName).toFile();
            try {
                FileInputStream input = new FileInputStream(file.getPath());
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    Throwable throwable2 = null;
                    try {
                        rawData.put(jType, (Map<String, Map<String, Object>>)gson.fromJson((Reader)reader, mapType));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                LogHandler.LOGGER.error("ERROR READING PROJECT MMO CONFIG: Invalid JSON Structure of pmmo/" + fileName, (Throwable)e);
                rawData.put(jType, new HashMap());
            }
        }
    }

    private static void processRawData() {
        if (jTypes.contains((Object)JType.REQ_WEAR)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_WEAR), localData.get((Object)JType.REQ_WEAR));
        }
        if (jTypes.contains((Object)JType.REQ_TOOL)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_TOOL), localData.get((Object)JType.REQ_TOOL));
        }
        if (jTypes.contains((Object)JType.REQ_WEAPON)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_WEAPON), localData.get((Object)JType.REQ_WEAPON));
        }
        if (jTypes.contains((Object)JType.REQ_USE)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_USE), localData.get((Object)JType.REQ_USE));
        }
        if (jTypes.contains((Object)JType.REQ_PLACE)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_PLACE), localData.get((Object)JType.REQ_PLACE));
        }
        if (jTypes.contains((Object)JType.REQ_BREAK)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_BREAK), localData.get((Object)JType.REQ_BREAK));
        }
        if (jTypes.contains((Object)JType.REQ_BIOME)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_BIOME), localData.get((Object)JType.REQ_BIOME));
        }
        if (jTypes.contains((Object)JType.REQ_KILL)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_KILL), localData.get((Object)JType.REQ_KILL));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_GENERAL)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_GENERAL), localData.get((Object)JType.XP_VALUE_GENERAL));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_BREAK)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_BREAK), localData.get((Object)JType.XP_VALUE_BREAK));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_CRAFT)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_CRAFT), localData.get((Object)JType.XP_VALUE_CRAFT));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_BREED)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_BREED), localData.get((Object)JType.XP_VALUE_BREED));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_TAME)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_TAME), localData.get((Object)JType.XP_VALUE_TAME));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_KILL)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_KILL), localData.get((Object)JType.XP_VALUE_KILL));
        }
        if (jTypes.contains((Object)JType.XP_VALUE_TRIGGER)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_VALUE_TRIGGER), localData.get((Object)JType.XP_VALUE_TRIGGER));
        }
        if (jTypes.contains((Object)JType.INFO_ORE)) {
            JsonConfig.updateReqExtra(rawData.get((Object)JType.INFO_ORE), localData.get((Object)JType.INFO_ORE));
        }
        if (jTypes.contains((Object)JType.INFO_LOG)) {
            JsonConfig.updateReqExtra(rawData.get((Object)JType.INFO_LOG), localData.get((Object)JType.INFO_LOG));
        }
        if (jTypes.contains((Object)JType.INFO_PLANT)) {
            JsonConfig.updateReqExtra(rawData.get((Object)JType.INFO_PLANT), localData.get((Object)JType.INFO_PLANT));
        }
        if (jTypes.contains((Object)JType.BIOME_EFFECT)) {
            JsonConfig.updateReqEffects(rawData.get((Object)JType.BIOME_EFFECT), localData.get((Object)JType.BIOME_EFFECT));
        }
        if (jTypes.contains((Object)JType.BIOME_MOB_MULTIPLIER)) {
            JsonConfig.updateReqAttributes(rawData.get((Object)JType.BIOME_MOB_MULTIPLIER), localData.get((Object)JType.BIOME_MOB_MULTIPLIER));
        }
        if (jTypes.contains((Object)JType.XP_BONUS_BIOME)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_BONUS_BIOME), localData.get((Object)JType.XP_BONUS_BIOME));
        }
        if (jTypes.contains((Object)JType.XP_BONUS_HELD)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_BONUS_HELD), localData.get((Object)JType.XP_BONUS_HELD));
        }
        if (jTypes.contains((Object)JType.XP_BONUS_WORN)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.XP_BONUS_WORN), localData.get((Object)JType.XP_BONUS_WORN));
        }
        if (jTypes.contains((Object)JType.SALVAGE_TO)) {
            JsonConfig.updateReqSalvage(rawData.get((Object)JType.SALVAGE_TO), localData.get((Object)JType.SALVAGE_TO));
        }
        if (jTypes.contains((Object)JType.FISH_POOL)) {
            JsonConfig.updateReqfishPool(rawData.get((Object)JType.FISH_POOL), localData.get((Object)JType.FISH_POOL));
        }
        if (jTypes.contains((Object)JType.FISH_ENCHANT_POOL)) {
            JsonConfig.updateReqFishEnchantPool(rawData.get((Object)JType.FISH_ENCHANT_POOL), localData.get((Object)JType.FISH_ENCHANT_POOL));
        }
        if (jTypes.contains((Object)JType.MOB_RARE_DROP)) {
            JsonConfig.updateEntityItem(rawData.get((Object)JType.MOB_RARE_DROP), localData.get((Object)JType.MOB_RARE_DROP));
        }
        if (jTypes.contains((Object)JType.LEVEL_UP_COMMAND)) {
            JsonConfig.updateCommand(rawData.get((Object)JType.LEVEL_UP_COMMAND), localData.get((Object)JType.LEVEL_UP_COMMAND));
        }
        if (jTypes.contains((Object)JType.PLAYER_SPECIFIC)) {
            JsonConfig.updateSpecific(rawData.get((Object)JType.PLAYER_SPECIFIC), localData.get((Object)JType.PLAYER_SPECIFIC));
        }
        if (jTypes.contains((Object)JType.BLOCK_SPECIFIC)) {
            JsonConfig.updateSpecific(rawData.get((Object)JType.BLOCK_SPECIFIC), localData.get((Object)JType.BLOCK_SPECIFIC));
        }
        if (jTypes.contains((Object)JType.VEIN_BLACKLIST)) {
            JsonConfig.updateReqVein(rawData.get((Object)JType.VEIN_BLACKLIST), localData.get((Object)JType.VEIN_BLACKLIST));
        }
        if (jTypes.contains((Object)JType.REQ_CRAFT)) {
            JsonConfig.updateReqSkills(rawData.get((Object)JType.REQ_CRAFT), localData.get((Object)JType.REQ_CRAFT));
        }
    }

    private static void createData(File dataFile, String fileName) {
        try {
            dataFile.getParentFile().mkdir();
            dataFile.createNewFile();
        }
        catch (IOException e) {
            LogHandler.LOGGER.error("Could not create template json config!", (Object)dataFile.getPath(), (Object)e);
        }
        try (InputStream inputStream = ProjectMMOMod.class.getResourceAsStream(hardDataPath + fileName);
             FileOutputStream outputStream = new FileOutputStream(dataFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            LogHandler.LOGGER.error("Error copying over " + fileName + " json config to " + dataFile.getPath(), (Object)dataFile.getPath(), (Object)e);
        }
    }

    private static boolean checkValidSkills(Map<String, Object> theMap) {
        boolean anyValidSkills = false;
        for (String key : theMap.keySet()) {
            if (Skill.getInt(key) != 0) {
                anyValidSkills = true;
                continue;
            }
            LogHandler.LOGGER.info("Invalid skill " + key + " level " + (Double)theMap.get(key));
        }
        return anyValidSkills;
    }

    private static boolean checkValidEffects(Map<String, Object> theMap) {
        boolean anyValidEffects = false;
        for (String key : theMap.keySet()) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(key));
            if (!effect.equals(invalidEffect)) {
                anyValidEffects = true;
                continue;
            }
            LogHandler.LOGGER.info("Invalid effect " + key);
        }
        return anyValidEffects;
    }

    private static void updateReqSkills(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (JsonConfig.checkValidSkills(element.getValue())) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                    if (entry.getValue() instanceof Double) {
                        if (Skill.getInt(entry.getKey()) != 0) {
                            output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        LogHandler.LOGGER.error(entry.getKey() + " is either not a valid skill, or not 1 or above!");
                        continue;
                    }
                    LogHandler.LOGGER.error(entry.getValue() + " is not a Double!");
                }
                continue;
            }
            LogHandler.LOGGER.error("No valid skills, cannot add " + element.getKey());
        }
    }

    private static void updateReqEffects(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (JsonConfig.checkValidEffects(element.getValue())) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                    if (entry.getValue() instanceof Double) {
                        Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(XP.getResLoc(entry.getKey()));
                        if (!potion.equals(invalidEffect) && (Double)entry.getValue() >= 0.0 && (Double)entry.getValue() < 255.0) {
                            output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        LogHandler.LOGGER.error(entry.getKey() + " is either not a effect skill, or below 0, or above 255!");
                        continue;
                    }
                    LogHandler.LOGGER.error(entry.getValue() + " is not a Double!");
                }
                continue;
            }
            LogHandler.LOGGER.error("No valid effects, cannot add " + element.getKey());
        }
    }

    private static void updateReqExtra(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (!XP.getItem(element.getKey()).equals(Items.field_190931_a)) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                    if (entry.getValue() instanceof Double) {
                        if (entry.getKey().equals("extraChance") && (Double)entry.getValue() > 0.0) {
                            output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        LogHandler.LOGGER.error(element.getKey() + " is either not \"extraChance\", or not above 0!");
                        continue;
                    }
                    LogHandler.LOGGER.error(element.getKey() + " is not a Double!");
                }
                continue;
            }
            LogHandler.LOGGER.info("Could not load inexistant item " + element.getKey());
        }
    }

    private static void updateReqSalvage(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (!XP.getItem(element.getKey()).equals(Items.field_190931_a)) {
                boolean failed = false;
                Map<String, Object> inMap = element.getValue();
                if (!inMap.containsKey("salvageItem") || !(inMap.get("salvageItem") instanceof String)) {
                    LogHandler.LOGGER.error("Failed to load Salvage Item " + element.getKey() + " \"salvageItem\" is invalid");
                    failed = true;
                } else if (XP.getItem((String)inMap.get("salvageItem")).equals(Items.field_190931_a)) {
                    LogHandler.LOGGER.error("Failed to load Salvage Item " + element.getKey() + " \"salvageItem\" item does not exist");
                    failed = true;
                }
                if (!inMap.containsKey("salvageMax") || !(inMap.get("salvageMax") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"salvageMax\" is invalid, loading default value 1 item");
                    inMap.put("salvageMax", 1.0);
                }
                if (!inMap.containsKey("baseChance") || !(inMap.get("baseChance") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"baseChance\" is invalid, loading default value 50%");
                    inMap.put("baseChance", 50.0);
                }
                if (!inMap.containsKey("chancePerLevel") || !(inMap.get("chancePerLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"chancePerLevel\" is invalid, loading default value 0%");
                    inMap.put("chancePerLevel", 0.0);
                }
                if (!inMap.containsKey("maxChance") || !(inMap.get("maxChance") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"maxChance\" is invalid, loading default value 80%");
                    inMap.put("maxChance", 80.0);
                }
                if (!inMap.containsKey("xpPerItem") || !(inMap.get("xpPerItem") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"xpPerItem\" is invalid, loading default value 0xp");
                    inMap.put("xpPerItem", 0.0);
                }
                if (!inMap.containsKey("levelReq") || !(inMap.get("levelReq") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Salvage Item " + element.getKey() + " \"levelReq\" is invalid, loading default value 1 level");
                    inMap.put("levelReq", 1.0);
                }
                if (failed) continue;
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                Map<String, Object> outMap = output.get(element.getKey());
                String salvageItem = (String)inMap.get("salvageItem");
                double salvageMax = (Double)inMap.get("salvageMax");
                double levelReq = (Double)inMap.get("levelReq");
                double xpPerItem = (Double)inMap.get("xpPerItem");
                double baseChance = (Double)inMap.get("baseChance");
                double chancePerLevel = (Double)inMap.get("chancePerLevel");
                double maxChance = (Double)inMap.get("maxChance");
                outMap.put("salvageItem", salvageItem);
                if (salvageMax < 1.0) {
                    outMap.put("salvageMax", 1);
                } else {
                    outMap.put("salvageMax", salvageMax);
                }
                if (levelReq < 1.0) {
                    outMap.put("levelReq", 1);
                } else {
                    outMap.put("levelReq", levelReq);
                }
                if (xpPerItem < 0.0) {
                    outMap.put("xpPerItem", 0);
                } else {
                    outMap.put("xpPerItem", xpPerItem);
                }
                if (baseChance < 0.0) {
                    outMap.put("baseChance", 0);
                } else if (baseChance > 100.0) {
                    outMap.put("baseChance", 100);
                } else {
                    outMap.put("baseChance", baseChance);
                }
                if (chancePerLevel < 0.0) {
                    outMap.put("chancePerLevel", 0);
                } else if (chancePerLevel > 100.0) {
                    outMap.put("chancePerLevel", 100);
                } else {
                    outMap.put("chancePerLevel", chancePerLevel);
                }
                if (maxChance < 0.0) {
                    outMap.put("maxChance", 0);
                } else if (maxChance > 100.0) {
                    outMap.put("maxChance", 100);
                } else {
                    outMap.put("maxChance", maxChance);
                }
                Map<String, Map<String, Object>> localSalvagesFrom = localData.get((Object)JType.SALVAGE_FROM);
                if (!localSalvagesFrom.containsKey(salvageItem)) {
                    localSalvagesFrom.put(salvageItem, new HashMap());
                }
                localSalvagesFrom.get(salvageItem).put(element.getKey(), salvageMax);
                continue;
            }
            LogHandler.LOGGER.info("Could not load inexistant item " + element.getKey());
        }
    }

    private static void updateReqVein(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            Map<String, Object> inMap = element.getValue();
            if (!output.containsKey(element.getKey())) {
                output.put(element.getKey(), new HashMap());
            }
            for (Map.Entry<String, Object> entry : inMap.entrySet()) {
                if (XP.getItem(entry.getKey()).equals(Items.field_190931_a)) {
                    LogHandler.LOGGER.info("Could not load inexistant item " + entry.getKey() + " into Vein Blacklist");
                    continue;
                }
                output.get(element.getKey()).put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void updateEntityItem(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            output.put(element.getKey(), new HashMap());
            for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                if (!XP.getItem(entry.getKey()).equals(Items.field_190931_a)) {
                    output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                    continue;
                }
                LogHandler.LOGGER.info("Could not load inexistant item " + element.getKey());
            }
        }
    }

    private static void updateReqfishPool(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            Item item = XP.getItem(element.getKey());
            if (!item.equals(Items.field_190931_a)) {
                Map<String, Object> inMap = element.getValue();
                if (!inMap.containsKey("startWeight") || !(inMap.get("startWeight") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"startWeight\" is invalid, loading default value 1");
                    inMap.put("startWeight", 1.0);
                }
                if (!inMap.containsKey("startLevel") || !(inMap.get("startLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"startLevel\" is invalid, loading default value level 1");
                    inMap.put("startLevel", 1.0);
                }
                if (!inMap.containsKey("endWeight") || !(inMap.get("endWeight") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"endWeight\" is invalid, loading default value 1");
                    inMap.put("endWeight", 1.0);
                }
                if (!inMap.containsKey("endLevel") || !(inMap.get("endLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"endLevel\" is invalid, loading default value level 1");
                    inMap.put("endLevel", 1.0);
                }
                if (!inMap.containsKey("minCount") || !(inMap.get("minCount") instanceof Double)) {
                    inMap.put("minCount", 1.0);
                } else if ((Double)inMap.get("minCount") > (double)item.func_77639_j()) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"minCount\" is above Max Stack Size, loading default value 1 item");
                    inMap.put("minCount", item.func_77639_j());
                }
                if (!inMap.containsKey("maxCount") || !(inMap.get("maxCount") instanceof Double)) {
                    inMap.put("maxCount", 1.0);
                } else if ((Double)inMap.get("maxCount") > (double)item.func_77639_j()) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"maxCount\" is above Max Stack Size, loading default value 1 item");
                    inMap.put("maxCount", item.func_77639_j());
                }
                if (!inMap.containsKey("enchantLevelReq") || !(inMap.get("enchantLevelReq") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"enchantLevelReq\" is invalid, loading default value level 1");
                    inMap.put("enchantLevelReq", 1.0);
                }
                if (!inMap.containsKey("xp") || !(inMap.get("xp") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Pool Item " + element.getKey() + " \"xp\" is invalid, loading default value 1xp");
                    inMap.put("xp", 1.0);
                }
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                Map<String, Object> outMap = output.get(element.getKey());
                double startWeight = (Double)inMap.get("startWeight");
                double startLevel = (Double)inMap.get("startLevel");
                double endWeight = (Double)inMap.get("endWeight");
                double endLevel = (Double)inMap.get("endLevel");
                double minCount = (Double)inMap.get("minCount");
                double maxCount = (Double)inMap.get("maxCount");
                double enchantLevelReq = (Double)inMap.get("enchantLevelReq");
                double xp = (Double)inMap.get("xp");
                if (endWeight < 0.0) {
                    outMap.put("endWeight", 0.0);
                } else {
                    outMap.put("endWeight", endWeight);
                }
                if (startWeight > endWeight) {
                    startWeight = endWeight;
                }
                if (startWeight < 0.0) {
                    outMap.put("startWeight", 0.0);
                } else {
                    outMap.put("startWeight", startWeight);
                }
                if (endLevel < 1.0) {
                    outMap.put("endLevel", 1.0);
                } else {
                    outMap.put("endLevel", endLevel);
                }
                if (startLevel > endLevel) {
                    startLevel = endLevel;
                }
                if (startLevel < 1.0) {
                    outMap.put("startLevel", 1.0);
                } else {
                    outMap.put("startLevel", startLevel);
                }
                if (maxCount < 1.0) {
                    outMap.put("maxCount", 1.0);
                } else {
                    outMap.put("maxCount", maxCount);
                }
                if (minCount > maxCount) {
                    minCount = maxCount;
                }
                if (minCount < 1.0) {
                    outMap.put("minCount", 1.0);
                } else {
                    outMap.put("minCount", minCount);
                }
                if (enchantLevelReq < 1.0) {
                    outMap.put("enchantLevelReq", 1.0);
                } else {
                    outMap.put("enchantLevelReq", enchantLevelReq);
                }
                if (xp < 0.0) {
                    outMap.put("xp", 0.0);
                    continue;
                }
                outMap.put("xp", xp);
                continue;
            }
            LogHandler.LOGGER.info("Could not load inexistant item " + element.getKey());
        }
    }

    private static void updateReqFishEnchantPool(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(element.getKey()));
            if (!enchant.equals(invalidEnchant)) {
                Map<String, Object> inMap = element.getValue();
                if (!inMap.containsKey("levelReq") || !(inMap.get("levelReq") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Enchant Pool Item " + element.getKey() + " \"levelReq\" is invalid, loading default value 1");
                    inMap.put("levelReq", 1.0);
                }
                if (!inMap.containsKey("levelPerLevel") || !(inMap.get("levelPerLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Enchant Pool Item " + element.getKey() + " \"levelPerLevel\" is invalid, loading default value 0");
                    inMap.put("levelPerLevel", 0.0);
                }
                if (!inMap.containsKey("chancePerLevel") || !(inMap.get("chancePerLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Enchant Pool Item " + element.getKey() + " \"chancePerLevel\" is invalid, loading default value 0");
                    inMap.put("chancePerLevel", 0.0);
                }
                if (!inMap.containsKey("maxChance") || !(inMap.get("maxChance") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Enchant Pool Item " + element.getKey() + " \"maxChance\" is invalid, loading default value 80%");
                    inMap.put("maxChance", 80.0);
                }
                if (!inMap.containsKey("maxLevel") || !(inMap.get("maxLevel") instanceof Double)) {
                    LogHandler.LOGGER.info("Error loading Fish Enchant Pool Item " + element.getKey() + " \"maxLevel\" is invalid, loading default value " + enchant.func_77325_b());
                    inMap.put("maxLevel", enchant.func_77325_b());
                }
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                Map<String, Object> outMap = output.get(element.getKey());
                double levelReq = (Double)inMap.get("levelReq");
                double levelPerLevel = (Double)inMap.get("levelPerLevel");
                double chancePerLevel = (Double)inMap.get("chancePerLevel");
                double maxChance = (Double)inMap.get("maxChance");
                double maxLevel = (Double)inMap.get("maxLevel");
                if (levelReq < 1.0) {
                    outMap.put("levelReq", 1.0);
                } else {
                    outMap.put("levelReq", levelReq);
                }
                if (levelPerLevel < 0.0) {
                    outMap.put("levelPerLevel", 0.0);
                } else {
                    outMap.put("levelPerLevel", levelPerLevel);
                }
                if (chancePerLevel < 0.0) {
                    outMap.put("chancePerLevel", 0.0);
                } else {
                    outMap.put("chancePerLevel", chancePerLevel);
                }
                if (maxChance < 0.0) {
                    outMap.put("maxChance", 0.0);
                } else if (maxChance > 100.0) {
                    outMap.put("maxChance", 100.0);
                } else {
                    outMap.put("maxChance", maxChance);
                }
                if (maxLevel < 1.0) {
                    outMap.put("maxLevel", enchant.func_77325_b());
                    continue;
                }
                outMap.put("maxLevel", maxLevel);
                continue;
            }
            LogHandler.LOGGER.info("Could not load inexistant enchant " + element.getKey());
        }
    }

    private static void updateReqAttributes(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (JsonConfig.checkValidAttributes(element.getValue())) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                    if (validAttributes.contains(entry.getKey())) {
                        output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    LogHandler.LOGGER.error("Invalid attribute " + entry.getKey());
                }
                continue;
            }
            LogHandler.LOGGER.error("No valid attributes, cannot add " + element.getKey());
        }
    }

    private static void updateCommand(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (Skill.getInt(element.getKey()) != 0) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                    if (entry.getValue() instanceof Double) {
                        if ((Double)entry.getValue() >= 1.0) {
                            output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        output.get(element.getKey()).put(entry.getKey(), 1.0);
                        continue;
                    }
                    LogHandler.LOGGER.error("Invalid level " + entry.getValue());
                }
                continue;
            }
            LogHandler.LOGGER.error("Invalid skill \"" + element.getKey() + "\" in Level Up Command");
        }
    }

    private static void updateSpecific(Map<String, Map<String, Object>> input, Map<String, Map<String, Object>> output) {
        for (Map.Entry<String, Map<String, Object>> element : input.entrySet()) {
            if (!output.containsKey(element.getKey())) {
                output.put(element.getKey(), new HashMap());
            }
            for (Map.Entry<String, Object> entry : element.getValue().entrySet()) {
                output.get(element.getKey()).put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean checkValidAttributes(Map<String, Object> theMap) {
        boolean anyValidAttributes = false;
        for (String key : theMap.keySet()) {
            if (validAttributes.contains(key)) {
                anyValidAttributes = true;
                continue;
            }
            LogHandler.LOGGER.info("Invalid attribute " + key);
        }
        return anyValidAttributes;
    }

    static {
        rawData = new HashMap<JType, Map<String, Map<String, Object>>>();
        localData = new HashMap<JType, Map<String, Map<String, Object>>>();
        data = new HashMap<JType, Map<String, Map<String, Object>>>();
        validAttributes = new ArrayList();
        validFishEnchantInfo = new ArrayList();
        invalidEffect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc("inexistantmodthatwillneverexist:potatochan"));
        invalidEnchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc("inexistantmodthatwillneverexist:potatochan"));
    }
}

