/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ct;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.entity.player.MCPlayerEntity;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.LogHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.pmmo.ct.Levels")
@ZenRegister
public class Levels {
    @ZenCodeType.Method(value="checkLevels")
    public static boolean checkLevels(MapData args, MCPlayerEntity mcPlayer) {
        PlayerEntity player = mcPlayer.getInternal();
        CompoundNBT reqLevels = args.getInternal();
        for (String key : reqLevels.func_150296_c()) {
            Skill skill = Skill.getSkill(key);
            if (skill.equals((Object)Skill.INVALID_SKILL)) {
                LogHandler.LOGGER.error("ZenScript -> PMMO -> checkLevels -> Invalid Skill Provided! \"" + key + "\"");
            }
            if (!(reqLevels.func_74769_h(key) > skill.getLevelDecimal(player))) continue;
            return false;
        }
        return true;
    }

    @ZenCodeType.Method(value="awardXp")
    public static void awardXp(MapData args, MCPlayerEntity mcPlayer, boolean ignoreBonuses) {
        PlayerEntity player = mcPlayer.getInternal();
        if (player instanceof ServerPlayerEntity) {
            CompoundNBT xpAwards = args.getInternal();
            for (String key : xpAwards.func_150296_c()) {
                Skill skill = Skill.getSkill(key);
                if (skill.equals((Object)Skill.INVALID_SKILL)) {
                    LogHandler.LOGGER.error("ZenScript -> PMMO -> awardXp -> Invalid Skill Provided! \"" + key + "\"");
                    continue;
                }
                skill.addXp((ServerPlayerEntity)player, xpAwards.func_74769_h(key), ignoreBonuses);
            }
        } else if (player instanceof ClientPlayerEntity) {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> awardXp -> Called from Client!");
        } else {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> awardXp -> Invalid Player Class! \"" + player.getClass().getName() + "\"");
        }
    }

    @ZenCodeType.Method(value="awardLevels")
    public static void awardLevels(MapData args, MCPlayerEntity mcPlayer) {
        PlayerEntity player = mcPlayer.getInternal();
        if (player instanceof ServerPlayerEntity) {
            CompoundNBT xpAwards = args.getInternal();
            for (String key : xpAwards.func_150296_c()) {
                Skill skill = Skill.getSkill(key);
                if (skill.equals((Object)Skill.INVALID_SKILL)) {
                    LogHandler.LOGGER.error("ZenScript -> PMMO -> awardLevels -> Invalid Skill Provided! \"" + key + "\"");
                    continue;
                }
                skill.addLevel((ServerPlayerEntity)player, xpAwards.func_74769_h(key), true);
            }
        } else if (player instanceof ClientPlayerEntity) {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> awardLevels -> Called from Client!");
        } else {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> awardLevels -> Invalid Player Class! \"" + player.getClass().getName() + "\"");
        }
    }

    @ZenCodeType.Method(value="setXp")
    public static void setXp(MapData args, MCPlayerEntity mcPlayer) {
        PlayerEntity player = mcPlayer.getInternal();
        if (player instanceof ServerPlayerEntity) {
            CompoundNBT xpAwards = args.getInternal();
            for (String key : xpAwards.func_150296_c()) {
                Skill skill = Skill.getSkill(key);
                if (skill.equals((Object)Skill.INVALID_SKILL)) {
                    LogHandler.LOGGER.error("ZenScript -> PMMO -> setXp -> Invalid Skill Provided! \"" + key + "\"");
                    continue;
                }
                skill.setXp((ServerPlayerEntity)player, xpAwards.func_74769_h(key));
            }
        } else if (player instanceof ClientPlayerEntity) {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> setXp -> Called from Client!");
        } else {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> setXp -> Invalid Player Class! \"" + player.getClass().getName() + "\"");
        }
    }

    @ZenCodeType.Method(value="setLevels")
    public static void setLevels(MapData args, MCPlayerEntity mcPlayer) {
        PlayerEntity player = mcPlayer.getInternal();
        if (player instanceof ServerPlayerEntity) {
            CompoundNBT xpAwards = args.getInternal();
            for (String key : xpAwards.func_150296_c()) {
                Skill skill = Skill.getSkill(key);
                if (skill.equals((Object)Skill.INVALID_SKILL)) {
                    LogHandler.LOGGER.error("ZenScript -> PMMO -> setLevels -> Invalid Skill Provided! \"" + key + "\"");
                    continue;
                }
                skill.setLevel((ServerPlayerEntity)player, xpAwards.func_74769_h(key));
            }
        } else if (player instanceof ClientPlayerEntity) {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> setLevels -> Called from Client!");
        } else {
            LogHandler.LOGGER.error("ZenScript -> PMMO -> setLevels -> Invalid Player Class! \"" + player.getClass().getName() + "\"");
        }
    }
}

