/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;

public class AnvilRepairHandler {
    public static void handleAnvilRepair(AnvilRepairEvent event) {
        if (Config.forgeConfig.anvilHandlingEnabled.get().booleanValue()) {
            try {
                PlayerEntity player = event.getPlayer();
                if (!player.field_70170_p.field_72995_K) {
                    boolean bypassEnchantLimit = Config.forgeConfig.bypassEnchantLimit.get();
                    int currLevel = XP.getLevel(Skill.SMITHING, player);
                    ItemStack rItem = event.getIngredientInput();
                    ItemStack lItem = event.getItemInput();
                    ItemStack oItem = event.getItemResult();
                    if (event.getItemInput().func_77973_b().func_77645_m()) {
                        float repaired;
                        double anvilCostReductionPerLevel = Config.forgeConfig.anvilCostReductionPerLevel.get();
                        double extraChanceToNotBreakAnvilPerLevel = Config.forgeConfig.extraChanceToNotBreakAnvilPerLevel.get() / 100.0;
                        double anvilFinalItemBonusRepaired = Config.forgeConfig.anvilFinalItemBonusRepaired.get() / 100.0;
                        int anvilFinalItemMaxCostToAnvil = Config.forgeConfig.anvilFinalItemMaxCostToAnvil.get();
                        double bonusRepair = anvilFinalItemBonusRepaired * (double)currLevel;
                        int maxCost = (int)Math.floor(50.0 - (double)currLevel * anvilCostReductionPerLevel);
                        if (maxCost < anvilFinalItemMaxCostToAnvil) {
                            maxCost = anvilFinalItemMaxCostToAnvil;
                        }
                        event.setBreakChance(event.getBreakChance() / (1.0f + (float)extraChanceToNotBreakAnvilPerLevel * (float)currLevel));
                        if (oItem.func_82838_A() > maxCost) {
                            oItem.func_82841_c(maxCost);
                        }
                        if ((repaired = (float)(oItem.func_77952_i() - lItem.func_77952_i())) < 0.0f) {
                            repaired = -repaired;
                        }
                        oItem.func_196085_b((int)Math.floor((double)oItem.func_77952_i() - (double)repaired * bonusRepair));
                        double award = ((double)repaired + (double)repaired * bonusRepair * 2.5) / 100.0 * (1.0 + (double)lItem.func_82838_A() * 0.025);
                        if (JsonConfig.data.get((Object)JType.SALVAGE_TO).containsKey(oItem.func_77973_b().getRegistryName().toString())) {
                            award *= ((Double)JsonConfig.data.get((Object)JType.SALVAGE_TO).get(oItem.func_77973_b().getRegistryName().toString()).get("xpPerItem")).doubleValue();
                        }
                        if (award > 0.0) {
                            NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraRepaired", "" + (int)repaired, "" + (int)((double)repaired * bonusRepair), true, 1), (ServerPlayerEntity)player);
                            XP.awardXp(player, Skill.SMITHING, "repairing an item by: " + repaired, award, false, false);
                        }
                    }
                    if (bypassEnchantLimit) {
                        Map lEnchants = EnchantmentHelper.func_82781_a((ItemStack)rItem);
                        Map rEnchants = EnchantmentHelper.func_82781_a((ItemStack)lItem);
                        Map<Enchantment, Integer> newEnchants = AnvilRepairHandler.mergeEnchants(lEnchants, rEnchants, player, currLevel);
                        EnchantmentHelper.func_82782_a(newEnchants, (ItemStack)oItem);
                    }
                }
            }
            catch (Exception e) {
                LogHandler.LOGGER.error("ANVIL FAILED, PLEASE REPORT", (Throwable)e);
            }
        }
    }

    public static Map<Enchantment, Integer> mergeEnchants(Map<Enchantment, Integer> lEnchants, Map<Enchantment, Integer> rEnchants, PlayerEntity player, int currLevel) {
        HashMap<Enchantment, Integer> newEnchants = new HashMap<Enchantment, Integer>();
        double bypassChance = Config.forgeConfig.upgradeChance.get();
        double failedBypassPenaltyChance = Config.forgeConfig.failedUpgradeKeepLevelChance.get();
        int levelsPerOneEnchantBypass = Config.forgeConfig.levelsPerOneEnchantBypass.get();
        int maxEnchantmentBypass = Config.forgeConfig.maxEnchantmentBypass.get();
        int maxEnchantLevel = Config.forgeConfig.maxEnchantLevel.get();
        boolean alwaysUseUpgradeChance = Config.forgeConfig.alwaysUseUpgradeChance.get();
        boolean creative = !XP.isPlayerSurvival(player);
        lEnchants.forEach((enchant, startLevel) -> {
            if (newEnchants.containsKey(enchant)) {
                if ((Integer)newEnchants.get(enchant) < startLevel) {
                    newEnchants.replace((Enchantment)enchant, (Integer)startLevel);
                }
            } else {
                newEnchants.put((Enchantment)enchant, (Integer)startLevel);
            }
        });
        rEnchants.forEach((enchant, startLevel) -> {
            if (newEnchants.containsKey(enchant)) {
                if ((Integer)newEnchants.get(enchant) < startLevel) {
                    newEnchants.replace((Enchantment)enchant, (Integer)startLevel);
                }
            } else {
                newEnchants.put((Enchantment)enchant, (Integer)startLevel);
            }
        });
        HashSet keys = new HashSet(newEnchants.keySet());
        keys.forEach(enchant -> {
            int startLevel = (Integer)newEnchants.get(enchant);
            int maxPlayerBypass = (int)Math.floor((double)currLevel / (double)levelsPerOneEnchantBypass);
            if (maxPlayerBypass > maxEnchantmentBypass) {
                maxPlayerBypass = maxEnchantmentBypass;
            }
            if (maxEnchantLevel < startLevel && !creative) {
                if (maxEnchantLevel > 0) {
                    newEnchants.replace((Enchantment)enchant, maxEnchantLevel);
                } else {
                    newEnchants.remove(enchant);
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.maxEnchantLevelWarning", enchant.func_200305_d(1).getString().replace(" I", ""), "" + maxEnchantLevel, false, 2), (ServerPlayerEntity)player);
            } else if (enchant.func_77325_b() + maxPlayerBypass < startLevel && !creative) {
                if (enchant.func_77325_b() + maxPlayerBypass > 0) {
                    newEnchants.replace((Enchantment)enchant, enchant.func_77325_b() + maxPlayerBypass);
                } else {
                    newEnchants.remove(enchant);
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantmentDegradedWarning", enchant.func_200305_d(1).getString().replace(" I", ""), "" + (enchant.func_77325_b() + maxPlayerBypass), false, 2), (ServerPlayerEntity)player);
            } else if (lEnchants.get(enchant) != null && rEnchants.get(enchant) != null && ((Integer)lEnchants.get(enchant)).intValue() == ((Integer)rEnchants.get(enchant)).intValue()) {
                if (startLevel + 1 > maxEnchantLevel && !creative) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.maxEnchantLevelWarning", enchant.func_200305_d(1).getString().replace(" I", ""), "" + maxEnchantLevel, false, 2), (ServerPlayerEntity)player);
                } else if (startLevel + 1 > enchant.func_77325_b() + maxPlayerBypass && !creative) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.enchantLackOfLevelWarning", new Object[]{enchant.func_200305_d(1).getString().replace(" I", "")}).func_240703_c_(XP.textStyle.get("red")), false);
                } else if ((startLevel >= enchant.func_77325_b() || alwaysUseUpgradeChance) && !creative) {
                    if (Math.ceil(Math.random() * 100.0) <= bypassChance) {
                        newEnchants.replace((Enchantment)enchant, startLevel + 1);
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeSuccess", enchant.func_200305_d(1).getString().replace(" I", ""), "" + (startLevel + 1), false, 1), (ServerPlayerEntity)player);
                    } else if (Math.ceil(Math.random() * 100.0) <= failedBypassPenaltyChance) {
                        if (startLevel > 1) {
                            newEnchants.replace((Enchantment)enchant, startLevel - 1);
                        } else {
                            newEnchants.remove(enchant);
                        }
                        NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.enchantUpgradeAndSaveFail", enchant.func_200305_d(1).getString().replace(" I", ""), "" + bypassChance, "" + failedBypassPenaltyChance, false, 2), (ServerPlayerEntity)player);
                    } else {
                        newEnchants.replace((Enchantment)enchant, startLevel);
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeFail", enchant.func_200305_d(1).getString().replace(" I", ""), "" + bypassChance, false, 3), (ServerPlayerEntity)player);
                    }
                } else {
                    newEnchants.replace((Enchantment)enchant, startLevel + 1);
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeSuccess", enchant.func_200305_d(1).getString().replace(" I", ""), "" + (startLevel + 1), false, 1), (ServerPlayerEntity)player);
                }
            }
        });
        return newEnchants;
    }
}

