/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;

public class BlockBrokenHandler {
    public static void handleBroken(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof FakePlayer)) {
            BlockBrokenHandler.processReq(event);
        }
    }

    private static void processReq(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockState blockState = event.getState();
        Block block = blockState.func_177230_c();
        World world = event.getWorld().func_201672_e();
        Material material = event.getState().func_185904_a();
        Block blockAbove = world.func_180495_p(event.getPos().func_177984_a()).func_177230_c();
        boolean passedBreakReq = true;
        if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) && blockAbove instanceof IPlantable) {
            passedBreakReq = XP.checkReq(player, blockAbove.getRegistryName(), JType.REQ_BREAK);
        }
        if (!passedBreakReq) {
            block = blockAbove;
        } else {
            passedBreakReq = XP.checkReq(player, block.getRegistryName(), JType.REQ_BREAK);
        }
        if (passedBreakReq) {
            if (XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL)) {
                BlockBrokenHandler.processBroken(event);
                ChunkDataHandler.delPos(world.func_234922_V_().func_240901_a_(), event.getPos());
            }
        } else {
            if (XP.correctHarvestTool(material).equals("axe")) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) || block instanceof IPlantable) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            }
            for (Map.Entry<String, Object> entry : JsonConfig.data.get((Object)JType.REQ_BREAK).get(block.getRegistryName().toString()).entrySet()) {
                int startLevel = XP.getLevel(Skill.getSkill(entry.getKey()), player);
                double entryValue = 1.0;
                if (entry.getValue() instanceof Double) {
                    entryValue = (Double)entry.getValue();
                }
                if ((double)startLevel < entryValue) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 2), (ServerPlayerEntity)player);
                    continue;
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 1), (ServerPlayerEntity)player);
            }
            event.setCanceled(true);
        }
    }

    private static boolean rollChance(double extraChance) {
        return Math.random() < extraChance;
    }

    private static void processBroken(BlockEvent.BreakEvent event) {
        List drops;
        boolean veiningAllowed;
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        String regKey = block.getRegistryName().toString();
        World world = event.getWorld().func_201672_e();
        PlayerEntity player = event.getPlayer();
        boolean bl = veiningAllowed = Config.config.containsKey("veiningAllowed") && Config.config.get("veiningAllowed") != 0.0;
        if (XP.isVeining.contains(player.func_110124_au()) && veiningAllowed && !WorldTickHandler.activeVein.containsKey(player)) {
            WorldTickHandler.scheduleVein(player, new VeinInfo(world, state, event.getPos(), player.func_184614_ca()));
        }
        if (player.func_184812_l_()) {
            return;
        }
        Material material = event.getState().func_185904_a();
        double blockHardnessLimitForBreaking = Config.forgeConfig.blockHardnessLimitForBreaking.get();
        boolean wasPlaced = ChunkDataHandler.checkPos(event.getWorld().func_201672_e().func_234922_V_().func_240901_a_(), event.getPos()) != null;
        ItemStack toolUsed = player.func_184614_ca();
        String skill = XP.getSkill(material).name().toLowerCase();
        double hardness = state.func_185887_b((IBlockReader)event.getWorld(), event.getPos());
        if (hardness > blockHardnessLimitForBreaking) {
            hardness = blockHardnessLimitForBreaking;
        }
        boolean isEffective = true;
        String awardMsg = "";
        Map<String, Double> award = new HashMap<String, Double>();
        award.put(skill, hardness);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)player.func_184614_ca());
        int fortune = 0;
        if (enchants.get(Enchantments.field_185308_t) != null) {
            fortune = (Integer)enchants.get(Enchantments.field_185308_t);
        }
        if (world instanceof ServerWorld) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)event.getPos()).func_216015_a(LootParameters.field_216289_i, (Object)toolUsed).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(event.getPos()));
            if (fortune > 0) {
                builder.func_186469_a((float)fortune);
            }
            drops = block.func_220076_a(event.getState(), builder);
        } else {
            drops = new ArrayList();
        }
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            Block baseBlock = event.getState().func_177230_c();
            BlockPos baseBlockPos = event.getPos();
            double extraChance = XP.getExtraChance(player, block.getRegistryName(), JType.INFO_PLANT) / 100.0;
            int totalDrops = 0;
            int guaranteedDrop = 0;
            int extraDrop = 0;
            int rewardable = 0;
            int guaranteedDropEach = (int)Math.floor(extraChance);
            extraChance = (extraChance - Math.floor(extraChance)) * 100.0;
            int height = 0;
            BlockPos curBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + height, baseBlockPos.func_177952_p());
            block = world.func_180495_p(curBlockPos).func_177230_c();
            while (block.equals(baseBlock)) {
                boolean bl2 = wasPlaced = ChunkDataHandler.checkPos(event.getWorld().func_201672_e().func_234922_V_().func_240901_a_(), curBlockPos) != null;
                if (!wasPlaced) {
                    ++rewardable;
                    guaranteedDrop += guaranteedDropEach;
                    if (Math.ceil(Math.random() * 1000.0) <= extraChance * 10.0) {
                        ++extraDrop;
                    }
                }
                curBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + ++height, baseBlockPos.func_177952_p());
                block = world.func_180495_p(curBlockPos).func_177230_c();
            }
            int dropsLeft = guaranteedDrop + extraDrop;
            if (dropsLeft > 0) {
                XP.dropItems(dropsLeft, block.func_199767_j(), world, event.getPos());
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + dropsLeft, ((ItemStack)drops.get(0)).func_77977_a(), true, 1), (ServerPlayerEntity)player);
            }
            totalDrops = rewardable + dropsLeft;
            award = XP.addMaps(award, XP.multiplyMap(XP.getXp(baseBlock.getRegistryName(), JType.XP_VALUE_BREAK), totalDrops));
            awardMsg = "removing " + height + " + " + (guaranteedDrop + extraDrop) + " extra";
        } else if ((material.equals(Material.field_151585_k) || material.equals(Material.field_203243_f) || material.equals(Material.field_151582_l)) && drops.size() > 0) {
            ItemStack theDropItem = (ItemStack)drops.get(0);
            int theDropCount = 0;
            for (ItemStack drop : drops) {
                theDropCount += drop.func_190916_E();
            }
            int age = -1;
            int maxAge = -1;
            if (!wasPlaced) {
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), theDropItem.func_190916_E()));
            }
            if (state.func_235901_b_((Property)BlockStateProperties.field_222512_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_222512_Y);
                maxAge = 1;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208167_T)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208167_T);
                maxAge = 2;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208168_U);
                maxAge = 3;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208169_V)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208169_V);
                maxAge = 5;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208170_W);
                maxAge = 7;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208171_X)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208171_X);
                maxAge = 15;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208172_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208172_Y);
                maxAge = 25;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208135_aj)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208135_aj);
                maxAge = 4;
                if (wasPlaced) {
                    return;
                }
            }
            if (age == maxAge && age >= 0 || block instanceof SeaPickleBlock) {
                award = new HashMap();
                award.put(skill, hardness);
                double extraChance = XP.getExtraChance(player, block.getRegistryName(), JType.INFO_PLANT) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = BlockBrokenHandler.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, ((ItemStack)drops.get(0)).func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, ((ItemStack)drops.get(0)).func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                int totalDrops = theDropCount + totalExtraDrops;
                award = XP.multiplyMap(XP.addMaps(award, XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK)), totalDrops);
                awardMsg = "harvesting " + theDropCount + " + " + totalExtraDrops + " crops";
            } else if (!wasPlaced) {
                awardMsg = "breaking a plant";
            }
        } else if (XP.getExtraChance(player, block.getRegistryName(), JType.INFO_ORE) > 0.0) {
            boolean isSilk = enchants.get(Enchantments.field_185306_r) != null;
            boolean noDropOre = false;
            if (drops.size() > 0) {
                noDropOre = block.func_199767_j().equals(((ItemStack)drops.get(0)).func_77973_b());
            }
            if (!wasPlaced && !isSilk) {
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), ((ItemStack)drops.get(0)).func_190916_E()));
            }
            if (noDropOre && !wasPlaced || !noDropOre && !isSilk) {
                double extraChance = XP.getExtraChance(player, block.getRegistryName(), JType.INFO_ORE) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = BlockBrokenHandler.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                if (!noDropOre && wasPlaced) {
                    award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), ((ItemStack)drops.get(0)).func_190916_E()));
                }
                awardMsg = "mining a block";
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, ((ItemStack)drops.get(0)).func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, ((ItemStack)drops.get(0)).func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), totalExtraDrops));
            } else {
                awardMsg = "mining a block";
            }
        } else if (XP.getExtraChance(player, block.getRegistryName(), JType.INFO_LOG) > 0.0 && isEffective) {
            if (!wasPlaced) {
                int extraDrop;
                double extraChance = XP.getExtraChance(player, block.getRegistryName(), JType.INFO_LOG) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int totalExtraDrops = guaranteedDrop + (extraDrop = BlockBrokenHandler.rollChance(extraChance % 1.0) ? 1 : 0);
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, ((ItemStack)drops.get(0)).func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, ((ItemStack)drops.get(0)).func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), ((ItemStack)drops.get(0)).func_190916_E() + totalExtraDrops));
                awardMsg = "cutting a block";
            } else {
                awardMsg = "cutting a block";
            }
        } else {
            if (!wasPlaced) {
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), drops.size()));
            }
            switch (XP.getSkill(material)) {
                case MINING: {
                    awardMsg = "mining a block";
                    break;
                }
                case WOODCUTTING: {
                    awardMsg = "cutting a block";
                    break;
                }
                case EXCAVATION: {
                    awardMsg = "digging a block";
                    break;
                }
                case FARMING: {
                    awardMsg = "harvesting";
                    break;
                }
            }
        }
        int gap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL);
        if (gap > 0) {
            player.func_184614_ca().func_222118_a(gap - 1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
        }
        if (XP.isPlayerSurvival(player)) {
            for (String skillName : award.keySet()) {
                XP.awardXp(player, Skill.getSkill(skillName), awardMsg, award.get(skillName) / (double)(gap + 1), false, false);
            }
        }
    }
}

