/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BreakSpeedHandler {
    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        String skill = XP.getSkill(event.getState().func_185904_a()).name().toLowerCase();
        double speedBonus = 0.0;
        int toolGap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL);
        if (!XP.checkReq(player, event.getState().func_177230_c().getRegistryName(), JType.REQ_BREAK)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslationTextComponent(event.getState().func_177230_c().func_149739_a())}).func_240703_c_(XP.textStyle.get("red")), true);
        } else if (toolGap > 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslationTextComponent(player.func_184614_ca().func_77977_a())}).func_240703_c_(XP.textStyle.get("red")), true);
        }
        int startLevel = XP.getLevel(Skill.getSkill(skill), player);
        switch (XP.correctHarvestTool(event.getState().func_185904_a())) {
            case "pickaxe": {
                double blocksToUnbreakableY;
                double heightMultiplier;
                float height = event.getPos().func_177956_o();
                if (height < 0.0f) {
                    height = -height;
                }
                if ((heightMultiplier = 1.0 - (double)height / (blocksToUnbreakableY = Config.forgeConfig.blocksToUnbreakableY.get().doubleValue())) < Config.forgeConfig.minBreakSpeed.get()) {
                    heightMultiplier = Config.forgeConfig.minBreakSpeed.get();
                }
                speedBonus = Config.forgeConfig.miningBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus) * (float)heightMultiplier);
                break;
            }
            case "axe": {
                speedBonus = Config.forgeConfig.woodcuttingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "shovel": {
                speedBonus = Config.forgeConfig.excavationBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "hoe": {
                speedBonus = Config.forgeConfig.farmingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            default: {
                event.setNewSpeed(event.getOriginalSpeed());
            }
        }
        event.setNewSpeed(event.getNewSpeed() / (float)(toolGap + 1));
    }
}

