/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.TooltipHandler;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageKeypress;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static boolean wasVeining = false;
    private static boolean wasOpenMenu = false;
    private static boolean wasOpenSettings = false;
    private static boolean wasOpenSkills = false;
    private static boolean wasOpenGlossary = false;
    private static boolean tooltipKeyWasPressed = false;

    public static void subscribeClientEvents(IEventBus eventBus) {
        eventBus.register(ClientEventHandler.class);
    }

    @SubscribeEvent
    public static void keyPressEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            if (wasVeining != ClientHandler.VEIN_KEY.func_151470_d()) {
                wasVeining = ClientHandler.VEIN_KEY.func_151470_d();
                NetworkHandler.sendToServer(new MessageKeypress(ClientHandler.VEIN_KEY.func_151470_d(), 1));
            }
            if (wasOpenMenu != ClientHandler.OPEN_MENU.func_151470_d() || wasOpenSettings != ClientHandler.OPEN_SETTINGS.func_151470_d() || wasOpenSkills != ClientHandler.OPEN_SKILLS.func_151470_d() || wasOpenGlossary != ClientHandler.OPEN_GLOSSARY.func_151470_d()) {
                UUID uuid = Minecraft.func_71410_x().field_71439_g.func_110124_au();
                String name = Minecraft.func_71410_x().field_71439_g.func_145748_c_().getString();
                XP.playerNames.put(uuid, name);
                if (!XP.skills.containsKey(uuid)) {
                    XP.skills.put(uuid, new HashMap());
                }
                XPOverlayGUI.skills.forEach((skill, aSkill) -> XP.skills.get(uuid).put(skill.name().toLowerCase(), aSkill.goalXp));
                if (ClientHandler.OPEN_MENU.func_151470_d()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(uuid, (ITextComponent)new TranslationTextComponent("pmmo.potato")));
                    wasOpenMenu = ClientHandler.OPEN_MENU.func_151470_d();
                } else if (ClientHandler.OPEN_SETTINGS.func_151470_d()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new PrefsChoiceScreen((ITextComponent)new TranslationTextComponent("pmmo.preferences")));
                    wasOpenSettings = ClientHandler.OPEN_SETTINGS.func_151470_d();
                } else if (ClientHandler.OPEN_SKILLS.func_151470_d()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(uuid, (ITextComponent)new TranslationTextComponent("pmmo.stats"), JType.STATS, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
                    wasOpenSkills = ClientHandler.OPEN_SKILLS.func_151470_d();
                } else if (ClientHandler.OPEN_GLOSSARY.func_151470_d()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(uuid, (ITextComponent)new TranslationTextComponent("pmmo.glossary")));
                    wasOpenGlossary = ClientHandler.OPEN_GLOSSARY.func_151470_d();
                }
            }
            if (Minecraft.func_71410_x().field_71439_g != null && ClientHandler.TOGGLE_TOOLTIP.func_151470_d() && !tooltipKeyWasPressed) {
                boolean bl = TooltipHandler.tooltipOn = !TooltipHandler.tooltipOn;
                if (TooltipHandler.tooltipOn) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.tooltipOn"), true);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.tooltipOff"), true);
                }
            }
            tooltipKeyWasPressed = ClientHandler.TOGGLE_TOOLTIP.func_151470_d();
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        TooltipHandler.handleTooltip(event);
    }
}

