/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class DamageHandler {
    public static void handleDamage(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof FakePlayer) && !(event.getEntity() instanceof FakePlayer)) {
            PlayerEntity player;
            float damage;
            float startDmg = damage = event.getAmount();
            LivingEntity target = event.getEntityLiving();
            if (target instanceof PlayerEntity) {
                double endured;
                double maxEndurance;
                double endurancePerLevel;
                player = (PlayerEntity)target;
                CompoundNBT skillsTag = XP.getSkillsTag(player);
                double agilityXp = 0.0;
                double enduranceXp = 0.0;
                boolean hideEndurance = false;
                int enduranceLevel = XP.levelAtXp(skillsTag.func_74769_h("endurance"));
                double endurePercent = (double)enduranceLevel * (endurancePerLevel = Config.forgeConfig.endurancePerLevel.get().doubleValue());
                if (endurePercent > (maxEndurance = Config.forgeConfig.maxEndurance.get().doubleValue())) {
                    endurePercent = maxEndurance;
                }
                if ((endured = (double)damage * (endurePercent /= 100.0)) < 0.0) {
                    endured = 0.0;
                }
                damage = (float)((double)damage - endured);
                enduranceXp = (double)(damage * 5.0f) + endured * 7.5;
                if (event.getSource().func_76355_l().equals("fall")) {
                    double award = startDmg;
                    int agilityLevel = XP.levelAtXp(skillsTag.func_74769_h("agility"));
                    int saved = 0;
                    double maxFallSaveChance = Config.forgeConfig.maxFallSaveChance.get();
                    double saveChancePerLevel = Config.forgeConfig.saveChancePerLevel.get() / 100.0;
                    double chance = (double)agilityLevel * saveChancePerLevel;
                    if (chance > maxFallSaveChance) {
                        chance = maxFallSaveChance;
                    }
                    int i = 0;
                    while ((float)i < damage) {
                        if (Math.ceil(Math.random() * 100.0) <= chance) {
                            ++saved;
                        }
                        ++i;
                    }
                    if ((damage -= (float)saved) <= 0.0f) {
                        event.setCanceled(true);
                    }
                    if (saved != 0 && player.func_110143_aJ() > damage) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedFall", new Object[]{saved}), true);
                    }
                    agilityXp = award = (double)(saved * 25);
                }
                event.setAmount(damage);
                if (player.func_110143_aJ() > damage) {
                    if (agilityXp > 0.0) {
                        hideEndurance = true;
                    }
                    if (event.getSource().func_76346_g() != null) {
                        XP.awardXp(player, Skill.ENDURANCE, event.getSource().func_76346_g().func_145748_c_().getString(), enduranceXp, hideEndurance, false);
                    } else {
                        XP.awardXp(player, Skill.ENDURANCE, event.getSource().func_76355_l(), enduranceXp, hideEndurance, false);
                    }
                    if (agilityXp > 0.0) {
                        XP.awardXp(player, Skill.AGILITY, "surviving " + startDmg + " fall damage", agilityXp, false, false);
                    }
                }
            }
            if (target instanceof LivingEntity && event.getSource().func_76346_g() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getSource().func_76346_g();
                if (player.func_184614_ca().func_77973_b().equals(Items.field_196180_eI)) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(target.func_70022_Q()), false);
                }
                if (XP.isPlayerSurvival(player)) {
                    int weaponGap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_WEAPON);
                    if (weaponGap > 0) {
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToUseAsWeapon", player.func_184614_ca().func_77977_a(), "", true, 2), (ServerPlayerEntity)player);
                    }
                    int slayerGap = 0;
                    if (target.func_70022_Q() != null && (slayerGap = XP.getSkillReqGap(player, XP.getResLoc(target.func_70022_Q()), JType.REQ_KILL)) > 0) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslationTextComponent(target.func_200600_R().func_210760_d())}).func_240703_c_(XP.textStyle.get("red")), true);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslationTextComponent(target.func_200600_R().func_210760_d())}).func_240703_c_(XP.textStyle.get("red")), false);
                        for (Map.Entry<String, Object> entry : JsonConfig.data.get((Object)JType.REQ_KILL).get(target.func_70022_Q()).entrySet()) {
                            int level = XP.getLevel(Skill.getSkill(entry.getKey()), player);
                            if ((double)level < (Double)entry.getValue()) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + (int)Math.floor((Double)entry.getValue())}).func_240703_c_(XP.textStyle.get("red")), false);
                                continue;
                            }
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + (int)Math.floor((Double)entry.getValue())}).func_240703_c_(XP.textStyle.get("green")), false);
                        }
                    }
                    event.setAmount(event.getAmount() / (float)(weaponGap + 1) / (float)(slayerGap + 1));
                    damage = event.getAmount();
                    float amount = 0.0f;
                    float playerHealth = player.func_110143_aJ();
                    float targetHealth = target.func_110143_aJ();
                    float targetMaxHealth = target.func_110138_aP();
                    float lowHpBonus = 1.0f;
                    if (damage > targetHealth) {
                        damage = targetHealth;
                    }
                    amount += damage * 3.0f;
                    if (startDmg >= targetHealth) {
                        amount /= 2.0f;
                    }
                    if (startDmg >= targetMaxHealth) {
                        amount = (float)((double)amount / 1.5);
                    }
                    if (target instanceof AnimalEntity) {
                        amount /= 2.0f;
                    } else if (playerHealth <= 10.0f) {
                        lowHpBonus += (11.0f - playerHealth) / 5.0f;
                        if (playerHealth <= 2.0f) {
                            lowHpBonus += 1.0f;
                        }
                    }
                    if (event.getSource().field_76373_n.equals("arrow")) {
                        double distance = event.getEntity().func_70032_d((Entity)player);
                        distance = distance > 16.0 ? (distance -= 16.0) : 0.0;
                        amount = (float)((double)amount + Math.pow(distance, 1.25) * (double)(damage / target.func_110138_aP()) * (damage >= targetMaxHealth ? 1.5 : 1.0));
                        XP.awardXp(player, Skill.ARCHERY, player.func_184614_ca().func_200301_q().toString(), amount *= lowHpBonus, false, false);
                    } else {
                        XP.awardXp(player, Skill.COMBAT, player.func_184614_ca().func_200301_q().toString(), amount *= lowHpBonus, false, false);
                    }
                    if (weaponGap > 0) {
                        player.func_184614_ca().func_222118_a(weaponGap - 1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
                    }
                }
            }
        }
    }
}

