/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DeathHandler {
    public static void handleDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        double deathXpPenaltyMultiplier = Config.forgeConfig.deathXpPenaltyMultiplier.get();
        double passiveMobHunterXp = Config.forgeConfig.passiveMobHunterXp.get();
        double aggresiveMobSlayerXp = Config.forgeConfig.aggresiveMobSlayerXp.get();
        if (target instanceof PlayerEntity && !(target instanceof FakePlayer)) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (!player.field_70170_p.func_201670_d()) {
                boolean bl;
                CompoundNBT skillsTag = XP.getSkillsTag(player);
                CompoundNBT prefsTag = XP.getPreferencesTag(player);
                double totalLost = 0.0;
                boolean bl2 = Config.forgeConfig.wipeAllSkillsUponDeathPermanently.get();
                if (prefsTag.func_74764_b("wipeAllSkillsUponDeathPermanently") && prefsTag.func_74769_h("wipeAllSkillsUponDeathPermanently") != 0.0) {
                    bl = true;
                }
                if (bl) {
                    for (String key : new HashSet(skillsTag.func_150296_c())) {
                        totalLost += skillsTag.func_74769_h(key);
                        skillsTag.func_82580_o(key);
                    }
                } else {
                    for (String key : new HashSet(skillsTag.func_150296_c())) {
                        double startXp = skillsTag.func_74769_h(key);
                        double floorXp = XP.xpAtLevelDecimal(Math.floor(XP.levelAtXpDecimal(startXp)));
                        double diffXp = startXp - floorXp;
                        double lostXp = diffXp * deathXpPenaltyMultiplier;
                        double finalXp = startXp - lostXp;
                        totalLost += lostXp;
                        if (finalXp > 0.0) {
                            skillsTag.func_74780_a(key, finalXp);
                            continue;
                        }
                        skillsTag.func_82580_o(key);
                    }
                }
                if (totalLost > 0.0) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.lostXp", new Object[]{DP.dprefix(totalLost)}).func_240703_c_(XP.textStyle.get("red")), false);
                }
                XP.syncPlayer(player);
            }
        } else if (source instanceof PlayerEntity && !(source instanceof FakePlayer)) {
            PlayerEntity player = (PlayerEntity)source;
            Collection<PlayerEntity> nearbyPlayers = XP.getNearbyPlayers((Entity)target);
            double scaleValue = 0.0;
            for (PlayerEntity playerEntity : nearbyPlayers) {
                if (XP.getPowerLevel(player) > 1.0f) {
                    scaleValue += 1.0;
                    continue;
                }
                scaleValue += (double)XP.getPowerLevel(playerEntity);
            }
            if ((scaleValue /= 5.0) < 1.0) {
                scaleValue = 1.0;
            }
            if (scaleValue > 10.0) {
                scaleValue = 10.0;
            }
            if (JsonConfig.data.get((Object)JType.XP_VALUE_KILL).containsKey(target.func_70022_Q())) {
                Map<String, Object> killXp = JsonConfig.data.get((Object)JType.XP_VALUE_KILL).get(target.func_70022_Q());
                for (Map.Entry<String, Object> entry : killXp.entrySet()) {
                    XP.awardXp(player, Skill.getSkill(entry.getKey()), player.func_184614_ca().func_200301_q().toString(), (Double)entry.getValue() * scaleValue, false, false);
                }
            } else if (target instanceof AnimalEntity) {
                XP.awardXp(player, Skill.HUNTER, player.func_184614_ca().func_200301_q().toString(), passiveMobHunterXp * scaleValue, false, false);
            } else if (target instanceof MobEntity) {
                XP.awardXp(player, Skill.SLAYER, player.func_184614_ca().func_200301_q().toString(), aggresiveMobSlayerXp * scaleValue, false, false);
            }
            if (JsonConfig.data.get((Object)JType.MOB_RARE_DROP).containsKey(target.func_70022_Q())) {
                Map<String, Object> dropTable = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(target.func_70022_Q());
                for (Map.Entry<String, Object> entry : dropTable.entrySet()) {
                    double d = (Double)entry.getValue();
                    if (Math.floor(Math.random() * (d /= scaleValue)) != 0.0) continue;
                    ItemStack itemStack = new ItemStack((IItemProvider)XP.getItem(entry.getKey()));
                    XP.dropItemStack(itemStack, player.field_70170_p, target.func_213303_ch());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.rareDrop", new Object[]{new TranslationTextComponent(itemStack.func_77977_a())}).func_240703_c_(XP.textStyle.get("green")), false);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.rareDrop", new Object[]{new TranslationTextComponent(itemStack.func_77977_a())}).func_240703_c_(XP.textStyle.get("green")), true);
                }
            }
        }
    }
}

