/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteractionHandler {
    public static void handleItemUse(PlayerInteractEvent event) {
        try {
            if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickItem) {
                PlayerEntity player = event.getPlayer();
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.func_77973_b();
                Block goldBlock = Blocks.field_150340_R;
                Block smithBlock = Blocks.field_222429_lR;
                if (item.getRegistryName() == null) {
                    return;
                }
                String regKey = item.getRegistryName().toString();
                boolean isRemote = player.field_70170_p.func_201670_d();
                if (event instanceof PlayerInteractEvent.RightClickItem && XP.isPlayerSurvival(player) && JsonConfig.data.get((Object)JType.SALVAGE_TO).containsKey(regKey)) {
                    boolean matched = XP.scanBlock(smithBlock, 1, player);
                    if (!matched) {
                        matched = XP.scanBlock(goldBlock, 1, player);
                    }
                    if (matched) {
                        event.setCanceled(true);
                    }
                }
                if (item instanceof BlockItem) {
                    if (!XP.checkReq(player, item.getRegistryName(), JType.REQ_PLACE)) {
                        event.setCanceled(true);
                        if (isRemote) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToPlaceDown", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_240703_c_(XP.textStyle.get("red")), true);
                        }
                    }
                } else if (!XP.checkReq(player, item.getRegistryName(), JType.REQ_USE)) {
                    event.setCanceled(true);
                    if (isRemote) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_240703_c_(XP.textStyle.get("red")), true);
                    }
                }
                if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    Block block = player.field_70170_p.func_180495_p(event.getPos()).func_177230_c();
                    if (!XP.checkReq(player, block.getRegistryName(), JType.REQ_USE)) {
                        if (XP.isPlayerSurvival(player)) {
                            event.setCanceled(true);
                            if (isRemote && event.getHand().equals((Object)Hand.MAIN_HAND)) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a())}).func_240703_c_(XP.textStyle.get("red")), true);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a())}).func_240703_c_(XP.textStyle.get("red")), false);
                                for (Map.Entry<String, Object> entry : JsonConfig.data.get((Object)JType.REQ_USE).get(block.getRegistryName().toString()).entrySet()) {
                                    int startLevel = XP.getLevel(Skill.getSkill(entry.getKey()), player);
                                    double entryValue = 1.0;
                                    if (entry.getValue() instanceof Double) {
                                        entryValue = (Double)entry.getValue();
                                    }
                                    if ((double)startLevel < entryValue) {
                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + DP.dpSoft(entryValue)}).func_240703_c_(XP.textStyle.get("red")), false);
                                        continue;
                                    }
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + DP.dpSoft(entryValue)}).func_240703_c_(XP.textStyle.get("green")), false);
                                }
                            }
                        }
                    } else {
                        event.setCanceled(false);
                        Block anvil = Blocks.field_150467_bQ;
                        Block ironBlock = Blocks.field_150339_S;
                        Block diamondBlock = Blocks.field_150484_ah;
                        int smithingLevel = XP.getLevel(Skill.SMITHING, player);
                        int maxEnchantmentBypass = Config.forgeConfig.maxEnchantmentBypass.get();
                        int levelsPerOneEnchantBypass = Config.forgeConfig.levelsPerOneEnchantBypass.get();
                        int maxPlayerBypass = (int)Math.floor((double)smithingLevel / (double)levelsPerOneEnchantBypass);
                        if (maxPlayerBypass > maxEnchantmentBypass) {
                            maxPlayerBypass = maxEnchantmentBypass;
                        }
                        if (player.func_213453_ef()) {
                            if ((block.equals(ironBlock) || block.equals(anvil)) && event.getHand() != Hand.MAIN_HAND) {
                                return;
                            }
                            if (block.equals(goldBlock) || block.equals(smithBlock)) {
                                if (JsonConfig.data.get((Object)JType.SALVAGE_TO).containsKey(regKey)) {
                                    event.setCanceled(true);
                                }
                                if (isRemote) {
                                    return;
                                }
                                if (event.getHand().equals((Object)Hand.OFF_HAND) && !(item = (itemStack = player.func_184592_cb()).func_77973_b()).equals(Items.field_190931_a)) {
                                    if (JsonConfig.data.get((Object)JType.SALVAGE_TO).containsKey(regKey)) {
                                        if (player.func_213303_ch().func_237488_a_((IPosition)XP.blockToVec(event.getPos()), 2.0)) {
                                            Map<String, Object> theMap = JsonConfig.data.get((Object)JType.SALVAGE_TO).get(regKey);
                                            Item salvageItem = XP.getItem((String)theMap.get("salvageItem"));
                                            if (!salvageItem.equals(Items.field_190931_a)) {
                                                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                                                double baseChance = (Double)theMap.get("baseChance");
                                                double chancePerLevel = (Double)theMap.get("chancePerLevel");
                                                double maxSalvageMaterialChance = (Double)theMap.get("maxChance");
                                                int reqLevel = (int)Math.floor((Double)theMap.get("levelReq"));
                                                int salvageMax = (int)Math.floor((Double)theMap.get("salvageMax"));
                                                if ((smithingLevel -= reqLevel) >= 0) {
                                                    double enchantChance;
                                                    double chance = baseChance + chancePerLevel * (double)smithingLevel;
                                                    double maxSalvageEnchantChance = Config.forgeConfig.maxSalvageEnchantChance.get();
                                                    double enchantSaveChancePerLevel = Config.forgeConfig.enchantSaveChancePerLevel.get();
                                                    if (chance > maxSalvageMaterialChance) {
                                                        chance = maxSalvageMaterialChance;
                                                    }
                                                    if ((enchantChance = (double)smithingLevel * enchantSaveChancePerLevel) > maxSalvageEnchantChance) {
                                                        enchantChance = maxSalvageEnchantChance;
                                                    }
                                                    double startDmg = itemStack.func_77952_i();
                                                    double maxDmg = itemStack.func_77958_k();
                                                    double award = 0.0;
                                                    double displayDurabilityPercent = (1.0 - startDmg / maxDmg) * 100.0;
                                                    double durabilityPercent = 1.0 - startDmg / maxDmg;
                                                    if (Double.isNaN(durabilityPercent)) {
                                                        durabilityPercent = 1.0;
                                                    }
                                                    int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                                                    if (event.getHand() == Hand.OFF_HAND) {
                                                        if (XP.isPlayerSurvival(player)) {
                                                            int returnAmount = 0;
                                                            for (int i = 0; i < potentialReturnAmount; ++i) {
                                                                if (!(Math.ceil(Math.random() * 10000.0) <= chance * 100.0)) continue;
                                                                ++returnAmount;
                                                            }
                                                            award += (Double)theMap.get("xpPerItem") * (double)returnAmount;
                                                            if (returnAmount > 0) {
                                                                XP.dropItems(returnAmount, salvageItem, event.getWorld(), event.getPos());
                                                            }
                                                            if (award > 0.0) {
                                                                XP.awardXp(player, Skill.SMITHING, "salvaging " + returnAmount + "/" + salvageMax + " from an item", award, false, false);
                                                            }
                                                            if (returnAmount == potentialReturnAmount) {
                                                                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageItem.func_77658_a(), true, 1), (ServerPlayerEntity)player);
                                                            } else if (returnAmount > 0) {
                                                                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageItem.func_77658_a(), true, 3), (ServerPlayerEntity)player);
                                                            } else {
                                                                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageItem.func_77658_a(), true, 2), (ServerPlayerEntity)player);
                                                            }
                                                            if (enchants.size() > 0) {
                                                                ItemStack salvagedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                                                                Set enchantKeys = enchants.keySet();
                                                                HashMap<Enchantment, Integer> newEnchantMap = new HashMap<Enchantment, Integer>();
                                                                boolean fullEnchants = true;
                                                                for (Enchantment enchant : enchantKeys) {
                                                                    int enchantLevel = 0;
                                                                    for (int i = 1; i <= (Integer)enchants.get(enchant); ++i) {
                                                                        if (Math.floor(Math.random() * 100.0) < enchantChance) {
                                                                            enchantLevel = i;
                                                                            continue;
                                                                        }
                                                                        fullEnchants = false;
                                                                    }
                                                                    if (enchantLevel <= 0) continue;
                                                                    newEnchantMap.put(enchant, enchantLevel);
                                                                }
                                                                if (newEnchantMap.size() > 0) {
                                                                    EnchantmentHelper.func_82782_a(newEnchantMap, (ItemStack)salvagedBook);
                                                                    Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)salvagedBook);
                                                                    if (fullEnchants) {
                                                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedAllEnchants").func_240703_c_(XP.textStyle.get("green")), false);
                                                                    } else {
                                                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedSomeEnchants").func_240703_c_(XP.textStyle.get("yellow")), false);
                                                                    }
                                                                }
                                                            }
                                                            player.func_184592_cb().func_190918_g(1);
                                                            player.func_213334_d(Hand.OFF_HAND);
                                                        } else {
                                                            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.survivalOnlyWarning").func_240703_c_(XP.textStyle.get("red")), true);
                                                        }
                                                    } else {
                                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.offhandToDiss"), false);
                                                        XP.sendMessage("_________________________________", false, player);
                                                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.durabilityInfo", item.func_77658_a(), "" + DP.dp(displayDurabilityPercent), false, 0), (ServerPlayerEntity)player);
                                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.materialSaveChanceInfo", new Object[]{DP.dp(chance), potentialReturnAmount}), false);
                                                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.repairInfo", "" + DP.dp(enchantChance), "" + itemStack.func_82838_A(), false, 0), (ServerPlayerEntity)player);
                                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.enchantmentBypassInfo", new Object[]{"" + maxPlayerBypass}), false);
                                                    }
                                                } else {
                                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.cannotSalvageLackLevelLonger", new Object[]{reqLevel, new TranslationTextComponent(item.func_77658_a())}).func_240703_c_(XP.textStyle.get("red")), true);
                                                }
                                            } else {
                                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.invalidSalvageItem", new Object[]{theMap.get("salvageItem")}).func_240703_c_(XP.textStyle.get("red")), true);
                                            }
                                        } else {
                                            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.tooFarAwayToSalvage").func_240703_c_(XP.textStyle.get("red")), true);
                                        }
                                    } else {
                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.cannotSalvage", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_240703_c_(XP.textStyle.get("red")), true);
                                    }
                                }
                            }
                            if (block.equals(diamondBlock) && event.getHand() == Hand.MAIN_HAND && !player.field_70170_p.func_201670_d()) {
                                double maxEndurance;
                                int agilityLevel = XP.getLevel(Skill.AGILITY, player);
                                int enduranceLevel = XP.getLevel(Skill.ENDURANCE, player);
                                int combatLevel = XP.getLevel(Skill.COMBAT, player);
                                int swimLevel = XP.getLevel(Skill.SMITHING, player);
                                int nightvisionUnlockLevel = (int)Math.floor(Config.getConfig("nightvisionUnlockLevel"));
                                double maxFallSaveChance = Config.getConfig("maxFallSaveChance");
                                double saveChancePerLevel = Config.getConfig("saveChancePerLevel") / 100.0;
                                double levelsPerDamage = Config.getConfig("levelsPerDamage");
                                double endurancePerLevel = Config.getConfig("endurancePerLevel");
                                double endurePercent = (double)enduranceLevel * endurancePerLevel;
                                if (endurePercent > (maxEndurance = Config.getConfig("maxEndurance"))) {
                                    endurePercent = maxEndurance;
                                }
                                double reach = AttributeHandler.getReach(player);
                                double agilityChance = (double)agilityLevel * saveChancePerLevel;
                                if (agilityChance > maxFallSaveChance) {
                                    agilityChance = maxFallSaveChance;
                                }
                                double extraDamage = Math.floor((double)combatLevel / levelsPerDamage);
                                double speedBonus = AttributeHandler.getSpeedBoost(player) / AttributeHandler.getBaseSpeed(player) * 100.0;
                                System.out.println(AttributeHandler.getBaseSpeed(player));
                                System.out.println(AttributeHandler.getSpeedBoost(player));
                                XP.sendMessage("_________________________________", false, player);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.buildingInfo", new Object[]{DP.dp(reach)}), false);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.fallInfo", new Object[]{DP.dp(agilityChance)}), false);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.enduranceInfo", new Object[]{DP.dp(endurePercent)}), false);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.combatInfo", new Object[]{DP.dp(extraDamage)}), false);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.sprintInfo", new Object[]{DP.dp(speedBonus)}), false);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.enchantmentBypassInfo", new Object[]{maxPlayerBypass}), false);
                                if (swimLevel >= nightvisionUnlockLevel) {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.underwaterNightVisionUnLocked", new Object[]{nightvisionUnlockLevel}), false);
                                } else {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.underwaterNightVisionLocked", new Object[]{nightvisionUnlockLevel}), false);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LogHandler.LOGGER.error((Object)e);
        }
    }
}

