/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.curios.Curios;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.ScreenshotHandler;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.TickEvent;

public class PlayerTickHandler {
    private static Map<UUID, Long> lastAward = new HashMap<UUID, Long>();
    private static Map<UUID, Long> lastVeinAward = new HashMap<UUID, Long>();
    public static boolean syncPrefs = false;

    public static void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (XP.isPlayerSurvival(player) && player.func_70089_S()) {
            UUID playerUUID = player.func_110124_au();
            if (player.func_70051_ag()) {
                AttributeHandler.updateSpeed(player);
            } else {
                AttributeHandler.resetSpeed(player);
            }
            if (!lastAward.containsKey(playerUUID)) {
                lastAward.put(playerUUID, System.nanoTime());
            }
            if (!lastVeinAward.containsKey(playerUUID)) {
                lastVeinAward.put(playerUUID, System.nanoTime());
            }
            double gap = (double)(System.nanoTime() - lastAward.get(playerUUID)) / 1.0E9;
            double veinGap = (double)(System.nanoTime() - lastVeinAward.get(playerUUID)) / 1.0E9;
            if (gap > 0.5) {
                int swimLevel = XP.getLevel(Skill.SWIMMING, player);
                int flyLevel = XP.getLevel(Skill.FLYING, player);
                int agilityLevel = XP.getLevel(Skill.AGILITY, player);
                int nightvisionUnlockLevel = Config.forgeConfig.nightvisionUnlockLevel.get();
                float swimAmp = EnchantmentHelper.func_185294_d((LivingEntity)player);
                float speedAmp = 0.0f;
                PlayerInventory inv = player.field_71071_by;
                XP.checkBiomeLevelReq(player);
                if (!player.field_70170_p.func_201670_d()) {
                    if (Curios.isLoaded()) {
                        Curios.getCurios(player).forEach(value -> {
                            for (int i = 0; i < value.getSlots(); ++i) {
                                XP.applyWornPenalty(player, value.getStacks().getStackInSlot(i));
                            }
                        });
                    }
                    if (!inv.func_70301_a(39).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(39));
                    }
                    if (!inv.func_70301_a(38).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(38));
                    }
                    if (!inv.func_70301_a(37).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(37));
                    }
                    if (!inv.func_70301_a(36).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(36));
                    }
                }
                if (player.func_70644_a(Effects.field_76424_c)) {
                    speedAmp = player.func_70660_b(Effects.field_76424_c).func_76458_c() + 1;
                }
                double swimAward = (3.0 + (double)swimLevel / 10.0) * gap * (1.0 + (double)swimAmp / 4.0);
                double flyAward = (1.0 + (double)flyLevel / 30.77) * gap;
                double runAward = (1.0 + (double)agilityLevel / 30.77) * gap * (1.0 + (double)speedAmp / 4.0);
                lastAward.replace(playerUUID, System.nanoTime());
                Block waterBlock = Blocks.field_150355_j;
                Block tallSeagrassBlock = Blocks.field_203199_aR;
                Block kelpBlock = Blocks.field_203215_jy;
                BlockPos playerPos = XP.vecToBlock(player.func_213303_ch());
                boolean waterBelow = true;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        Block currBlock = player.func_130014_f_().func_180495_p(playerPos.func_177977_b().func_177965_g(i).func_177964_d(j)).func_177230_c();
                        if (currBlock.equals(waterBlock) || currBlock.equals(tallSeagrassBlock) || currBlock.equals(kelpBlock)) continue;
                        waterBelow = false;
                    }
                }
                boolean waterAbove = player.func_130014_f_().func_180495_p(playerPos.func_177984_a()).func_177230_c().equals(waterBlock);
                if (swimLevel >= nightvisionUnlockLevel && player.func_70090_H() && waterAbove) {
                    player.func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 0, false, false));
                }
                if (!player.field_70170_p.func_201670_d() && player.func_70051_ag()) {
                    if (player.func_70090_H() && (waterAbove || waterBelow)) {
                        XP.awardXp(player, Skill.SWIMMING, "swimming fast", swimAward * 1.25, true, false);
                    } else {
                        XP.awardXp(player, Skill.AGILITY, "running", runAward, true, false);
                    }
                }
                if (player.func_70090_H() && (waterAbove || waterBelow)) {
                    if (!player.func_70051_ag()) {
                        XP.awardXp(player, Skill.SWIMMING, "swimming", swimAward, true, false);
                    }
                } else if (player.func_184613_cA()) {
                    XP.awardXp(player, Skill.FLYING, "flying", flyAward, true, false);
                }
                if (player.func_184187_bx() instanceof BoatEntity && player.func_70090_H()) {
                    XP.awardXp(player, Skill.SWIMMING, "swimming in a boat", swimAward / 5.0, true, false);
                }
            }
            if (veinGap > 0.25 && !player.field_70170_p.func_201670_d()) {
                WorldTickHandler.updateVein(player, veinGap);
                lastVeinAward.put(playerUUID, System.nanoTime());
            }
        }
        if (player.field_70170_p.func_201670_d()) {
            if (XPOverlayGUI.screenshots.size() > 0) {
                for (String key : new HashSet<String>(XPOverlayGUI.screenshots)) {
                    ScreenshotHandler.takeScreenshot(key, "levelup");
                    XPOverlayGUI.screenshots.remove(key);
                    XPOverlayGUI.guiOn = XPOverlayGUI.guiWasOn;
                }
            }
            if (syncPrefs) {
                ClientHandler.syncPrefsToServer();
                syncPrefs = false;
            }
        }
    }
}

