/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class TooltipHandler {
    public static boolean tooltipOn = true;
    private static String lastKey = "";
    private static int salvageArrayPos = 0;
    private static int salvageArrayLength;
    private static long lastTime;
    private static Object[] salvageArray;

    public static void handleTooltip(ItemTooltipEvent event) {
        if (!tooltipOn) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            int level;
            double dValue;
            ItemStack itemStack = event.getItemStack();
            Item item = itemStack.func_77973_b();
            List tooltip = event.getToolTip();
            if (item.getRegistryName() == null) {
                return;
            }
            String regKey = item.getRegistryName().toString();
            Material material = null;
            Map<String, Object> craftReq = JsonConfig.data.get((Object)JType.REQ_CRAFT).get(regKey);
            Map<String, Object> wearReq = JsonConfig.data.get((Object)JType.REQ_WEAR).get(regKey);
            Map<String, Object> toolReq = JsonConfig.data.get((Object)JType.REQ_TOOL).get(regKey);
            Map<String, Object> weaponReq = JsonConfig.data.get((Object)JType.REQ_WEAPON).get(regKey);
            Map<String, Object> useReq = JsonConfig.data.get((Object)JType.REQ_USE).get(regKey);
            Map<String, Object> placeReq = JsonConfig.data.get((Object)JType.REQ_PLACE).get(regKey);
            Map<String, Object> breakReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(regKey);
            Map<String, Object> xpValueGeneral = JsonConfig.data.get((Object)JType.XP_VALUE_GENERAL).get(regKey);
            Map<String, Object> xpValueBreaking = JsonConfig.data.get((Object)JType.XP_VALUE_BREAK).get(regKey);
            Map<String, Object> xpValueCrafting = JsonConfig.data.get((Object)JType.XP_VALUE_CRAFT).get(regKey);
            Map<String, Object> salvageInfo = JsonConfig.data.get((Object)JType.SALVAGE_TO).get(regKey);
            Map<String, Object> salvagesFrom = JsonConfig.data.get((Object)JType.SALVAGE_FROM).get(regKey);
            Map<String, Object> heldItemXpBoost = JsonConfig.data.get((Object)JType.XP_BONUS_HELD).get(regKey);
            Map<String, Object> wornItemXpBoost = JsonConfig.data.get((Object)JType.XP_BONUS_WORN).get(regKey);
            if (xpValueGeneral != null && xpValueGeneral.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueBreak"));
                for (String key : xpValueGeneral.keySet()) {
                    if (!(xpValueGeneral.get(key) instanceof Double)) continue;
                    dValue = (Double)xpValueGeneral.get(key);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key).getString(), DP.dp(dValue)}));
                }
            }
            if (xpValueBreaking != null && xpValueBreaking.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueBreak"));
                for (String key : xpValueBreaking.keySet()) {
                    if (!(xpValueBreaking.get(key) instanceof Double)) continue;
                    dValue = (Double)xpValueBreaking.get(key);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key).getString(), DP.dp(dValue)}));
                }
            }
            if (xpValueCrafting != null && xpValueCrafting.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueCraft"));
                for (String key : xpValueCrafting.keySet()) {
                    if (!(xpValueCrafting.get(key) instanceof Double)) continue;
                    dValue = (Double)xpValueCrafting.get(key);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key).getString(), DP.dp(dValue)}));
                }
            }
            if (item instanceof BlockItem) {
                material = ((BlockItem)item).func_179223_d().func_176223_P().func_185904_a();
                float hardness = ((BlockItem)item).func_179223_d().func_176223_P().func_185887_b(null, null);
                if (hardness > 0.0f) {
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo.hardness", new Object[]{DP.dp(Float.valueOf(hardness))}).getString()}));
                }
            }
            if (craftReq != null && craftReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.toCraft", JType.REQ_CRAFT, craftReq, event);
            }
            if (wearReq != null && wearReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.toWear", JType.REQ_WEAR, wearReq, event);
            }
            if (wornItemXpBoost != null && wornItemXpBoost.size() > 0) {
                TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostWorn", wornItemXpBoost, event);
            }
            if (toolReq != null && toolReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.tool", JType.REQ_TOOL, toolReq, event);
            }
            if (weaponReq != null && weaponReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.weapon", JType.REQ_WEAPON, weaponReq, event);
            }
            if (heldItemXpBoost != null && heldItemXpBoost.size() > 0) {
                TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostHeld", heldItemXpBoost, event);
            }
            if (useReq != null && useReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.use", JType.REQ_USE, useReq, event);
            }
            if (placeReq != null && placeReq.size() > 0) {
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                    TooltipHandler.addTooltipTextSkill("pmmo.plant", JType.REQ_PLACE, placeReq, event);
                } else {
                    TooltipHandler.addTooltipTextSkill("pmmo.place", JType.REQ_PLACE, placeReq, event);
                }
            }
            if (breakReq != null && breakReq.size() > 0) {
                if (XP.correctHarvestTool(material).equals("axe")) {
                    TooltipHandler.addTooltipTextSkill("pmmo.chop", JType.REQ_BREAK, breakReq, event);
                } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                    TooltipHandler.addTooltipTextSkill("pmmo.harvest", JType.REQ_BREAK, breakReq, event);
                } else {
                    TooltipHandler.addTooltipTextSkill("pmmo.break", JType.REQ_BREAK, breakReq, event);
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_ORE).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).containsKey("extraChance")) {
                if (XP.getExtraChance(player, item.getRegistryName(), JType.INFO_ORE) > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{DP.dp(XP.getExtraChance(player, item.getRegistryName(), JType.INFO_ORE) / 100.0)}).func_240703_c_(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{0}).func_240703_c_(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_LOG).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).containsKey("extraChance")) {
                if (XP.getExtraChance(player, item.getRegistryName(), JType.INFO_LOG) > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{DP.dp(XP.getExtraChance(player, item.getRegistryName(), JType.INFO_LOG) / 100.0)}).func_240703_c_(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{0}).func_240703_c_(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).containsKey("extraChance")) {
                if (XP.getExtraChance(player, item.getRegistryName(), JType.INFO_PLANT) > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{DP.dp(XP.getExtraChance(player, item.getRegistryName(), JType.INFO_PLANT) / 100.0)}).func_240703_c_(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{0}).func_240703_c_(XP.textStyle.get("red")));
                }
            }
            if (salvageInfo != null && !XP.getItem((String)salvageInfo.get("salvageItem")).equals(Items.field_190931_a)) {
                double maxSalvageMaterialChance;
                level = XP.getLevel(Skill.SMITHING, player);
                int reqLevel = (int)Math.floor((Double)salvageInfo.get("levelReq"));
                int finalLevel = level - reqLevel;
                double baseChance = (Double)salvageInfo.get("baseChance");
                double xpPerItem = (Double)salvageInfo.get("xpPerItem");
                double chancePerLevel = (Double)salvageInfo.get("chancePerLevel");
                double chance = baseChance + chancePerLevel * (double)finalLevel;
                if (chance > (maxSalvageMaterialChance = ((Double)salvageInfo.get("maxChance")).doubleValue())) {
                    chance = maxSalvageMaterialChance;
                }
                int salvageMax = (int)Math.floor((Double)salvageInfo.get("salvageMax"));
                double durabilityPercent = 1.0 - (double)itemStack.func_77952_i() / (double)itemStack.func_77958_k();
                if (Double.isNaN(durabilityPercent)) {
                    durabilityPercent = 1.0;
                }
                int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                Item salvageItem = XP.getItem((String)salvageInfo.get("salvageItem"));
                if (finalLevel < 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.cannotSalvageLackLevel", new Object[]{reqLevel}).func_240703_c_(XP.textStyle.get("red")));
                } else {
                    if (potentialReturnAmount > 0) {
                        tooltip.add(new TranslationTextComponent("pmmo.salvagesInto", new Object[]{potentialReturnAmount, new TranslationTextComponent(salvageItem.func_77658_a())}).func_240703_c_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.salvagesInto", new Object[]{potentialReturnAmount, new TranslationTextComponent(salvageItem.func_77658_a())}).func_240703_c_(XP.textStyle.get("red")));
                    }
                    if (chance > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.xpEachChanceEach", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_240703_c_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.xpEachChanceEach", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_240703_c_(XP.textStyle.get("red")));
                    }
                }
            }
            if (salvagesFrom != null) {
                tooltip.add(new TranslationTextComponent("pmmo.salvagesFrom").func_240703_c_(XP.textStyle.get("green")));
                level = XP.getLevel(Skill.SMITHING, player);
                if (!lastKey.equals(regKey)) {
                    salvageArray = salvagesFrom.keySet().toArray();
                    salvageArrayLength = salvageArray.length;
                }
                if (System.nanoTime() - lastTime > 750000000L) {
                    lastTime = System.nanoTime();
                    ++salvageArrayPos;
                }
                if (salvageArrayPos > salvageArrayLength - 1) {
                    salvageArrayPos = 0;
                }
                String key = (String)salvageArray[salvageArrayPos];
                String displayName = new TranslationTextComponent(XP.getItem((String)salvageArray[salvageArrayPos]).func_77658_a()).getString();
                int value = (int)Math.floor((Double)salvagesFrom.get(key));
                salvageInfo = JsonConfig.data.get((Object)JType.SALVAGE_TO).get(key);
                if (salvageInfo != null && (Double)salvageInfo.get("levelReq") <= (double)level) {
                    tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + value, displayName}).func_240703_c_(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + value, displayName}).func_240703_c_(XP.textStyle.get("red")));
                }
            }
        }
    }

    private static void addTooltipTextSkill(String tKey, JType jType, Map<String, Object> theMap, ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        List tooltip = event.getToolTip();
        Item item = event.getItemStack().func_77973_b();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey).func_240703_c_(XP.textStyle.get(XP.checkReq(player, item.getRegistryName(), jType) ? "green" : "red")));
            for (String key : theMap.keySet()) {
                double level = XP.getLevelDecimal(Skill.getSkill(key), player);
                if (!(theMap.get(key) instanceof Double)) continue;
                double value = (Double)theMap.get(key);
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key).getString(), DP.dpSoft(value)}).func_240703_c_(XP.textStyle.get(level < value ? "red" : "green")));
            }
        }
    }

    private static void addTooltipTextSkillPercentage(String tKey, Map<String, Object> theMap, ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey).func_240703_c_(XP.textStyle.get("green")));
            for (String key : theMap.keySet()) {
                if (!(theMap.get(key) instanceof Double)) continue;
                double value = (Double)theMap.get(key);
                if (value < 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" " + DP.dp(value), new TranslationTextComponent("pmmo." + key).getString()}).func_240703_c_(XP.textStyle.get("red")));
                    continue;
                }
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" +" + DP.dp(value), new TranslationTextComponent("pmmo." + key).getString()}).func_240703_c_(XP.getSkillStyle(Skill.getSkill(key))));
            }
        }
    }

    static {
        lastTime = System.nanoTime();
    }
}

