/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.gui.ListScrollPanel;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ListScreen
extends Screen {
    private static double passiveMobHunterXp = Config.forgeConfig.passiveMobHunterXp.get();
    private static double aggresiveMobSlayerXp = Config.forgeConfig.aggresiveMobSlayerXp.get();
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private static final double defaultBreedingXp = Config.forgeConfig.defaultBreedingXp.get();
    private static final double defaultTamingXp = Config.forgeConfig.defaultTamingXp.get();
    private static final double defaultCraftingXp = Config.forgeConfig.defaultCraftingXp.get();
    private static final Style greenColor = XP.textStyle.get("green");
    private static Button exitButton;
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private int boxWidth = 256;
    private int boxHeight = 256;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private int buttonY;
    private int accumulativeHeight;
    private int buttonsSize;
    private int buttonsLoaded;
    private int futureHeight;
    private int minCount;
    private int maxCount;
    private ListScrollPanel scrollPanel;
    private final PlayerEntity player;
    private final JType jType;
    private final double baseXp = Config.getConfig("baseXp");
    private ArrayList<ListButton> listButtons = new ArrayList();
    private UUID uuid;
    private ITextComponent title;

    public ListScreen(UUID uuid, ITextComponent titleIn, JType jType, PlayerEntity player) {
        super(titleIn);
        this.title = titleIn;
        this.player = player;
        this.jType = jType;
        this.uuid = uuid;
    }

    protected void func_231160_c_() {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add("helmet");
        keyWords.add("chestplate");
        keyWords.add("leggings");
        keyWords.add("boots");
        keyWords.add("pickaxe");
        keyWords.add("axe");
        keyWords.add("shovel");
        keyWords.add("hoe");
        keyWords.add("sword");
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", "", button -> {
            switch (this.jType) {
                case STATS: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.potato", new Object[0])));
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.skills", new Object[0])));
                }
            }
        });
        Map<String, Map<String, Object>> reqMap = JsonConfig.data.get((Object)this.jType);
        ArrayList<ListButton> tempList = new ArrayList<ListButton>();
        this.listButtons = new ArrayList();
        switch (this.jType) {
            case REQ_BIOME: {
                Map<String, Map<String, Object>> bonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME);
                Map<String, Map<String, Object>> scaleMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER);
                ArrayList<String> biomesToAdd = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (bonusMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : bonusMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (scaleMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : scaleMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                biomesToAdd.sort(Comparator.comparingInt(b -> ListScreen.getReqCount(b, JType.REQ_BIOME)));
                for (String string : biomesToAdd) {
                    if (ForgeRegistries.BIOMES.getValue(XP.getResLoc(string)) == null) continue;
                    tempList.add(new ListButton(0, 0, 3, 8, string, this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                break;
            }
            case DIMENSION: {
                Map<String, Map<String, Object>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                if (veinBlacklist == null) break;
                if (veinBlacklist.containsKey("all_dimensions")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "all_dimensions", this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                if (veinBlacklist.containsKey("minecraft:overworld")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:overworld", this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                if (veinBlacklist.containsKey("minecraft:the_nether")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_nether", this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                if (!veinBlacklist.containsKey("minecraft:the_end")) break;
                tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_end", this.jType, "", button -> ((ListButton)button).clickAction()));
                break;
            }
            case REQ_KILL: {
                Iterator<Map.Entry<String, Map<String, Object>>> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL);
                Map<String, Map<String, Object>> rareDropMap = JsonConfig.data.get((Object)JType.MOB_RARE_DROP);
                ArrayList<String> mobsToAdd = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                        if (mobsToAdd.contains(entry.getKey())) continue;
                        mobsToAdd.add(entry.getKey());
                    }
                }
                if (killXpMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : killXpMap.entrySet()) {
                        if (mobsToAdd.contains(entry.getKey())) continue;
                        mobsToAdd.add(entry.getKey());
                    }
                }
                if (rareDropMap != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : rareDropMap.entrySet()) {
                        if (mobsToAdd.contains(entry.getKey())) continue;
                        mobsToAdd.add(entry.getKey());
                    }
                }
                for (String string : mobsToAdd) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(string))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, string, this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc((String)entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, (String)entry.getKey(), this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                break;
            }
            case FISH_ENCHANT_POOL: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(XP.getResLoc((String)entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 25, (String)entry.getKey(), this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                break;
            }
            case STATS: {
                Map.Entry<String, Map<String, Object>> entry;
                Set<String> skills = XP.skills.containsKey(this.uuid) ? XP.skills.get(this.uuid).keySet() : new HashSet();
                entry = skills.iterator();
                while (entry.hasNext()) {
                    String skill = (String)entry.next();
                    this.listButtons.add(new ListButton(0, 0, 3, 6, skill, this.jType, "", button -> ((ListButton)button).clickAction()));
                }
                break;
            }
            default: {
                if (reqMap == null) {
                    return;
                }
                for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                    if (XP.getItem((String)entry.getKey()) == Items.field_190931_a) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, (String)entry.getKey(), this.jType, "", button -> ((ListButton)button).clickAction()));
                }
            }
        }
        for (String keyWord : keyWords) {
            for (ListButton button2 : tempList) {
                if (!button2.regKey.contains(keyWord) || this.listButtons.contains((Object)button2)) continue;
                this.listButtons.add(button2);
            }
        }
        for (ListButton button3 : tempList) {
            if (this.listButtons.contains((Object)button3)) continue;
            this.listButtons.add(button3);
        }
        for (ListButton button2 : this.listButtons) {
            ArrayList<Object> skillText = new ArrayList<Object>();
            ArrayList<Object> scaleText = new ArrayList<Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            switch (this.jType) {
                case REQ_BIOME: {
                    if (reqMap.containsKey(button2.regKey)) {
                        ListScreen.addLevelsToButton(button2, reqMap.get(button2.regKey), this.player, false);
                    }
                    Map<String, Object> biomeBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(button2.regKey);
                    Map<String, Object> biomeMobMultiplierMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(button2.regKey);
                    Map<String, Object> biomeEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT).get(button2.regKey);
                    if (biomeBonusMap != null) {
                        for (Map.Entry<String, Object> entry : biomeBonusMap.entrySet()) {
                            if ((Double)entry.getValue() > 0.0) {
                                skillText.add(new StringTextComponent(ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").func_240703_c_(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).getString()));
                            }
                            if (!((Double)entry.getValue() < 0.0)) continue;
                            skillText.add(new StringTextComponent(ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").func_240703_c_(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).getString()));
                        }
                    }
                    if (biomeMobMultiplierMap != null) {
                        for (Map.Entry<String, Object> entry : biomeMobMultiplierMap.entrySet()) {
                            Style styleColor = Style.field_240709_b_;
                            if ((Double)entry.getValue() > 1.0) {
                                styleColor = XP.textStyle.get("red");
                            } else if ((Double)entry.getValue() < 1.0) {
                                styleColor = XP.textStyle.get("green");
                            }
                            switch (entry.getKey()) {
                                case "damageBonus": {
                                    scaleText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleDamage", DP.dp((Double)entry.getValue() * 100.0)).func_240703_c_(styleColor).getString()));
                                    break;
                                }
                                case "hpBonus": {
                                    scaleText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleHp", DP.dp((Double)entry.getValue() * 100.0)).func_240703_c_(styleColor).getString()));
                                    break;
                                }
                                case "speedBonus": {
                                    scaleText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleSpeed", DP.dp((Double)entry.getValue() * 100.0)).func_240703_c_(styleColor).getString()));
                                }
                            }
                        }
                    }
                    if (biomeEffectsMap == null) break;
                    for (Map.Entry<String, Object> entry : biomeEffectsMap.entrySet()) {
                        Effect effect;
                        if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                        arrayList.add(new StringTextComponent(ListScreen.getTransComp(effect.func_199286_c().getString() + (int)((Double)entry.getValue() + 1.0), new Object[0]).func_240703_c_(XP.textStyle.get("red")).getString()));
                    }
                    break;
                }
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    Map<String, Object> breakMap = JsonConfig.data.get((Object)JType.REQ_BREAK).get(button2.regKey);
                    Map<String, Double> infoMap = XP.getReqMap(button2.regKey, this.jType);
                    ArrayList<IFormattableTextComponent> infoText = new ArrayList<IFormattableTextComponent>();
                    String transKey = "pmmo." + this.jType.toString().replace("info_", "") + "ExtraDrop";
                    double extraDroppedPerLevel = infoMap.get("extraChance") / 100.0;
                    double extraDropped = XP.getExtraChance(this.player, button2.regKey, this.jType) / 100.0;
                    if (extraDroppedPerLevel <= 0.0) {
                        infoText.add(ListScreen.getTransComp("pmmo.extraDropPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_240703_c_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp("pmmo.extraDropPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_240703_c_(XP.textStyle.get("green")));
                    }
                    if (extraDropped <= 0.0) {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_240703_c_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_240703_c_(XP.textStyle.get("green")));
                    }
                    if (infoText.size() > 0) {
                        button2.text.addAll(infoText);
                    }
                    if (breakMap == null) break;
                    if (XP.checkReq(this.player, button2.regKey, JType.REQ_BREAK)) {
                        button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.break", new Object[0]).func_240703_c_(XP.textStyle.get("green")));
                    } else {
                        button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.break", new Object[0]).func_240703_c_(XP.textStyle.get("red")));
                    }
                    ListScreen.addLevelsToButton(button2, breakMap, this.player, false);
                    break;
                }
                case XP_BONUS_WORN: {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    ListScreen.addPercentageToButton(button2, reqMap.get(button2.regKey), XP.checkReq(this.player, button2.regKey, JType.REQ_WEAR));
                    break;
                }
                case XP_BONUS_HELD: {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    ListScreen.addPercentageToButton(button2, reqMap.get(button2.regKey), true);
                    break;
                }
                case XP_VALUE_BREED: 
                case XP_VALUE_TAME: {
                    ListScreen.addXpToButton(button2, reqMap.get(button2.regKey));
                    break;
                }
                case XP_VALUE_BREAK: {
                    ListScreen.addXpToButton(button2, reqMap.get(button2.regKey), JType.REQ_BREAK, this.player);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    ListScreen.addXpToButton(button2, reqMap.get(button2.regKey), JType.REQ_CRAFT, this.player);
                    break;
                }
                case FISH_ENCHANT_POOL: {
                    double curChance;
                    Map<String, Object> enchantMap = reqMap.get(button2.regKey);
                    double fishLevel = Skill.FISHING.getLevelDecimal(this.player);
                    double levelReq = (Double)enchantMap.get("levelReq");
                    double chancePerLevel = (Double)enchantMap.get("chancePerLevel");
                    double maxChance = (Double)enchantMap.get("maxChance");
                    double maxLevel = (int)((Double)enchantMap.get("maxLevel")).doubleValue();
                    double levelsPerTier = (Double)enchantMap.get("levelPerLevel");
                    double maxLevelAvailable = levelsPerTier == 0.0 ? maxLevel : Math.floor((fishLevel - levelReq) / levelsPerTier);
                    if (maxLevelAvailable < 0.0) {
                        maxLevelAvailable = 0.0;
                    }
                    if (maxLevelAvailable > maxLevel) {
                        maxLevelAvailable = maxLevel;
                    }
                    if ((curChance = (fishLevel - levelReq) * chancePerLevel) > maxChance) {
                        curChance = maxChance;
                    }
                    if (curChance < 0.0) {
                        curChance = 0.0;
                    }
                    button2.unlocked = maxLevelAvailable > 0.0;
                    Style color = XP.textStyle.get(button2.unlocked ? "green" : "red");
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpSoft(curChance)).func_240703_c_(color).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(levelReq)).func_240703_c_(color).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevelAvailable).func_240703_c_(color).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).getString()));
                    if (maxLevel > 1.0) {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelsPerTier", DP.dpSoft(levelsPerTier)).getString()));
                    }
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevel).getString()));
                    break;
                }
                case REQ_KILL: {
                    Map<String, Object> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL).get(button2.regKey);
                    Map<String, Object> rareDropMap = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(button2.regKey);
                    button2.unlocked = XP.checkReq(this.player, button2.regKey, this.jType);
                    Style color = XP.textStyle.get(button2.unlocked ? "green" : "red");
                    if (reqMap.containsKey(button2.regKey)) {
                        button2.text.add((ITextComponent)new StringTextComponent(""));
                        button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.toHarm", new Object[0]).func_240703_c_(color));
                        ListScreen.addLevelsToButton(button2, reqMap.get(button2.regKey), this.player, false);
                    }
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpValue", new Object[0]).func_240703_c_(color));
                    if (killXpMap != null) {
                        ListScreen.addXpToButton(button2, killXpMap, this.jType, this.player);
                    } else if (button2.entity instanceof AnimalEntity) {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(passiveMobHunterXp)).func_240703_c_(color).getString()));
                    } else if (button2.entity instanceof MobEntity) {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(aggresiveMobSlayerXp)).func_240703_c_(color).getString()));
                    }
                    if (rareDropMap == null) break;
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.rareDrops", new Object[0]).func_240703_c_(color));
                    for (Map.Entry<String, Object> entry : rareDropMap.entrySet()) {
                        button2.text.add((ITextComponent)new StringTextComponent(new StringTextComponent(ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]) + ": " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft((double)((Double)entry.getValue())))).func_240703_c_(color).getString()));
                    }
                    break;
                }
                case DIMENSION: {
                    Map<String, Map<String, Object>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                    if (veinBlacklist == null) break;
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.veinBlacklist", new Object[0]).func_240703_c_(XP.textStyle.get("red")));
                    for (Map.Entry<String, Object> entry : veinBlacklist.get(button2.regKey).entrySet()) {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]).func_240703_c_(XP.textStyle.get("red")).getString()));
                    }
                    break;
                }
                case FISH_POOL: {
                    Map<String, Object> fishPoolMap = reqMap.get(button2.regKey);
                    double level = Skill.FISHING.getLevelDecimal(this.player);
                    double weight = XP.getWeight((int)level, fishPoolMap);
                    button2.unlocked = weight > 0.0;
                    Style color = XP.textStyle.get(button2.unlocked ? "green" : "red");
                    this.minCount = (int)((Double)fishPoolMap.get("minCount")).doubleValue();
                    this.maxCount = (int)((Double)fishPoolMap.get("maxCount")).doubleValue();
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentWeight", weight).func_240703_c_(color).getString()));
                    if (this.minCount == this.maxCount) {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmount", this.minCount).func_240703_c_(color).getString()));
                    } else {
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmountRange", this.minCount, this.maxCount).func_240703_c_(color).getString()));
                    }
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpEach", DP.dpSoft((double)((Double)fishPoolMap.get("xp")))).func_240703_c_(color).getString()));
                    if (button2.itemStack.func_77956_u()) {
                        if ((Double)fishPoolMap.get("enchantLevelReq") <= level && button2.unlocked) {
                            button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft((double)((Double)fishPoolMap.get("enchantLevelReq")))).func_240703_c_(XP.textStyle.get("green")).getString()));
                        } else {
                            button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft((double)((Double)fishPoolMap.get("enchantLevelReq")))).func_240703_c_(XP.textStyle.get("red")).getString()));
                        }
                    }
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startWeight", DP.dpSoft((double)((Double)fishPoolMap.get("startWeight")))).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft((double)((Double)fishPoolMap.get("startLevel")))).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.endWeight", DP.dpSoft((double)((Double)fishPoolMap.get("endWeight")))).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.endLevel", DP.dpSoft((double)((Double)fishPoolMap.get("endLevel")))).getString()));
                    break;
                }
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo." + this.jType.toString().replace("req_", ""), new Object[0]).func_240703_c_(XP.textStyle.get(XP.checkReq(this.player, button2.regKey, this.jType) ? "green" : "red")));
                    ListScreen.addLevelsToButton(button2, reqMap.get(button2.regKey), this.player, false);
                    break;
                }
                case SALVAGE_FROM: {
                    double levelReq;
                    Map<String, Map<String, Object>> salvagesToMap = JsonConfig.data.get((Object)JType.SALVAGE_TO);
                    HashMap<String, Double> levelReqs = new HashMap<String, Double>();
                    ArrayList<String> sortedItems = new ArrayList<String>();
                    if (reqMap == null || salvagesToMap == null) {
                        return;
                    }
                    double smithLevel = Skill.SMITHING.getLevelDecimal(this.player);
                    boolean anyPassed = false;
                    for (Map.Entry<String, Object> entry : reqMap.get(button2.regKey).entrySet()) {
                        levelReq = (Double)salvagesToMap.get(entry.getKey()).get("levelReq");
                        levelReqs.put(entry.getKey(), levelReq);
                        sortedItems.add(entry.getKey());
                    }
                    sortedItems.sort(Comparator.comparingDouble(a -> (Double)((Map)reqMap.get(button.regKey)).get(a)));
                    sortedItems.sort(Comparator.comparingDouble(levelReqs::get));
                    for (String key : sortedItems) {
                        boolean passed;
                        double maxChance;
                        levelReq = (Double)levelReqs.get(key);
                        String itemName = ListScreen.getTransComp(XP.getItem(key).func_77658_a(), new Object[0]).getString();
                        double chance = (smithLevel - levelReq) * (Double)salvagesToMap.get(key).get("chancePerLevel");
                        if (chance > (maxChance = ((Double)salvagesToMap.get(key).get("maxChance")).doubleValue())) {
                            chance = maxChance;
                        }
                        boolean bl = passed = levelReq <= smithLevel && chance > 0.0;
                        if (passed) {
                            anyPassed = true;
                            button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.valueValueChance", DP.dpSoft((double)((Double)reqMap.get(button2.regKey).get(key))), itemName, DP.dpSoft(chance)).func_240703_c_(XP.textStyle.get(chance > 0.0 ? "green" : "red")).getString()));
                            continue;
                        }
                        button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.salvagesFromLevelFromItem", DP.dpSoft((double)((Double)reqMap.get(button2.regKey).get(key))), DP.dpSoft(levelReq), itemName).func_240703_c_(XP.textStyle.get("red")).getString()));
                    }
                    button2.unlocked = anyPassed;
                    break;
                }
                case SALVAGE_TO: {
                    if (reqMap == null) {
                        return;
                    }
                    double smithLevel = Skill.SMITHING.getLevelDecimal(this.player);
                    String outputName = ListScreen.getTransComp(XP.getItem((String)reqMap.get(button2.regKey).get("salvageItem")).func_77658_a(), new Object[0]).getString();
                    double levelReq = (Double)reqMap.get(button2.regKey).get("levelReq");
                    double salvageMax = (Double)reqMap.get(button2.regKey).get("salvageMax");
                    double baseChance = (Double)reqMap.get(button2.regKey).get("baseChance");
                    double chancePerLevel = (Double)reqMap.get(button2.regKey).get("chancePerLevel");
                    double maxChance = (Double)reqMap.get(button2.regKey).get("maxChance");
                    double xpPerItem = (Double)reqMap.get(button2.regKey).get("xpPerItem");
                    double chance = 0.0;
                    boolean bl = button2.unlocked = levelReq <= smithLevel;
                    if (button2.unlocked) {
                        chance = baseChance + (smithLevel - levelReq) * chancePerLevel;
                    }
                    if (chance > maxChance) {
                        chance = maxChance;
                    }
                    Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.canBeSalvagedFromLevel", DP.dpSoft(levelReq)).func_240703_c_(color));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.valueValue", DP.dpSoft(salvageMax), outputName).func_240703_c_(color).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).func_240703_c_(color));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).func_240703_c_(color));
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.baseChance", DP.dpSoft(baseChance)).func_240703_c_(color));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).func_240703_c_(color));
                    button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.maxChancePerItem", DP.dpSoft(maxChance)).func_240703_c_(color));
                    break;
                }
                case STATS: {
                    Skill skill = Skill.getSkill(button2.regKey);
                    double curXp = XP.getXpOffline(skill, this.uuid);
                    double nextXp = XP.xpAtLevel(XP.levelAtXp(curXp) + 1);
                    button2.title = ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + button2.regKey, new Object[0]), DP.dpSoft(XP.levelAtXpDecimal(curXp))).func_240703_c_(XP.getSkillStyle(Skill.getSkill(button2.regKey))).getString();
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentXp", DP.dpSoft(curXp)).getString()));
                    if ((double)skill.getLevel(this.player) == Config.getConfig("maxLevel")) break;
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.nextLevelXp", DP.dpSoft(nextXp)).getString()));
                    button2.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.RemainderXp", DP.dpSoft(nextXp - curXp)).getString()));
                    break;
                }
            }
            if (skillText.size() > 0) {
                button2.text.add((ITextComponent)new StringTextComponent(""));
                skillText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpModifiers", new Object[0]));
                button2.text.addAll(skillText);
            }
            if (scaleText.size() > 0) {
                if (skillText.size() > 0) {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                }
                scaleText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.enemyScaling", new Object[0]));
                button2.text.addAll(scaleText);
            }
            if (arrayList.size() > 0) {
                if (skillText.size() > 0 || scaleText.size() > 0) {
                    button2.text.add((ITextComponent)new StringTextComponent(""));
                }
                arrayList.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                button2.text.add((ITextComponent)ListScreen.getTransComp("pmmo.biomeEffects", new Object[0]).func_240703_c_(XP.textStyle.get("red")));
                button2.text.addAll(arrayList);
            }
            switch (this.jType) {
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case XP_VALUE_BREAK: 
                case XP_VALUE_CRAFT: {
                    button2.unlocked = XP.checkReq(this.player, button2.regKey, JType.REQ_BREAK);
                    break;
                }
                case XP_BONUS_WORN: {
                    button2.unlocked = XP.checkReq(this.player, button2.regKey, JType.REQ_WEAR);
                    break;
                }
                case FISH_POOL: {
                    break;
                }
                case REQ_BIOME: 
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    button2.unlocked = XP.checkReq(this.player, button2.regKey, this.jType);
                    break;
                }
            }
        }
        switch (this.jType) {
            case INFO_ORE: 
            case INFO_LOG: 
            case INFO_PLANT: 
            case XP_VALUE_BREAK: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_BREAK)));
                break;
            }
            case REQ_WEAR: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_WEAR)));
                break;
            }
            case SALVAGE_TO: {
                this.listButtons.sort(Comparator.comparingDouble(b -> (Double)((Map)reqMap.get(b.regKey)).get("levelReq")));
                break;
            }
            case STATS: {
                this.listButtons.sort(Comparator.comparingDouble(b -> XP.getXpOffline(Skill.getSkill(((ListButton)((Object)((Object)((Object)b)))).regKey), this.uuid)).reversed());
                break;
            }
            default: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, this.jType)));
            }
        }
        switch (this.jType) {
            case XP_VALUE_BREED: {
                ListButton otherAnimalsBreedButton = new ListButton(0, 0, 3, 20, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickAction());
                otherAnimalsBreedButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.farming", new Object[0]), DP.dpSoft(defaultBreedingXp)).func_240703_c_(greenColor).getString()));
                this.listButtons.add(otherAnimalsBreedButton);
                break;
            }
            case XP_VALUE_TAME: {
                ListButton otherAnimalsTameButton = new ListButton(0, 0, 3, 21, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickAction());
                otherAnimalsTameButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.taming", new Object[0]), DP.dpSoft(defaultTamingXp)).func_240703_c_(greenColor).getString()));
                this.listButtons.add(otherAnimalsTameButton);
                break;
            }
            case XP_VALUE_KILL: {
                ListButton otherAggresiveMobsButton = new ListButton(0, 0, 3, 26, "pmmo.otherAggresiveMobs", this.jType, "", button -> ((ListButton)button).clickAction());
                otherAggresiveMobsButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(aggresiveMobSlayerXp)).func_240703_c_(greenColor).getString()));
                this.listButtons.add(otherAggresiveMobsButton);
                ListButton otherPassiveMobsButton = new ListButton(0, 0, 3, 26, "pmmo.otherPassiveMobs", this.jType, "", button -> ((ListButton)button).clickAction());
                otherPassiveMobsButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(passiveMobHunterXp)).func_240703_c_(greenColor).getString()));
                this.listButtons.add(otherPassiveMobsButton);
                break;
            }
            case XP_VALUE_CRAFT: {
                ListButton otherCraftsButton = new ListButton(0, 0, 3, 22, "pmmo.otherCrafts", this.jType, "", button -> ((ListButton)button).clickAction());
                otherCraftsButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.crafting", new Object[0]), DP.dpSoft(defaultCraftingXp)).func_240703_c_(greenColor).getString()));
                this.listButtons.add(otherCraftsButton);
            }
        }
        this.scrollPanel = new ListScrollPanel(Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.jType, this.player, this.listButtons);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.func_230480_a_((Widget)exitButton);
    }

    private static void addLevelsToButton(ListButton button, Map<String, Object> map, PlayerEntity player, boolean ignoreReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Object> inEntry : map.entrySet()) {
            if (!ignoreReq && Skill.getSkill(inEntry.getKey()).getLevelDecimal(player) < (Double)inEntry.getValue()) {
                levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)((Double)inEntry.getValue()))).func_240703_c_(XP.textStyle.get("red")).getString()));
                continue;
            }
            levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)((Double)inEntry.getValue()))).func_240703_c_(XP.textStyle.get("green")).getString()));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Object> map) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Object> inEntry : map.entrySet()) {
            xpToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)((Double)inEntry.getValue()))).func_240703_c_(XP.textStyle.get("green")).getString()));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Object> map, JType jType, PlayerEntity player) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Object> inEntry : map.entrySet()) {
            xpToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)((Double)inEntry.getValue()))).func_240703_c_(XP.textStyle.get(XP.checkReq(player, button.regKey, jType) ? "green" : "red")).getString()));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addPercentageToButton(ListButton button, Map<String, Object> map, boolean metReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Object> inEntry : map.entrySet()) {
            double value = (Double)inEntry.getValue();
            if (metReq) {
                if (value > 0.0) {
                    levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), "+" + value + "%").func_240703_c_(XP.textStyle.get("green")).getString()));
                    continue;
                }
                if (!(value < 0.0)) continue;
                levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").func_240703_c_(XP.textStyle.get("red")).getString()));
                continue;
            }
            levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").func_240703_c_(XP.textStyle.get("red")).getString()));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static int getTextInt(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return (int)Double.parseDouble(number);
        }
        return 0;
    }

    private static int getReqCount(String regKey, JType jType) {
        Map<String, Double> map = XP.getReqMap(regKey, jType);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(stack, 1);
        if (this.jType.equals((Object)JType.STATS)) {
            this.title = ListScreen.getTransComp("pmmo.playerStats", XP.playerNames.get(this.uuid));
        }
        if (this.field_230712_o_.func_78256_a(this.title.getString()) > 220) {
            this.func_238472_a_(stack, this.field_230712_o_, (ITextProperties)this.title, this.sr.func_198107_o() / 2, this.y - 10, 0xFFFFFF);
        } else {
            this.func_238472_a_(stack, this.field_230712_o_, (ITextProperties)this.title, this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.accumulativeHeight = 0;
        this.buttonsSize = this.listButtons.size();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (ListButton button : this.listButtons) {
            this.buttonX = mouseX - button.field_230690_l_;
            this.buttonY = mouseY - button.field_230691_m_;
            if (mouseY >= this.scrollPanel.getTop() && mouseY <= this.scrollPanel.getBottom() && this.buttonX >= 0 && this.buttonX < 32 && this.buttonY >= 0 && this.buttonY < 32) {
                if (this.jType.equals((Object)JType.REQ_BIOME) || this.jType.equals((Object)JType.XP_VALUE_KILL) || this.jType.equals((Object)JType.XP_VALUE_BREED) || this.jType.equals((Object)JType.XP_VALUE_TAME) || this.jType.equals((Object)JType.DIMENSION) || this.jType.equals((Object)JType.FISH_ENCHANT_POOL) || this.jType.equals((Object)JType.STATS) || button.regKey.equals("pmmo.otherCrafts")) {
                    this.func_238652_a_(stack, (ITextProperties)new TranslationTextComponent(button.title), mouseX, mouseY);
                } else if (button.itemStack != null) {
                    this.func_230457_a_(stack, button.itemStack, mouseX, mouseY);
                }
            }
            this.accumulativeHeight += button.getHeight();
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
    }

    public void func_238651_a_(MatrixStack stack, int p_renderBackground_1_) {
        if (this.field_230706_i_ != null) {
            this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        this.accumulativeHeight = 0;
        for (ListButton listButton : this.listButtons) {
            this.accumulativeHeight += listButton.getHeight();
            if (this.accumulativeHeight <= this.scrollPanel.getBottom() - this.scrollPanel.getTop()) continue;
            this.scrollPanel.func_231043_a_(mouseX, mouseY, scroll);
            break;
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.func_230930_b_();
            return true;
        }
        for (ListButton a : this.listButtons) {
            int buttonX = (int)mouseX - a.field_230690_l_;
            int buttonY = (int)mouseY - a.field_230691_m_;
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom()) || buttonX < 0 || buttonX >= 32 || buttonY < 0 || buttonY >= 32) continue;
            a.func_230982_a_(mouseX, mouseY);
        }
        this.scrollPanel.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.scrollPanel.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }
}

