/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.PrefsEntry;
import harmonised.pmmo.gui.PrefsScrollPanel;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PrefsScreen
extends Screen {
    public static CompoundNBT prefsTag;
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private int i;
    private double value;
    private static Button exitButton;
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private int boxWidth = 256;
    private int boxHeight = 256;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private PrefsScrollPanel scrollPanel;
    private final JType jType;
    private ArrayList<PrefsEntry> prefsEntries;
    private ITextComponent title;
    private PlayerEntity player;

    public PrefsScreen(ITextComponent titleIn, JType jType) {
        super(titleIn);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.title = titleIn;
        this.jType = jType;
    }

    protected void func_231160_c_() {
        prefsTag = XP.getPreferencesTag(this.player);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", "", button -> Minecraft.func_71410_x().func_147108_a((Screen)new PrefsChoiceScreen((ITextComponent)new TranslationTextComponent("pmmo.stats"))));
        this.prefsEntries = new ArrayList();
        switch (this.jType) {
            case SETTINGS: {
                this.value = Math.min((double)Skill.BUILDING.getLevel(this.player) / Config.getConfig("levelsPerOneReach"), Config.getConfig("maxExtraReachBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraReachBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxExtraReachBoost") ? prefsTag.func_74769_h("maxExtraReachBoost") : this.value, this.value, true, true, true, false));
                this.value = Math.min((double)Skill.ENDURANCE.getLevel(this.player) / Config.getConfig("levelsPerHeart"), Config.getConfig("maxExtraHeartBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraHeartBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxExtraHeartBoost") ? prefsTag.func_74769_h("maxExtraHeartBoost") : this.value, this.value, false, true, true, false));
                this.value = Math.min((double)Skill.COMBAT.getLevel(this.player) / Config.getConfig("levelsPerDamage"), Config.getConfig("maxExtraDamageBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraDamageBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxExtraDamageBoost") ? prefsTag.func_74769_h("maxExtraDamageBoost") : this.value, this.value, false, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("speedBoostPerLevel"), Config.getConfig("maxSpeedBoost"));
                this.prefsEntries.add(new PrefsEntry("maxSpeedBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxSpeedBoost") ? prefsTag.func_74769_h("maxSpeedBoost") : this.value, this.value, true, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("levelsPerSprintJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.prefsEntries.add(new PrefsEntry("maxSprintJumpBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxSprintJumpBoost") ? prefsTag.func_74769_h("maxSprintJumpBoost") : this.value, this.value, true, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("levelsPerCrouchJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.prefsEntries.add(new PrefsEntry("maxCrouchJumpBoost", "", "", 0.0, this.value, prefsTag.func_74764_b("maxCrouchJumpBoost") ? prefsTag.func_74769_h("maxCrouchJumpBoost") : this.value, this.value, true, true, true, false));
                this.prefsEntries.add(new PrefsEntry("wipeAllSkillsUponDeathPermanently", "", "", 0.0, 1.0, prefsTag.func_74764_b("wipeAllSkillsUponDeathPermanently") ? prefsTag.func_74769_h("wipeAllSkillsUponDeathPermanently") : 0.0, 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("spawnFireworksCausedByMe", "", "", 0.0, 1.0, prefsTag.func_74764_b("spawnFireworksCausedByMe") ? prefsTag.func_74769_h("spawnFireworksCausedByMe") : 1.0, 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("spawnFireworksCausedByOthers", "", "", 0.0, 1.0, prefsTag.func_74764_b("spawnFireworksCausedByOthers") ? prefsTag.func_74769_h("spawnFireworksCausedByOthers") : 1.0, 1.0, false, true, false, true));
                break;
            }
            case GUI_SETTINGS: {
                this.prefsEntries.add(new PrefsEntry("barOffsetX", "", "", 0.0, 1.0, prefsTag.func_74764_b("barOffsetX") ? prefsTag.func_74769_h("barOffsetX") : 0.5, 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("barOffsetY", "", "", 0.0, 1.0, prefsTag.func_74764_b("barOffsetY") ? prefsTag.func_74769_h("barOffsetY") : 0.0, 0.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("veinBarOffsetX", "", "", 0.0, 1.0, prefsTag.func_74764_b("veinBarOffsetX") ? prefsTag.func_74769_h("veinBarOffsetX") : 0.5, 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("veinBarOffsetY", "", "", 0.0, 1.0, prefsTag.func_74764_b("veinBarOffsetY") ? prefsTag.func_74769_h("veinBarOffsetY") : 0.65, 0.65, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOffsetX", "", "", 0.0, 1.0, prefsTag.func_74764_b("xpDropOffsetX") ? prefsTag.func_74769_h("xpDropOffsetX") : 0.5, 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOffsetY", "", "", 0.0, 1.0, prefsTag.func_74764_b("xpDropOffsetY") ? prefsTag.func_74769_h("xpDropOffsetY") : 0.0, 0.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropSpawnDistance", "", "", 0.0, 1000.0, prefsTag.func_74764_b("xpDropSpawnDistance") ? prefsTag.func_74769_h("xpDropSpawnDistance") : 50.0, 50.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOpacityPerTime", "", "", 0.0, 255.0, prefsTag.func_74764_b("xpDropOpacityPerTime") ? prefsTag.func_74769_h("xpDropOpacityPerTime") : 5.0, 5.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropMaxOpacity", "", "", 0.0, 255.0, prefsTag.func_74764_b("xpDropMaxOpacity") ? prefsTag.func_74769_h("xpDropMaxOpacity") : 200.0, 200.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropDecayAge", "", "", 0.0, 5000.0, prefsTag.func_74764_b("xpDropDecayAge") ? prefsTag.func_74769_h("xpDropDecayAge") : 350.0, 350.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("minXpGrow", "", "", 0.01, 100.0, prefsTag.func_74764_b("minXpGrow") ? prefsTag.func_74769_h("minXpGrow") : 1.0, 1.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("showSkillsListAtCorner", "", "", 0.0, 1.0, prefsTag.func_74764_b("showSkillsListAtCorner") ? prefsTag.func_74769_h("showSkillsListAtCorner") : 1.0, 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("showXpDrops", "", "", 0.0, 1.0, prefsTag.func_74764_b("showXpDrops") ? prefsTag.func_74769_h("showXpDrops") : 1.0, 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("stackXpDrops", "", "", 0.0, 1.0, prefsTag.func_74764_b("stackXpDrops") ? prefsTag.func_74769_h("stackXpDrops") : 1.0, 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpDropsAttachedToBar", "", "", 0.0, 1.0, prefsTag.func_74764_b("xpDropsAttachedToBar") ? prefsTag.func_74769_h("xpDropsAttachedToBar") : 1.0, 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpBarAlwaysOn", "", "", 0.0, 1.0, prefsTag.func_74764_b("xpBarAlwaysOn") ? prefsTag.func_74769_h("xpBarAlwaysOn") : 0.0, 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpLeftDisplayAlwaysOn", "", "", 0.0, 1.0, prefsTag.func_74764_b("xpLeftDisplayAlwaysOn") ? prefsTag.func_74769_h("xpLeftDisplayAlwaysOn") : 0.0, 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("lvlUpScreenshot", "", "", 0.0, 1.0, prefsTag.func_74764_b("lvlUpScreenshot") ? prefsTag.func_74769_h("lvlUpScreenshot") : 0.0, 0.0, false, true, false, true));
            }
        }
        this.i = 0;
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!prefEntry.isSwitch) {
                prefEntry.textField.func_212954_a(text -> {
                    try {
                        this.value = Double.parseDouble(text);
                        if (this.value > prefEntry.slider.maxValue) {
                            this.value = prefEntry.slider.maxValue;
                        }
                        if (this.value < prefEntry.slider.minValue) {
                            this.value = prefEntry.slider.minValue;
                        }
                        prefEntry.slider.setValue(this.value);
                        prefEntry.slider.updateSlider();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                prefEntry.textField.func_200675_a(text -> text.matches("^[0-9]{0,3}[.]?[0-9]*$") && text.replace(".", "").length() < 5);
            }
            prefEntry.slider.setResponder(slider -> {
                slider.precision = 4;
                prefsTag.func_74780_a(slider.preference, slider.getValue());
                if (prefEntry.removeIfMax && slider.getValue() == slider.maxValue) {
                    prefsTag.func_82580_o(slider.preference);
                }
                XPOverlayGUI.doInit();
                PlayerTickHandler.syncPrefs = true;
            });
            prefEntry.slider.updateSlider();
            prefEntry.setX(this.x + 24);
            prefEntry.setY(this.y + 24 + 18 * this.i++);
        }
        this.scrollPanel = new PrefsScrollPanel(new MatrixStack(), Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.prefsEntries);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.func_230480_a_((Widget)exitButton);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(stack, 1);
        if (this.field_230712_o_.func_78256_a(this.title.getString()) > 220) {
            this.func_238471_a_(stack, this.field_230712_o_, this.title.getString(), this.sr.func_198107_o() / 2, this.y - 10, 0xFFFFFF);
        } else {
            this.func_238471_a_(stack, this.field_230712_o_, this.title.getString(), this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (mouseX < prefEntry.button.field_230690_l_ || mouseX >= prefEntry.button.field_230690_l_ + prefEntry.button.func_230998_h_() || mouseY < prefEntry.button.field_230691_m_ || mouseY >= prefEntry.button.field_230691_m_ + prefEntry.button.getHeight()) continue;
            this.func_238652_a_(stack, (ITextProperties)new TranslationTextComponent(prefEntry.isSwitch ? (prefEntry.defaultVal == 1.0 ? "ON" : "OFF") : (prefEntry.removeIfMax && prefEntry.defaultVal == prefEntry.slider.maxValue ? "MAX" : DP.dpSoft(prefEntry.defaultVal))), mouseX, mouseY);
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_238651_a_(MatrixStack stack, int p_renderBackground_1_) {
        if (this.field_230706_i_ != null) {
            this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (this.prefsEntries.size() >= 9) {
            this.scrollPanel.func_231043_a_(mouseX, mouseY, scroll);
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.func_230930_b_();
            return true;
        }
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseClicked(mouseX, mouseY, button);
            if (prefEntry.isSwitch || !prefEntry.textField.func_231044_a_(mouseX, mouseY, button)) continue;
            this.func_231035_a_((IGuiEventListener)prefEntry.textField);
        }
        this.scrollPanel.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseReleased(mouseX, mouseY, button);
        }
        this.scrollPanel.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.scrollPanel.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }
}

