/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.gui.PrefsEntry;
import harmonised.pmmo.gui.PrefsSlider;
import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class PrefsScrollPanel
extends ScrollPanel {
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private final ArrayList<PrefsEntry> prefsEntries;
    private PrefsEntry prefEntry;
    private FontRenderer font;
    private PrefsSlider slider;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;

    public PrefsScrollPanel(MatrixStack stack, Minecraft client, int width, int height, int top, int left, ArrayList<PrefsEntry> prefsEntries) {
        super(client, width, height, top, left);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.border = 4;
        this.barWidth = 6;
        this.prefsEntries = prefsEntries;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    protected int getContentHeight() {
        int height = -4;
        for (PrefsEntry a : this.prefsEntries) {
            height += a.getHeight() + 2;
        }
        return height;
    }

    protected void drawPanel(MatrixStack stack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        for (int i = 0; i < this.prefsEntries.size(); ++i) {
            this.prefEntry = this.prefsEntries.get(i);
            this.prefEntry.setX(this.left + 6);
            this.prefEntry.setY(7 + relativeY + (this.prefEntry.getHeight() + 2) * i);
            this.slider = this.prefEntry.slider;
            if (this.prefEntry.getY() + this.prefEntry.getHeight() <= this.top || this.prefEntry.getY() - this.prefEntry.getHeight() >= this.bottom) continue;
            if (this.prefEntry.isSwitch) {
                if (this.slider.getValue() == 1.0) {
                    this.func_238468_a_(stack, this.left + 4, this.prefEntry.getY() - 11, this.right - 2, this.prefEntry.getY() + this.slider.getHeight() + 2, 0x22444444, 0x33222222);
                } else {
                    this.func_238468_a_(stack, this.left + 4, this.prefEntry.getY() - 11, this.right - 2, this.prefEntry.getY() + this.slider.getHeight() + 2, -1438366652, -1440603614);
                }
            } else if ((float)this.prefEntry.defaultVal == (float)this.slider.getValue()) {
                this.func_238468_a_(stack, this.left + 4, this.prefEntry.getY() - 11, this.right - 2, this.prefEntry.getY() + this.slider.getHeight() + 2, -1438366652, -1440603614);
            } else {
                this.func_238468_a_(stack, this.left + 4, this.prefEntry.getY() - 11, this.right - 2, this.prefEntry.getY() + this.slider.getHeight() + 2, 0x22444444, 0x33222222);
            }
            this.func_238471_a_(stack, this.font, this.prefEntry.preference, this.prefEntry.getX() + this.slider.func_230998_h_() / 2, this.prefEntry.getY() - 9, 0xFFFFFF);
            this.slider.func_230430_a_(stack, mouseX, mouseY, 0.0f);
            this.prefEntry.button.func_230430_a_(stack, mouseX, mouseY, 0.0f);
            if (this.prefEntry.isSwitch) continue;
            this.prefEntry.textField.func_230430_a_(stack, mouseX, mouseY, 0.0f);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        double scale = this.client.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }
}

