/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.ASkill;
import harmonised.pmmo.gui.XpDrop;
import harmonised.pmmo.network.MessageLevelUp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class XPOverlayGUI
extends AbstractGui {
    private static int barWidth = 102;
    private static int barHeight = 5;
    private static int barPosX;
    private static int barPosY;
    private static int veinBarPosX;
    private static int veinBarPosY;
    private static int xpDropPosX;
    private static int xpDropPosY;
    private static int tempAlpha;
    private static int levelGap;
    private static int skillGap;
    private static int xpGap;
    private static int halfscreen;
    private static int tempInt;
    private static int xpDropDecayAge;
    private static ArrayList<Skill> skillsKeys;
    private static double xp;
    private static double goalXp;
    private static double cooldown;
    private static double lastTime;
    private static double startLevel;
    private static double timeDiff;
    private static double bonus;
    private static double level;
    private static double decayRate;
    private static double decayAmount;
    private static double growAmount;
    private static double xpDropOffset;
    private static double xpDropOffsetCap;
    private static double minXpGrow;
    private static double barOffsetX;
    private static double barOffsetY;
    private static double veinBarOffsetX;
    private static double veinBarOffsetY;
    private static double xpDropOffsetX;
    private static double xpDropOffsetY;
    private static double xpDropSpawnDistance;
    private static double xpDropOpacityPerTime;
    private static double xpDropMaxOpacity;
    private static double biomePenaltyMultiplier;
    private static double maxVeinCharge;
    private static String tempString;
    private static int theme;
    private static int themePos;
    private static int listIndex;
    private static int xpDropYLimit;
    private static String skillName;
    private static boolean stackXpDrops;
    private static boolean init;
    private static boolean showSkillsListAtCorner;
    private static boolean showXpDrops;
    private static boolean guiKey;
    private static boolean veinKey;
    private static boolean guiPressed;
    private static boolean xpDropsAttachedToBar;
    private static boolean xpDropWasStacked;
    private static boolean xpLeftDisplayAlwaysOn;
    private static boolean xpBarAlwaysOn;
    private static boolean lvlUpScreenshot;
    private static boolean lvlUpScreenshotShowSkills;
    private final ResourceLocation bar = XP.getResLoc("pmmo", "textures/gui/xpbar.png");
    private static ArrayList<XpDrop> xpDrops;
    private static Minecraft mc;
    private static PlayerEntity player;
    public static Map<Skill, ASkill> skills;
    private static ASkill aSkill;
    private static Skill skill;
    private static Skill tempSkill;
    private static FontRenderer fontRenderer;
    private static int maxLevel;
    private static int color;
    private static int breakAmount;
    private static int veinMaxBlocks;
    private static double maxXp;
    private static XpDrop xpDrop;
    private static long lastBonusUpdate;
    private static long lastVeinBlockUpdate;
    private static double itemBoost;
    private static double biomeBoost;
    private static double tempDouble;
    private static double veinPos;
    private static double lastVeinPos;
    private static double veinPosGoal;
    private static double addAmount;
    private static double lossAmount;
    private static double veinLeft;
    private static BlockState blockState;
    private static BlockState lastBlockState;
    private static String lastBlockRegKey;
    private static String lastBlockTransKey;
    private static Item lastToolHeld;
    private static MatrixStack stack;
    public static Set<String> screenshots;
    public static boolean guiWasOn;
    public static boolean guiOn;
    public static boolean isVeining;
    public static boolean canBreak;
    public static boolean canVein;
    public static boolean lookingAtBlock;
    public static boolean metToolReq;
    MainWindow sr;
    BlockPos blockPos;
    BlockPos lastBlockPos;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        if (!skill.equals((Object)Skill.INVALID_SKILL) && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            player = Minecraft.func_71410_x().field_71439_g;
            if (!init) {
                XPOverlayGUI.doInit();
                init = true;
            }
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            this.sr = mc.func_228018_at_();
            stack = event.getMatrixStack();
            barPosX = (int)((double)(this.sr.func_198107_o() - barWidth) * barOffsetX);
            barPosY = (int)((double)(this.sr.func_198087_p() - barHeight) * barOffsetY);
            xpDropPosX = (int)((double)(this.sr.func_198107_o() - barWidth) * xpDropOffsetX);
            xpDropPosY = (int)((double)(this.sr.func_198087_p() - barHeight) * xpDropOffsetY);
            aSkill = skills.get((Object)skill);
            timeDiff = (double)System.nanoTime() - lastTime;
            lastTime = System.nanoTime();
            guiKey = ClientHandler.SHOW_GUI.func_151470_d();
            veinKey = ClientHandler.VEIN_KEY.func_151470_d();
            if (guiKey || xpBarAlwaysOn) {
                cooldown = 1.0;
            }
            if (guiKey) {
                if (!guiPressed) {
                    guiOn = !guiOn;
                    guiPressed = true;
                }
            } else {
                guiPressed = false;
            }
            if (!Minecraft.func_71410_x().func_147113_T()) {
                this.doRayTrace();
                this.doCrosshair();
                this.doVein();
                this.doSkills();
            }
            this.doXpDrops(stack);
            this.doXpBar();
            if (showSkillsListAtCorner) {
                this.doSkillList();
            }
            if (cooldown > 0.0) {
                cooldown -= timeDiff / 1000000.0;
            }
            RenderSystem.disableBlend();
            RenderSystem.color3f((float)255.0f, (float)255.0f, (float)255.0f);
            RenderSystem.popMatrix();
        }
    }

    private void doRayTrace() {
        if (XPOverlayGUI.mc.field_71476_x != null && XPOverlayGUI.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            lookingAtBlock = true;
            this.blockPos = ((BlockRayTraceResult)XPOverlayGUI.mc.field_71476_x).func_216350_a();
            blockState = XPOverlayGUI.mc.field_71441_e.func_180495_p(this.blockPos);
            if (lastBlockState == null) {
                this.updateLastBlock();
            }
            if (lastBlockState.func_177230_c().equals(blockState.func_177230_c())) {
                lastVeinBlockUpdate = System.nanoTime();
            }
            if (!isVeining && System.nanoTime() - lastVeinBlockUpdate > 100000000L) {
                this.updateLastBlock();
            }
            canBreak = XP.checkReq(player, lastBlockRegKey, JType.REQ_BREAK);
        } else {
            lookingAtBlock = false;
        }
    }

    private void updateLastBlock() {
        lastBlockState = blockState;
        this.lastBlockPos = this.blockPos;
        if (lastBlockState.func_177230_c().getRegistryName() != null) {
            lastBlockRegKey = lastBlockState.func_177230_c().getRegistryName().toString();
        }
        canVein = WorldTickHandler.canVeinGlobal(lastBlockRegKey, player) && WorldTickHandler.canVeinDimension(lastBlockRegKey, player);
        lastBlockTransKey = lastBlockState.func_177230_c().func_149739_a();
    }

    private void doXpDrops(MatrixStack stack) {
        if (xpDropsAttachedToBar) {
            xpDropOffsetCap = cooldown <= 0.0 ? -9.0 : (guiKey || xpLeftDisplayAlwaysOn ? (XPOverlayGUI.skills.get((Object)((Object)XPOverlayGUI.skill)).xp >= maxXp ? 25.0 : 34.0) : 16.0);
            if (xpDropOffset > xpDropOffsetCap) {
                xpDropOffset -= 1.0 * timeDiff / 1.0E7;
            }
            if (xpDropOffset < xpDropOffsetCap) {
                xpDropOffset = xpDropOffsetCap;
            }
        }
        for (int i = 0; i < xpDrops.size(); ++i) {
            xpDrop = xpDrops.get(i);
            XPOverlayGUI.xpDrop.age = (int)((double)XPOverlayGUI.xpDrop.age + timeDiff / 5000000.0);
            decayRate = 0.75f + (float)(1 * xpDrops.size()) * 0.02f;
            decayAmount = decayRate * timeDiff / 1.0E7;
            if (!mc.func_147113_T() && (XPOverlayGUI.xpDrop.Y - decayAmount < 0.0 && XPOverlayGUI.xpDrop.age >= xpDropDecayAge || !showXpDrops || !xpDropsAttachedToBar && XPOverlayGUI.xpDrop.age >= xpDropDecayAge)) {
                aSkill = skills.get((Object)XPOverlayGUI.xpDrop.skill);
                skill = XPOverlayGUI.xpDrop.skill;
                decayRate = XPOverlayGUI.xpDrop.gainedXp * 0.03 * timeDiff / 1.0E7;
                if (stackXpDrops) {
                    if (decayRate < 0.1) {
                        decayRate = 0.1;
                    }
                } else if (decayRate < 1.0) {
                    decayRate = 1.0;
                }
                if (XPOverlayGUI.xpDrop.gainedXp - decayAmount < 0.0) {
                    XPOverlayGUI.aSkill.goalXp += XPOverlayGUI.xpDrop.gainedXp;
                    XPOverlayGUI.xpDrop.gainedXp = 0.0;
                } else {
                    XPOverlayGUI.xpDrop.gainedXp -= decayRate;
                    XPOverlayGUI.aSkill.goalXp += decayRate;
                }
                XPOverlayGUI.aSkill.goalPos = XP.levelAtXpDecimal(XPOverlayGUI.aSkill.goalXp);
            }
            if (!showXpDrops) continue;
            if (xpDropOffset == xpDropOffsetCap) {
                XPOverlayGUI.xpDrop.Y -= decayAmount;
            }
            if (XPOverlayGUI.xpDrop.Y < (double)(i * 9 - xpDropYLimit)) {
                XPOverlayGUI.xpDrop.Y = i * 9 - xpDropYLimit;
            }
            if ((tempInt = (int)Math.floor(XPOverlayGUI.xpDrop.Y * xpDropOpacityPerTime)) < 0) {
                tempInt = -tempInt;
            }
            if ((tempAlpha = (double)tempInt > xpDropMaxOpacity ? 0 : (int)Math.floor(xpDropMaxOpacity - (double)tempInt)) <= 3) continue;
            this.func_238471_a_(stack, fontRenderer, "+" + DP.dprefix(XPOverlayGUI.xpDrop.gainedXp) + " " + new TranslationTextComponent("pmmo." + XPOverlayGUI.xpDrop.skill.name().toLowerCase()).getString(), xpDropPosX + barWidth / 2, (int)XPOverlayGUI.xpDrop.Y + (int)xpDropOffset + xpDropPosY, tempAlpha << 24 | XP.getSkillColor(XPOverlayGUI.xpDrop.skill));
        }
        if (xpDrops.size() > 0 && XPOverlayGUI.xpDrops.get((int)0).gainedXp <= 0.0) {
            xpDrops.remove(0);
        }
    }

    private void doSkills() {
        for (Map.Entry<Skill, ASkill> entry : skills.entrySet()) {
            aSkill = entry.getValue();
            startLevel = Math.floor(XPOverlayGUI.aSkill.pos);
            growAmount = (XPOverlayGUI.aSkill.goalPos - XPOverlayGUI.aSkill.pos) * 50.0;
            minXpGrow = 25.0;
            if (growAmount < minXpGrow) {
                growAmount = minXpGrow;
            }
            if (XPOverlayGUI.aSkill.pos < XPOverlayGUI.aSkill.goalPos) {
                XPOverlayGUI.aSkill.pos += 5.0E-5 * growAmount;
                XPOverlayGUI.aSkill.xp = XP.xpAtLevelDecimal(XPOverlayGUI.aSkill.pos);
            }
            if (XPOverlayGUI.aSkill.pos > XPOverlayGUI.aSkill.goalPos) {
                XPOverlayGUI.aSkill.pos = XPOverlayGUI.aSkill.goalPos;
            }
            if (startLevel < (double)((int)XPOverlayGUI.aSkill.pos)) {
                XPOverlayGUI.sendLvlUp((int)Math.floor(XPOverlayGUI.aSkill.pos), entry.getKey());
            }
            if (!(XPOverlayGUI.aSkill.xp > XPOverlayGUI.aSkill.goalXp)) continue;
            XPOverlayGUI.aSkill.xp = XPOverlayGUI.aSkill.goalXp;
        }
    }

    private void doXpBar() {
        if ((themePos = (int)((double)themePos + (2.5 + 7.5 * (XPOverlayGUI.aSkill.pos % Math.floor(XPOverlayGUI.aSkill.pos))) * (timeDiff / 1000000.0))) > 10000) {
            themePos %= 10000;
        }
        if (cooldown > 0.0) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bar);
            RenderSystem.color3f((float)255.0f, (float)255.0f, (float)255.0f);
            aSkill = skills.get((Object)skill);
            this.func_238474_b_(stack, barPosX, barPosY + 10, 0, 0, barWidth, barHeight);
            if (theme == 1) {
                this.func_238474_b_(stack, barPosX, barPosY + 10, 0, barHeight * 1, (int)Math.floor((double)barWidth * (XPOverlayGUI.aSkill.pos - Math.floor(XPOverlayGUI.aSkill.pos))), barHeight);
            } else {
                tempInt = (int)Math.floor((double)barWidth * (XPOverlayGUI.aSkill.pos - Math.floor(XPOverlayGUI.aSkill.pos)));
                if (tempInt > 100) {
                    tempInt = 100;
                }
                if (XPOverlayGUI.aSkill.pos >= (double)maxLevel) {
                    tempInt = 100;
                }
                this.func_238474_b_(stack, barPosX, barPosY + 10, 0, barHeight * 3, barWidth - 1, barHeight);
                this.func_238474_b_(stack, barPosX + 1, barPosY + 10, 1 + (int)Math.floor((double)themePos / 100.0), barHeight * 2, tempInt, barHeight);
            }
            if (XPOverlayGUI.aSkill.pos >= (double)maxLevel) {
                this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + skill.name().toLowerCase()).getString(), maxLevel}).getString(), barPosX + barWidth / 2, barPosY, XP.getSkillColor(skill));
            } else {
                this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + skill.name().toLowerCase()).getString(), DP.dp(Math.floor(XPOverlayGUI.aSkill.pos * 100.0) / 100.0)}).getString(), barPosX + barWidth / 2, barPosY, XP.getSkillColor(skill));
            }
            if ((guiKey || xpLeftDisplayAlwaysOn) && skills.get((Object)skill) != null) {
                if (XPOverlayGUI.skills.get((Object)((Object)XPOverlayGUI.skill)).xp >= maxXp) {
                    this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.maxLevel").getString(), barPosX + barWidth / 2, 17 + barPosY, XP.getSkillColor(skill));
                } else {
                    if (goalXp >= maxXp) {
                        goalXp = maxXp;
                    }
                    goalXp = XP.xpAtLevel(XP.levelAtXp(XPOverlayGUI.aSkill.xp) + 1);
                    this.func_238471_a_(stack, fontRenderer, DP.dprefix(XPOverlayGUI.skills.get((Object)((Object)XPOverlayGUI.skill)).xp) + " / " + DP.dprefix(goalXp), barPosX + barWidth / 2, 17 + barPosY, XP.getSkillColor(skill));
                    this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.xpLeft", new Object[]{DP.dprefix(goalXp - XPOverlayGUI.aSkill.xp)}).getString(), barPosX + barWidth / 2, 26 + barPosY, XP.getSkillColor(skill));
                }
            }
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    private void doVein() {
        veinLeft = XP.getAbilitiesTag(player).func_74769_h("veinLeft");
        veinPosGoal = veinLeft / maxVeinCharge;
        addAmount = (veinPosGoal - veinPos) * (timeDiff / 2.0E8);
        if (addAmount < 3.0E-5) {
            addAmount = 3.0E-5;
        }
        lossAmount = -(veinPosGoal - veinPos) * (timeDiff / 2.0E8);
        if (veinPos < veinPosGoal) {
            if ((veinPos += addAmount) > veinPosGoal) {
                veinPos = veinPosGoal;
            }
        } else if (veinPos > veinPosGoal && (veinPos -= lossAmount) < veinPosGoal) {
            veinPos = veinPosGoal;
        }
        if (veinPos < 0.0 || veinPos > 1.0) {
            veinPos = veinPosGoal;
        }
        if (veinPos == 1.0 && lastVeinPos != 1.0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.veinCharge", new Object[]{100}).func_240703_c_(XP.textStyle.get("green")), true);
        }
        lastVeinPos = veinPos;
        veinBarPosX = (int)((double)this.sr.func_198107_o() * veinBarOffsetX - (double)(barWidth / 2));
        veinBarPosY = (int)((double)this.sr.func_198087_p() * veinBarOffsetY - (double)(barHeight / 2));
        if (veinKey && XP.isPlayerSurvival(player)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bar);
            this.func_238474_b_(stack, veinBarPosX, veinBarPosY, 0, 0, barWidth, barHeight);
            this.func_238474_b_(stack, veinBarPosX, veinBarPosY, 0, barHeight, (int)Math.floor((double)barWidth * veinPos), barHeight);
            this.func_238471_a_(stack, fontRenderer, (int)Math.floor(veinPos * maxVeinCharge) + "/" + (int)Math.floor(maxVeinCharge) + " " + DP.dprefix(veinPos * 100.0) + "%", veinBarPosX + barWidth / 2, veinBarPosY - 8, 65280);
            metToolReq = XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL);
            if (!metToolReq) {
                this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslationTextComponent(player.func_184614_ca().func_77977_a())}).func_240703_c_(XP.textStyle.get("red")).getString(), this.sr.func_198107_o() / 2, veinBarPosY + 6, 0xFFFFFF);
                return;
            }
            if (lookingAtBlock && !canBreak) {
                this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslationTextComponent(lastBlockTransKey)}).func_240703_c_(XP.textStyle.get("red")).getString(), this.sr.func_198107_o() / 2, veinBarPosY + 6, 0xFFFFFF);
                return;
            }
            if (lastBlockState != null && canBreak && (lookingAtBlock || isVeining)) {
                if (canVein) {
                    breakAmount = (int)(maxVeinCharge * veinPos / WorldTickHandler.getVeinCost(lastBlockState, this.lastBlockPos, player));
                    if (breakAmount > veinMaxBlocks) {
                        breakAmount = veinMaxBlocks;
                    }
                    this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.canVein", new Object[]{breakAmount, new TranslationTextComponent(lastBlockTransKey)}).getString(), veinBarPosX + barWidth / 2, veinBarPosY + 6, 65280);
                } else if (WorldTickHandler.canVeinDimension(lastBlockRegKey, player)) {
                    this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.cannotVein", new Object[]{new TranslationTextComponent(lastBlockTransKey).getString()}).getString(), veinBarPosX + barWidth / 2, veinBarPosY + 6, 0xFF5454);
                } else {
                    this.func_238471_a_(stack, fontRenderer, new TranslationTextComponent("pmmo.cannotVeinDimension", new Object[]{new TranslationTextComponent(lastBlockTransKey).getString()}).getString(), veinBarPosX + barWidth / 2, veinBarPosY + 6, 0xFF5454);
                }
            }
        }
    }

    private void doSkillList() {
        if (guiOn && !XPOverlayGUI.mc.field_71474_y.field_74330_P) {
            listIndex = 0;
            if (System.nanoTime() - lastBonusUpdate > 250000000L) {
                for (Map.Entry<Skill, ASkill> entry : skills.entrySet()) {
                    tempSkill = entry.getKey();
                    itemBoost = XP.getItemBoost(player, tempSkill);
                    if (itemBoost + (biomeBoost = XP.getBiomeBoost(player, tempSkill)) >= -100.0) {
                        XPOverlayGUI.skills.get((Object)((Object)XPOverlayGUI.tempSkill)).bonus = itemBoost + biomeBoost;
                        continue;
                    }
                    XPOverlayGUI.skills.get((Object)((Object)XPOverlayGUI.tempSkill)).bonus = -100.0;
                }
                lastBonusUpdate = System.nanoTime();
            }
            skillsKeys = new ArrayList<Skill>(skills.keySet());
            skillsKeys.sort(Comparator.comparingDouble(a -> ((Skill)((Object)((Object)a))).getXp(player)).reversed());
            for (Skill keySkill : skillsKeys) {
                aSkill = skills.get((Object)keySkill);
                skillName = keySkill.name().toLowerCase();
                level = XP.levelAtXpDecimal(XPOverlayGUI.aSkill.xp);
                tempString = DP.dp(Math.floor(level * 100.0) / 100.0);
                color = XP.getSkillColor(keySkill);
                if (level >= (double)maxLevel) {
                    tempString = "" + maxLevel;
                }
                this.func_238476_c_(stack, fontRenderer, tempString, levelGap + 4 - fontRenderer.func_78256_a(tempString), 3 + listIndex, color);
                this.func_238476_c_(stack, fontRenderer, " | " + new TranslationTextComponent("pmmo." + skillName).getString(), levelGap + 4, 3 + listIndex, color);
                this.func_238476_c_(stack, fontRenderer, " | " + DP.dprefix(XPOverlayGUI.aSkill.xp), levelGap + skillGap + 13, 3 + listIndex, color);
                if (XPOverlayGUI.aSkill.bonus != 0.0) {
                    bonus = Math.floor(XPOverlayGUI.aSkill.bonus * 100.0) / 100.0;
                    tempString = bonus > 0.0 ? "+" + (bonus % 1.0 == 0.0 ? Integer.valueOf((int)Math.floor(bonus)) : DP.dp(bonus)) + "%" : (bonus < 0.0 ? (bonus % 1.0 == 0.0 ? Integer.valueOf((int)Math.floor(bonus)) : DP.dp(bonus)) + "%" : "");
                    this.func_238476_c_(stack, fontRenderer, tempString, levelGap + skillGap + xpGap + 32, 3 + listIndex, color);
                }
                listIndex += 9;
            }
        }
    }

    private void doCrosshair() {
    }

    public static void doInit() {
        player = Minecraft.func_71410_x().field_71439_g;
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        barOffsetX = prefsTag.func_74764_b("barOffsetX") ? prefsTag.func_74769_h("barOffsetX") : Config.forgeConfig.barOffsetX.get().doubleValue();
        barOffsetY = prefsTag.func_74764_b("barOffsetY") ? prefsTag.func_74769_h("barOffsetY") : Config.forgeConfig.barOffsetY.get().doubleValue();
        veinBarOffsetX = prefsTag.func_74764_b("veinBarOffsetX") ? prefsTag.func_74769_h("veinBarOffsetX") : Config.forgeConfig.veinBarOffsetX.get().doubleValue();
        veinBarOffsetY = prefsTag.func_74764_b("veinBarOffsetY") ? prefsTag.func_74769_h("veinBarOffsetY") : Config.forgeConfig.veinBarOffsetY.get().doubleValue();
        xpDropOffsetX = prefsTag.func_74764_b("xpDropOffsetX") ? prefsTag.func_74769_h("xpDropOffsetX") : Config.forgeConfig.xpDropOffsetX.get().doubleValue();
        xpDropOffsetY = prefsTag.func_74764_b("xpDropOffsetY") ? prefsTag.func_74769_h("xpDropOffsetY") : Config.forgeConfig.xpDropOffsetY.get().doubleValue();
        xpDropSpawnDistance = prefsTag.func_74764_b("xpDropSpawnDistance") ? prefsTag.func_74769_h("xpDropSpawnDistance") : Config.forgeConfig.xpDropSpawnDistance.get().doubleValue();
        xpDropOpacityPerTime = prefsTag.func_74764_b("xpDropOpacityPerTime") ? prefsTag.func_74769_h("xpDropOpacityPerTime") : Config.forgeConfig.xpDropOpacityPerTime.get().doubleValue();
        xpDropMaxOpacity = prefsTag.func_74764_b("xpDropMaxOpacity") ? prefsTag.func_74769_h("xpDropMaxOpacity") : Config.forgeConfig.xpDropMaxOpacity.get().doubleValue();
        minXpGrow = prefsTag.func_74764_b("minXpGrow") ? prefsTag.func_74769_h("minXpGrow") : Config.forgeConfig.minXpGrow.get().doubleValue();
        xpDropDecayAge = prefsTag.func_74764_b("xpDropDecayAge") ? (int)Math.floor(prefsTag.func_74769_h("xpDropDecayAge")) : (int)Math.floor(Config.forgeConfig.xpDropDecayAge.get());
        maxLevel = prefsTag.func_74764_b("maxLevel") ? (int)Math.floor(Config.getConfig("maxLevel")) : (int)Math.floor(Config.forgeConfig.maxLevel.get().intValue());
        maxXp = prefsTag.func_74764_b("maxXp") ? (double)((int)Math.floor(Config.getConfig("maxXp"))) : XP.xpAtLevel(maxLevel);
        xpDropsAttachedToBar = prefsTag.func_74764_b("xpDropsAttachedToBar") ? prefsTag.func_74769_h("xpDropsAttachedToBar") != 0.0 : Config.forgeConfig.xpDropsAttachedToBar.get();
        xpBarAlwaysOn = prefsTag.func_74764_b("xpBarAlwaysOn") ? prefsTag.func_74769_h("xpBarAlwaysOn") != 0.0 : Config.forgeConfig.xpBarAlwaysOn.get();
        xpLeftDisplayAlwaysOn = prefsTag.func_74764_b("xpLeftDisplayAlwaysOn") ? prefsTag.func_74769_h("xpLeftDisplayAlwaysOn") != 0.0 : Config.forgeConfig.xpLeftDisplayAlwaysOn.get();
        showSkillsListAtCorner = prefsTag.func_74764_b("showSkillsListAtCorner") ? prefsTag.func_74769_h("showSkillsListAtCorner") != 0.0 : Config.forgeConfig.showSkillsListAtCorner.get();
        showXpDrops = prefsTag.func_74764_b("showXpDrops") ? prefsTag.func_74769_h("showXpDrops") != 0.0 : Config.forgeConfig.showXpDrops.get();
        stackXpDrops = prefsTag.func_74764_b("stackXpDrops") ? prefsTag.func_74769_h("stackXpDrops") != 0.0 : Config.forgeConfig.stackXpDrops.get();
        lvlUpScreenshot = prefsTag.func_74764_b("lvlUpScreenshot") ? prefsTag.func_74769_h("lvlUpScreenshot") != 0.0 : Config.forgeConfig.lvlUpScreenshot.get();
        lvlUpScreenshotShowSkills = prefsTag.func_74764_b("lvlUpScreenshotShowSkills") ? prefsTag.func_74769_h("lvlUpScreenshotShowSkills") != 0.0 : Config.forgeConfig.lvlUpScreenshotShowSkills.get();
        xpDropYLimit = !xpDropsAttachedToBar ? 999999999 : 0;
        if (barOffsetX < 0.0 || barOffsetX > 1.0) {
            barOffsetX = Config.forgeConfig.barOffsetX.get();
        }
        if (barOffsetY < 0.0 || barOffsetY > 1.0) {
            barOffsetY = Config.forgeConfig.barOffsetY.get();
        }
        if (xpDropOffsetX < 0.0 || xpDropOffsetX > 1.0) {
            xpDropOffsetX = Config.forgeConfig.xpDropOffsetX.get();
        }
        if (xpDropOffsetY < 0.0 || xpDropOffsetY > 1.0) {
            xpDropOffsetY = Config.forgeConfig.xpDropOffsetY.get();
        }
        if (veinBarOffsetX < 0.0 || veinBarOffsetX > 1.0) {
            veinBarOffsetX = Config.forgeConfig.veinBarOffsetX.get();
        }
        if (veinBarOffsetY < 0.0 || veinBarOffsetY > 1.0) {
            veinBarOffsetY = Config.forgeConfig.veinBarOffsetY.get();
        }
        if (xpDropSpawnDistance < 0.0 || xpDropSpawnDistance > 1000.0) {
            xpDropSpawnDistance = Config.forgeConfig.xpDropSpawnDistance.get();
        }
        if (xpDropOpacityPerTime < 0.0 || xpDropOpacityPerTime > 255.0) {
            xpDropOpacityPerTime = Config.forgeConfig.xpDropOpacityPerTime.get();
        }
        if (xpDropMaxOpacity < 0.0 || xpDropMaxOpacity > 255.0) {
            xpDropMaxOpacity = Config.forgeConfig.xpDropMaxOpacity.get();
        }
        if (xpDropDecayAge < 0 || xpDropDecayAge > 5000) {
            xpDropDecayAge = (int)Math.floor(Config.forgeConfig.xpDropDecayAge.get());
        }
        if (minXpGrow < 0.01 || minXpGrow > 100.0) {
            minXpGrow = Config.getConfig("minXpGrow");
        }
        biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        maxVeinCharge = Config.getConfig("maxVeinCharge");
        veinMaxBlocks = (int)Config.getConfig("veinMaxBlocks");
    }

    public static void sendLvlUp(int level, Skill skill) {
        player = Minecraft.func_71410_x().field_71439_g;
        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelUp", new Object[]{level, new TranslationTextComponent("pmmo." + skill.name().toLowerCase()).getString()}).func_240703_c_(XP.getSkillStyle(skill)), false);
        if (skill == Skill.SWIMMING && level - 1 < Config.forgeConfig.nightvisionUnlockLevel.get() && level >= Config.forgeConfig.nightvisionUnlockLevel.get()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.nightvisionUnlocked").func_240703_c_(XP.getSkillStyle(skill)), true);
        }
        guiWasOn = guiOn;
        if (lvlUpScreenshotShowSkills) {
            guiOn = true;
        }
        if (lvlUpScreenshot) {
            screenshots.add(player.func_145748_c_().getString() + " " + skill.name().toLowerCase() + " " + level);
        }
        NetworkHandler.sendToServer(new MessageLevelUp(skill.getValue(), level));
    }

    public static void makeXpDrop(double xp, Skill skillIn, int cooldown, double gainedXp, boolean skip) {
        xpDropWasStacked = false;
        if (skill.equals((Object)Skill.INVALID_SKILL)) {
            skill = skillIn;
        }
        if (skills.get((Object)skillIn) == null) {
            skills.put(skillIn, new ASkill(xp, XP.levelAtXpDecimal(xp), xp, XP.levelAtXpDecimal(xp)));
        }
        aSkill = skills.get((Object)skillIn);
        if (gainedXp == 0.0) {
            XPOverlayGUI.aSkill.goalPos = XPOverlayGUI.aSkill.pos = XP.levelAtXpDecimal(xp);
            XPOverlayGUI.aSkill.xp = xp;
            XPOverlayGUI.aSkill.goalXp = xp;
            XPOverlayGUI.cooldown = cooldown;
            for (int i = 0; i < xpDrops.size(); ++i) {
                if (XPOverlayGUI.xpDrops.get((int)i).skill != skillIn) continue;
                xpDrops.remove(i);
                i = 0;
            }
        } else if (stackXpDrops && xpDrops.size() > 0) {
            for (XpDrop xpDrop : xpDrops) {
                if (xpDrop.skill != skillIn || xpDrop.age >= xpDropDecayAge && !(xpDrop.Y > 0.0)) continue;
                xpDrop.gainedXp += gainedXp;
                xpDrop.startXp += gainedXp;
                if (XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).age > xpDropDecayAge - 25) {
                    XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).age = xpDropDecayAge - 25;
                }
                xpDropWasStacked = true;
            }
        }
        if (!xpDropWasStacked && gainedXp != 0.0) {
            if (xpDrops.size() > 0 && XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).Y > 75.0) {
                xpDrops.add(new XpDrop(0, XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).Y + 25.0, skillIn, xp, gainedXp, skip));
            } else {
                xpDrops.add(new XpDrop(0, xpDropSpawnDistance, skillIn, xp, gainedXp, skip));
            }
        }
        if (!skip) {
            XPOverlayGUI.cooldown = cooldown;
        }
        levelGap = 0;
        skillGap = 0;
        xpGap = 0;
        skills.forEach((thisSkill, thisASkill) -> {
            if (XPOverlayGUI.skills.get((Object)((Object)((Object)thisSkill))).pos >= (double)maxLevel) {
                if (levelGap < fontRenderer.func_78256_a("" + maxLevel)) {
                    levelGap = fontRenderer.func_78256_a("" + maxLevel);
                }
            } else if (levelGap < fontRenderer.func_78256_a(DP.dp(XP.levelAtXpDecimal(XPOverlayGUI.skills.get((Object)((Object)((Object)thisSkill))).goalXp)))) {
                levelGap = fontRenderer.func_78256_a(DP.dp(XP.levelAtXpDecimal(XPOverlayGUI.skills.get((Object)((Object)((Object)thisSkill))).goalXp)));
            }
            if (skillGap < fontRenderer.func_78256_a(new TranslationTextComponent("pmmo." + thisSkill.name().toLowerCase()).getString())) {
                skillGap = fontRenderer.func_78256_a(new TranslationTextComponent("pmmo." + thisSkill.name().toLowerCase()).getString());
            }
            if (xpGap < fontRenderer.func_78256_a(DP.dp(XPOverlayGUI.skills.get((Object)((Object)((Object)thisSkill))).goalXp))) {
                xpGap = fontRenderer.func_78256_a(DP.dprefix(XPOverlayGUI.skills.get((Object)((Object)((Object)thisSkill))).goalXp));
            }
        });
    }

    public static void clearXP() {
        skills = new HashMap<Skill, ASkill>();
        xpDrops = new ArrayList();
        xp = 0.0;
        skill = Skill.INVALID_SKILL;
        levelGap = 0;
        skillGap = 0;
        xpGap = 0;
    }

    static {
        levelGap = 0;
        xpDropDecayAge = 0;
        xpDropOffset = 0.0;
        xpDropOffsetCap = 0.0;
        minXpGrow = 0.2;
        barOffsetX = 0.0;
        barOffsetY = 0.0;
        xpDropOffsetX = 0.0;
        xpDropOffsetY = 0.0;
        xpDropSpawnDistance = 0.0;
        xpDropOpacityPerTime = 0.0;
        xpDropMaxOpacity = 0.0;
        biomePenaltyMultiplier = 0.0;
        maxVeinCharge = 64.0;
        theme = 2;
        themePos = 1;
        listIndex = 0;
        xpDropYLimit = 0;
        skillName = "none";
        stackXpDrops = true;
        init = false;
        showSkillsListAtCorner = true;
        showXpDrops = true;
        guiKey = false;
        veinKey = false;
        guiPressed = false;
        xpDropsAttachedToBar = true;
        xpDrops = new ArrayList();
        mc = Minecraft.func_71410_x();
        player = XPOverlayGUI.mc.field_71439_g;
        skills = new HashMap<Skill, ASkill>();
        skill = Skill.INVALID_SKILL;
        tempSkill = Skill.INVALID_SKILL;
        fontRenderer = XPOverlayGUI.mc.field_71466_p;
        lastBonusUpdate = System.nanoTime();
        lastVeinBlockUpdate = System.nanoTime();
        veinPos = -1000.0;
        lastVeinPos = -1000.0;
        addAmount = 0.0;
        lossAmount = 0.0;
        lastBlockRegKey = "";
        lastBlockTransKey = "";
        lastToolHeld = Items.field_190931_a;
        screenshots = new HashSet<String>();
        guiWasOn = false;
        guiOn = false;
        isVeining = false;
        canBreak = true;
        canVein = false;
        lookingAtBlock = false;
        metToolReq = true;
    }
}

