/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageLevelUp {
    private static final boolean broadcastMilestone = Config.forgeConfig.broadcastMilestone.get();
    private static final boolean levelUpFirework = Config.forgeConfig.levelUpFirework.get();
    private static final boolean milestoneLevelUpFirework = Config.forgeConfig.milestoneLevelUpFirework.get();
    private static final int levelsPerMilestone = Config.forgeConfig.levelsPerMilestone.get();
    private int skill;
    private int level;

    public MessageLevelUp(int skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public MessageLevelUp() {
    }

    public static MessageLevelUp decode(PacketBuffer buf) {
        MessageLevelUp packet = new MessageLevelUp();
        packet.skill = buf.readInt();
        packet.level = buf.readInt();
        return packet;
    }

    public static void encode(MessageLevelUp packet, PacketBuffer buf) {
        buf.writeInt(packet.skill);
        buf.writeInt(packet.level);
    }

    public static void handlePacket(MessageLevelUp packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            CompoundNBT prefsTag = XP.getPreferencesTag((PlayerEntity)player);
            Skill skill = Skill.getSkill(packet.skill);
            String skillName = skill.name().toLowerCase();
            Vector3d playerPos = player.func_213303_ch();
            if (levelUpFirework && (!prefsTag.func_74764_b("spawnFireworksCausedByMe") || prefsTag.func_74769_h("spawnFireworksCausedByMe") != 0.0)) {
                XP.spawnRocket(player.field_70170_p, player.func_213303_ch(), skill);
            }
            LogHandler.LOGGER.info(player.func_145748_c_().getString() + " has reached level " + packet.level + " in " + skillName + "! [" + player.field_70170_p.func_234922_V_().func_240901_a_().toString() + "|x:" + DP.dp(playerPos.func_82615_a()) + "|y:" + DP.dp(playerPos.func_82617_b()) + "|z:" + DP.dp(playerPos.func_82616_c()) + "]");
            if (packet.level % levelsPerMilestone == 0 && broadcastMilestone) {
                player.field_71133_b.func_184103_al().func_181057_v().forEach(otherPlayer -> {
                    if (otherPlayer.func_110124_au() != player.func_110124_au()) {
                        CompoundNBT otherPrefsTag = XP.getPreferencesTag((PlayerEntity)otherPlayer);
                        otherPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.milestoneLevelUp", new Object[]{player.func_145748_c_(), packet.level, new TranslationTextComponent("pmmo." + skillName)}).func_240703_c_(XP.getSkillStyle(skill)), false);
                        if (milestoneLevelUpFirework && (!otherPrefsTag.func_74764_b("spawnFireworksCausedByOthers") || otherPrefsTag.func_74769_h("spawnFireworksCausedByOthers") != 0.0)) {
                            XP.spawnRocket(otherPlayer.field_70170_p, otherPlayer.func_213303_ch(), skill);
                        }
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

