/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.proxy.ServerHandler;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateNBT {
    public CompoundNBT reqPackage = new CompoundNBT();
    public int type;

    public MessageUpdateNBT(CompoundNBT theNBT, int type) {
        this.type = type;
        this.reqPackage = theNBT;
    }

    MessageUpdateNBT() {
    }

    public static MessageUpdateNBT decode(PacketBuffer buf) {
        MessageUpdateNBT packet = new MessageUpdateNBT();
        packet.reqPackage = buf.func_150793_b();
        packet.type = buf.readInt();
        return packet;
    }

    public static void encode(MessageUpdateNBT packet, PacketBuffer buf) {
        buf.func_150786_a(packet.reqPackage);
        buf.writeInt(packet.type);
    }

    public static void handlePacket(MessageUpdateNBT packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (packet.type) {
                case 0: 
                case 1: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        ClientHandler.updateNBTTag(packet);
                        break;
                    }
                    ServerHandler.updateNBTTag(packet, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                    break;
                }
                case 2: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        Config.config = NBTHelper.nbtToMap(packet.reqPackage);
                        WorldTickHandler.refreshVein();
                        break;
                    }
                    LogHandler.LOGGER.error("TYPE " + packet.type + " UPDATE NBT PACKET HAS BEEN SENT TO SERVER", (Object)packet);
                    break;
                }
                case 3: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        UUID uuid = UUID.fromString(packet.reqPackage.func_74779_i("UUID"));
                        packet.reqPackage.func_82580_o("UUID");
                        String name = packet.reqPackage.func_74779_i("name");
                        packet.reqPackage.func_82580_o("name");
                        if (!XP.playerNames.containsKey(uuid)) {
                            XP.playerNames.put(uuid, name);
                        }
                        XP.skills.put(uuid, NBTHelper.nbtToMap(packet.reqPackage));
                        ClientHandler.openStats(uuid);
                        break;
                    }
                    LogHandler.LOGGER.error("TYPE " + packet.type + " UPDATE NBT PACKET HAS BEEN SENT TO SERVER", (Object)packet);
                    break;
                }
                default: {
                    LogHandler.LOGGER.error("WRONG SYNC ID AT NBT UPDATE PACKET", (Object)packet);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

