/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.util.LogHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateReq {
    private CompoundNBT reqPackage = new CompoundNBT();
    private int type;

    public MessageUpdateReq(Map<JType, Map<String, Map<String, Object>>> theMap, int type) {
        this.type = type;
        for (JType jType : theMap.keySet()) {
            this.reqPackage.func_218657_a(jType.toString(), (INBT)new CompoundNBT());
            for (String topKey : theMap.get((Object)jType).keySet()) {
                this.reqPackage.func_74775_l(jType.toString()).func_218657_a(topKey, (INBT)new CompoundNBT());
                for (String botKey : theMap.get((Object)jType).get(topKey).keySet()) {
                    Object value = theMap.get((Object)jType).get(topKey).get(botKey);
                    if (botKey.equals("salvageItem")) {
                        this.reqPackage.func_74775_l(jType.toString()).func_74775_l(topKey).func_74778_a(botKey, (String)value);
                        continue;
                    }
                    this.reqPackage.func_74775_l(jType.toString()).func_74775_l(topKey).func_74780_a(botKey, ((Double)value).doubleValue());
                }
            }
        }
    }

    MessageUpdateReq() {
    }

    public static MessageUpdateReq decode(PacketBuffer buf) {
        MessageUpdateReq packet = new MessageUpdateReq();
        packet.reqPackage = buf.func_150793_b();
        packet.type = buf.readInt();
        return packet;
    }

    public static void encode(MessageUpdateReq packet, PacketBuffer buf) {
        buf.func_150786_a(packet.reqPackage);
        buf.writeInt(packet.type);
    }

    public static void handlePacket(MessageUpdateReq packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            HashMap<JType, Map<String, Map<String, Object>>> newPackage = new HashMap<JType, Map<String, Map<String, Object>>>();
            for (String reqKey : packet.reqPackage.func_150296_c()) {
                JType jType = JType.getJType(reqKey);
                newPackage.put(jType, new HashMap());
                for (String topKey : packet.reqPackage.func_74775_l(reqKey).func_150296_c()) {
                    ((Map)newPackage.get((Object)jType)).put(topKey, new HashMap());
                    for (String botKey : packet.reqPackage.func_74775_l(reqKey).func_74775_l(topKey).func_150296_c()) {
                        if (botKey.equals("salvageItem")) {
                            ((Map)((Map)newPackage.get((Object)jType)).get(topKey)).put(botKey, packet.reqPackage.func_74775_l(reqKey).func_74775_l(topKey).func_74779_i(botKey));
                            continue;
                        }
                        ((Map)((Map)newPackage.get((Object)jType)).get(topKey)).put(botKey, packet.reqPackage.func_74775_l(reqKey).func_74775_l(topKey).func_74769_h(botKey));
                    }
                }
            }
            switch (packet.type) {
                case 0: {
                    JsonConfig.data = newPackage;
                    break;
                }
                default: {
                    LogHandler.LOGGER.error("ERROR MessageUpdateReq WRONG TYPE");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

