/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.proxy;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageUpdateNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientHandler {
    public static final KeyBinding SHOW_GUI = new KeyBinding("key.pmmo.showGui", 258, "category.pmmo");
    public static final KeyBinding TOGGLE_TOOLTIP = new KeyBinding("key.pmmo.toggleTooltip", 295, "category.pmmo");
    public static final KeyBinding VEIN_KEY = new KeyBinding("key.pmmo.vein", 96, "category.pmmo");
    public static final KeyBinding OPEN_MENU = new KeyBinding("key.pmmo.openMenu", 80, "category.pmmo");
    public static final KeyBinding OPEN_SETTINGS = new KeyBinding("key.pmmo.openSettings", -1, "category.pmmo");
    public static final KeyBinding OPEN_SKILLS = new KeyBinding("key.pmmo.openSkills", -1, "category.pmmo");
    public static final KeyBinding OPEN_GLOSSARY = new KeyBinding("key.pmmo.openGlossary", -1, "category.pmmo");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new XPOverlayGUI());
        ClientRegistry.registerKeyBinding((KeyBinding)SHOW_GUI);
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE_TOOLTIP);
        ClientRegistry.registerKeyBinding((KeyBinding)VEIN_KEY);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_MENU);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_SETTINGS);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_SKILLS);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_GLOSSARY);
    }

    public static void updateNBTTag(MessageUpdateNBT packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        CompoundNBT newPackage = packet.reqPackage;
        HashSet keySet = new HashSet(newPackage.func_150296_c());
        switch (packet.type) {
            case 0: {
                CompoundNBT prefsTag = XP.getPreferencesTag((PlayerEntity)player);
                for (String tag : keySet) {
                    prefsTag.func_74780_a(tag, newPackage.func_74769_h(tag));
                }
                AttributeHandler.updateAll((PlayerEntity)player);
                XPOverlayGUI.doInit();
                break;
            }
            case 1: {
                CompoundNBT abilitiesTag = XP.getAbilitiesTag((PlayerEntity)player);
                for (String tag : keySet) {
                    abilitiesTag.func_74780_a(tag, newPackage.func_74769_h(tag));
                }
                break;
            }
            default: {
                LogHandler.LOGGER.error("ERROR MessageUpdateNBT WRONG TYPE");
            }
        }
    }

    public static void openStats(UUID uuid) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(uuid, (ITextComponent)new TranslationTextComponent("pmmo.stats"), JType.STATS, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
    }

    public static void syncPrefsToServer() {
        NetworkHandler.sendToServer(new MessageUpdateNBT(XP.getPreferencesTag((PlayerEntity)Minecraft.func_71410_x().field_71439_g), 0));
    }
}

