/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeMod;

public class AttributeHandler {
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");
    private static double levelsPerOneReach;
    private static double levelsPerHeart;
    private static double levelsPerDamage;
    private static double maxSpeedBoost;
    private static double speedBoostPerLevel;
    private static int maxExtraHeartBoost;
    private static double maxExtraReachBoost;
    private static double maxExtraDamageBoost;

    public static void init() {
        levelsPerOneReach = Config.getConfig("levelsPerOneReach");
        levelsPerHeart = Config.getConfig("levelsPerHeart");
        levelsPerDamage = Config.getConfig("levelsPerDamage");
        maxSpeedBoost = Config.getConfig("maxSpeedBoost");
        speedBoostPerLevel = Config.getConfig("speedBoostPerLevel");
        maxExtraHeartBoost = (int)Config.getConfig("maxExtraHeartBoost");
        maxExtraReachBoost = Config.getConfig("maxExtraReachBoost");
        maxExtraDamageBoost = Config.getConfig("maxExtraDamageBoost");
    }

    public static void updateAll(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            WorldTickHandler.updateVein(player, 0.0);
        }
        AttributeHandler.updateReach(player);
        AttributeHandler.updateHP(player);
        AttributeHandler.updateDamage(player);
    }

    public static double getReach(PlayerEntity player) {
        ModifiableAttributeInstance reachAttribute = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute.func_111127_a(reachModifierID) == null) {
            return reachAttribute.func_111125_b();
        }
        return reachAttribute.func_111125_b() + reachAttribute.func_111127_a(reachModifierID).func_111164_d();
    }

    public static void updateReach(PlayerEntity player) {
        ModifiableAttributeInstance reachAttribute = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        double buildLevel = XP.getLevel(Skill.BUILDING, player);
        double reach = -0.91 + buildLevel / levelsPerOneReach;
        double maxReachPref = prefsTag.func_74769_h("maxExtraReachBoost");
        if (reach > maxExtraReachBoost) {
            reach = maxExtraReachBoost;
        }
        if (reach > maxReachPref && prefsTag.func_74764_b("maxExtraReachBoost")) {
            reach = maxReachPref;
        }
        if (reachAttribute.func_111127_a(reachModifierID) == null || reachAttribute.func_111127_a(reachModifierID).func_111164_d() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, AttributeModifier.Operation.ADDITION);
            reachAttribute.func_188479_b(reachModifierID);
            reachAttribute.func_233769_c_(reachModifier);
        }
    }

    public static double getBaseSpeed(PlayerEntity player) {
        return player.func_110148_a(Attributes.field_233821_d_).func_111125_b();
    }

    public static double getSpeedBoost(PlayerEntity player) {
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        double agilityLevel = XP.getLevel(Skill.AGILITY, player);
        double maxSpeedBoostPref = prefsTag.func_74769_h("maxSpeedBoost");
        double speedBoost = agilityLevel * speedBoostPerLevel;
        double baseValue = AttributeHandler.getBaseSpeed(player);
        double maxSpeed = baseValue * (maxSpeedBoost / 100.0);
        if (maxSpeed > baseValue * (maxSpeedBoostPref / 100.0) && prefsTag.func_74764_b("maxSpeedBoost")) {
            maxSpeed = baseValue * (maxSpeedBoostPref / 100.0);
        }
        if (speedBoost > maxSpeed) {
            speedBoost = maxSpeed;
        }
        return speedBoost;
    }

    public static void updateSpeed(PlayerEntity player) {
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        double speedBoost = AttributeHandler.getSpeedBoost(player);
        if (speedBoost > 0.0 && (speedAttribute.func_111127_a(speedModifierID) == null || speedAttribute.func_111127_a(speedModifierID).func_111164_d() != speedBoost)) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_233769_c_(speedModifier);
        }
    }

    public static void resetSpeed(PlayerEntity player) {
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        speedAttribute.func_188479_b(speedModifierID);
    }

    public static void updateHP(PlayerEntity player) {
        ModifiableAttributeInstance hpAttribute = player.func_110148_a(Attributes.field_233818_a_);
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        double enduranceLevel = XP.getLevel(Skill.ENDURANCE, player);
        int heartBoost = (int)Math.floor(enduranceLevel / levelsPerHeart) * 2;
        int maxHPPref = (int)Math.floor(prefsTag.func_74769_h("maxExtraHeartBoost") * 2.0);
        if (heartBoost > maxExtraHeartBoost * 2) {
            heartBoost = maxExtraHeartBoost * 2;
        }
        if (heartBoost > maxHPPref && prefsTag.func_74764_b("maxExtraHeartBoost")) {
            heartBoost = maxHPPref;
        }
        AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Endurance Level", (double)heartBoost, AttributeModifier.Operation.ADDITION);
        hpAttribute.func_188479_b(hpModifierID);
        hpAttribute.func_233769_c_(hpModifier);
    }

    public static void updateDamage(PlayerEntity player) {
        ModifiableAttributeInstance damageAttribute = player.func_110148_a(Attributes.field_233823_f_);
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        double maxDamagePref = prefsTag.func_74769_h("maxExtraDamageBoost");
        double combatLevel = XP.getLevel(Skill.COMBAT, player);
        double damageBoost = combatLevel / levelsPerDamage;
        if (damageBoost > maxExtraDamageBoost) {
            damageBoost = maxExtraDamageBoost;
        }
        if (damageBoost > maxDamagePref && prefsTag.func_74764_b("maxExtraDamageBoost")) {
            damageBoost = maxDamagePref;
        }
        AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Combat Level", damageBoost, AttributeModifier.Operation.ADDITION);
        damageAttribute.func_188479_b(damageModifierID);
        damageAttribute.func_233769_c_(damageModifier);
    }

    public static void updateHP(MobEntity mob, float bonus) {
        ModifiableAttributeInstance hpAttribute = mob.func_110148_a(Attributes.field_233818_a_);
        if (hpAttribute != null) {
            boolean wasMaxHealth = mob.func_110143_aJ() == mob.func_110138_aP();
            double maxMobHPBoost = Config.forgeConfig.maxMobHPBoost.get();
            double mobHPBoostPerPowerLevel = Config.forgeConfig.mobHPBoostPerPowerLevel.get();
            if (!(mob instanceof AnimalEntity)) {
                bonus = (float)((double)bonus * mobHPBoostPerPowerLevel);
            }
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "hpBonus"))) > maxMobHPBoost) {
                bonus = (float)maxMobHPBoost;
            }
            AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            hpAttribute.func_188479_b(hpModifierID);
            hpAttribute.func_233769_c_(hpModifier);
            if (wasMaxHealth) {
                mob.func_70606_j(mob.func_110138_aP());
            }
        }
    }

    public static void updateDamage(MobEntity mob, float bonus) {
        ModifiableAttributeInstance damageAttribute = mob.func_110148_a(Attributes.field_233823_f_);
        if (damageAttribute != null) {
            double maxMobDamageBoost = Config.forgeConfig.maxMobDamageBoost.get();
            double mobDamageBoostPerPowerLevel = Config.forgeConfig.mobDamageBoostPerPowerLevel.get();
            bonus = (float)((double)bonus * mobDamageBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "damageBonus"))) > maxMobDamageBoost) {
                bonus = (float)maxMobDamageBoost;
            }
            AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            damageAttribute.func_188479_b(damageModifierID);
            damageAttribute.func_233769_c_(damageModifier);
        }
    }

    public static void updateSpeed(MobEntity mob, float bonus) {
        ModifiableAttributeInstance speedAttribute = mob.func_110148_a(Attributes.field_233821_d_);
        if (speedAttribute != null && !(mob instanceof AnimalEntity)) {
            double maxMobSpeedBoost = Config.forgeConfig.maxMobSpeedBoost.get();
            double mobSpeedBoostPerPowerLevel = Config.forgeConfig.mobSpeedBoostPerPowerLevel.get();
            bonus = (float)((double)bonus * mobSpeedBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "speedBonus"))) > maxMobSpeedBoost) {
                bonus = (float)maxMobSpeedBoost;
            }
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Movement Speed Boost thanks to Nearby Player Power Level", (double)(bonus / 100.0f), AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_233769_c_(speedModifier);
        }
    }

    private static double getBiomeMobMultiplier(MobEntity mob, String type) {
        String biomeKey = mob.field_70170_p.func_226691_t_(XP.vecToBlock(mob.func_213303_ch())).getRegistryName().toString();
        Map<String, Object> theMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(biomeKey);
        double multiplier = 1.0;
        if (theMap != null && theMap.containsKey(type)) {
            multiplier = (Double)theMap.get(type);
        }
        return multiplier;
    }
}

