/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public enum Skill {
    INVALID_SKILL(0),
    MINING(1),
    BUILDING(2),
    EXCAVATION(3),
    WOODCUTTING(4),
    FARMING(5),
    AGILITY(6),
    ENDURANCE(7),
    COMBAT(8),
    ARCHERY(9),
    SMITHING(10),
    FLYING(11),
    SWIMMING(12),
    FISHING(13),
    CRAFTING(14),
    MAGIC(15),
    SLAYER(16),
    HUNTER(17),
    FLETCHING(18),
    TAMING(19),
    ENGINEERING(20),
    BLOOD_MAGIC(21),
    ASTRAL_MAGIC(22),
    GOOD_MAGIC(23),
    EVIL_MAGIC(24),
    ARCANE_MAGIC(25),
    ELEMENTAL(26),
    EARTH(27),
    WATER(28),
    AIR(29),
    FIRE(30),
    LIGHTNING(31),
    VOID(32),
    THAUMATIC(33),
    SUMMONING(34),
    INVENTION(35),
    RUNECRAFTING(36),
    PRAYER(37),
    COOKING(38),
    FIREMAKING(39),
    AFKING(40),
    TRADING(41),
    BANKSTANDING(42),
    SAILING(43);

    public static final Map<Skill, Integer> skillMap;
    public static final Map<Integer, Skill> intMap;
    public static final Map<String, Skill> stringMap;
    private final int value;

    public String toString() {
        return this.name().toLowerCase();
    }

    private Skill(int i) {
        this.value = i;
    }

    public static int getInt(String i) {
        if (stringMap.get(i.toLowerCase()) != null) {
            return stringMap.get(i.toLowerCase()).getValue();
        }
        return 0;
    }

    public static String getString(int i) {
        for (Skill theEnum : Skill.values()) {
            if (theEnum.value != i) continue;
            return theEnum.name().toLowerCase();
        }
        return "none";
    }

    public static Skill getSkill(String input) {
        for (Skill theEnum : Skill.values()) {
            if (!theEnum.name().toLowerCase().equals(input.toLowerCase())) continue;
            return theEnum;
        }
        return INVALID_SKILL;
    }

    public static Skill getSkill(int input) {
        for (Skill theEnum : Skill.values()) {
            if (theEnum.value != input) continue;
            return theEnum;
        }
        return INVALID_SKILL;
    }

    public int getValue() {
        return this.value;
    }

    public int getLevel(PlayerEntity player) {
        return XP.getLevel(this, player);
    }

    public double getLevelDecimal(PlayerEntity player) {
        return XP.getLevelDecimal(this, player);
    }

    public double getXp(PlayerEntity player) {
        return XP.getXp(this, player);
    }

    public void setLevel(ServerPlayerEntity player, double setAmount) {
        this.setXp(player, XP.xpAtLevelDecimal(setAmount));
    }

    public void setXp(ServerPlayerEntity player, double setAmount) {
        if (this != INVALID_SKILL) {
            CompoundNBT skillsTag = XP.getSkillsTag((PlayerEntity)player);
            double maxXp = Config.getConfig("maxXp");
            if (setAmount > maxXp) {
                setAmount = maxXp;
            }
            if (setAmount < 0.0) {
                setAmount = 0.0;
            }
            skillsTag.func_74780_a(this.name().toLowerCase(), setAmount);
            AttributeHandler.updateAll((PlayerEntity)player);
            XP.updateRecipes(player);
            NetworkHandler.sendToPlayer(new MessageXp(setAmount, this.getValue(), 0.0, false), player);
        } else {
            LogHandler.LOGGER.error("Invalid skill at method setXp");
        }
    }

    public void addLevel(ServerPlayerEntity player, double addAmount, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(this.getLevelDecimal((PlayerEntity)player) + addAmount) - this.getXp((PlayerEntity)player);
        this.addXp(player, missingXp, ignoreBonuses);
    }

    public void addXp(ServerPlayerEntity player, double addAmount, boolean ignoreBonuses) {
        double newLevelXp;
        CompoundNBT skillsTag = XP.getSkillsTag((PlayerEntity)player);
        double playerXp = this.getXp((PlayerEntity)player);
        double maxXp = Config.getConfig("maxXp");
        String skillName = this.name().toLowerCase();
        if (!ignoreBonuses) {
            addAmount *= XP.getMultiplier((PlayerEntity)player, this);
        }
        if ((newLevelXp = addAmount + playerXp) > maxXp) {
            newLevelXp = maxXp;
        }
        if (newLevelXp < 0.0) {
            newLevelXp = 0.0;
        }
        if (newLevelXp > playerXp) {
            XP.awardXp((PlayerEntity)player, this, "commandAdd", addAmount, false, true);
        } else {
            NetworkHandler.sendToPlayer(new MessageXp(newLevelXp, this.getValue(), 0.0, true), player);
        }
        skillsTag.func_74780_a(skillName, newLevelXp);
        AttributeHandler.updateAll((PlayerEntity)player);
        XP.updateRecipes(player);
    }

    static {
        skillMap = new HashMap<Skill, Integer>();
        intMap = new HashMap<Integer, Skill>();
        stringMap = new HashMap<String, Skill>();
        for (Skill skill : Skill.values()) {
            skillMap.put(skill, skill.value);
            intMap.put(skill.value, skill);
            stringMap.put(skill.toString(), skill);
        }
    }
}

