/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import java.util.Locale;

public class DP {
    public static String dprefix(Float input) {
        return DP.dprefix(input.doubleValue());
    }

    public static String dprefix(Double input) {
        char prefix = ' ';
        if (input >= 10000.0 && input < 1000000.0) {
            input = input / 1000.0;
            prefix = 'k';
        } else if (input >= 1000000.0 && input < 1.0E9) {
            input = input / 1000000.0;
            prefix = 'm';
        } else if (input >= 1.0E9) {
            input = input / 1.0E9;
            prefix = 'b';
        }
        if (prefix == ' ') {
            return String.format(Locale.ENGLISH, "%.2f", input);
        }
        return String.format(Locale.ENGLISH, "%.3f", input) + prefix;
    }

    public static String dp(Float input) {
        return DP.dp(input.doubleValue());
    }

    public static String dp(Double input) {
        return String.format(Locale.ENGLISH, "%.2f", input);
    }

    public static String dpCustom(Double input, int decPlaces) {
        return String.format(Locale.ENGLISH, "%." + decPlaces + "f", input);
    }

    public static String dpSoft(Double input) {
        if (input % 1.0 == 0.0) {
            return String.format(Locale.ENGLISH, "%.0f", input);
        }
        if (input * 10.0 % 1.0 == 0.0) {
            return String.format(Locale.ENGLISH, "%.1f", input);
        }
        return String.format(Locale.ENGLISH, "%.2f", input);
    }

    public static double map(double input, double inLow, double inHigh, double outLow, double outHigh) {
        if (input < inLow) {
            input = inLow;
        }
        if (input > inHigh) {
            input = inHigh;
        }
        if (inLow == inHigh || outLow == outHigh) {
            return outHigh;
        }
        return (input - inLow) / (inHigh - inLow) * (outHigh - outLow) + outLow;
    }
}

