/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.curios.Curios;
import harmonised.pmmo.events.PlayerConnectedHandler;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageUpdateNBT;
import harmonised.pmmo.network.MessageUpdateReq;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.PMMOFireworkEntity;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.LogHandler;
import harmonised.pmmo.util.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class XP {
    private static Map<Material, String> materialHarvestTool = new HashMap<Material, String>();
    private static Map<Skill, Integer> skillColors = new HashMap<Skill, Integer>();
    public static Set<UUID> isVeining = new HashSet<UUID>();
    public static Map<Skill, Style> skillStyle = new HashMap<Skill, Style>();
    public static Map<String, Style> textStyle = new HashMap<String, Style>();
    public static Map<UUID, Map<String, Double>> skills = new HashMap<UUID, Map<String, Double>>();
    public static Map<UUID, String> playerNames = new HashMap<UUID, String>();
    private static Map<UUID, String> lastBiome = new HashMap<UUID, String>();
    private static double globalMultiplier = Config.forgeConfig.globalMultiplier.get();
    private static int debugInt = 0;
    private static boolean alwaysDropWornItems = Config.forgeConfig.alwaysDropWornItems.get();

    public static void initValues() {
        skillColors.put(Skill.MINING, 65535);
        skillColors.put(Skill.BUILDING, 65535);
        skillColors.put(Skill.EXCAVATION, 15112448);
        skillColors.put(Skill.WOODCUTTING, 16753434);
        skillColors.put(Skill.FARMING, 58880);
        skillColors.put(Skill.AGILITY, 0x66CC66);
        skillColors.put(Skill.ENDURANCE, 0xCC0000);
        skillColors.put(Skill.COMBAT, 0xFF3300);
        skillColors.put(Skill.ARCHERY, 0xFFFF00);
        skillColors.put(Skill.SMITHING, 0xF0F0F0);
        skillColors.put(Skill.FLYING, 0xCCCCFF);
        skillColors.put(Skill.SWIMMING, 0x3366FF);
        skillColors.put(Skill.FISHING, 52479);
        skillColors.put(Skill.CRAFTING, 0xFF9900);
        skillColors.put(Skill.MAGIC, 255);
        skillColors.put(Skill.SLAYER, 0xFFFFFF);
        skillColors.put(Skill.HUNTER, 13596693);
        skillColors.put(Skill.FLETCHING, 16750336);
        skillColors.put(Skill.TAMING, 0xFFFFFF);
        skillColors.put(Skill.ENGINEERING, 0xFFFFFF);
        skillStyle.put(Skill.MINING, Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA));
        skillStyle.put(Skill.BUILDING, Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA));
        skillStyle.put(Skill.EXCAVATION, Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        skillStyle.put(Skill.WOODCUTTING, Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        skillStyle.put(Skill.FARMING, Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
        skillStyle.put(Skill.AGILITY, Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
        skillStyle.put(Skill.ENDURANCE, Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED));
        skillStyle.put(Skill.COMBAT, Style.field_240709_b_.func_240712_a_(TextFormatting.RED));
        skillStyle.put(Skill.ARCHERY, Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW));
        skillStyle.put(Skill.SMITHING, Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
        skillStyle.put(Skill.FLYING, Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
        skillStyle.put(Skill.SWIMMING, Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA));
        skillStyle.put(Skill.FISHING, Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA));
        skillStyle.put(Skill.CRAFTING, Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        skillStyle.put(Skill.MAGIC, Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE));
        skillStyle.put(Skill.SLAYER, Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
        skillStyle.put(Skill.HUNTER, Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        skillStyle.put(Skill.FLETCHING, Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        skillStyle.put(Skill.TAMING, Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE));
        skillStyle.put(Skill.ENGINEERING, Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE));
        textStyle.put("red", Style.field_240709_b_.func_240712_a_(TextFormatting.RED));
        textStyle.put("green", Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
        textStyle.put("yellow", Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW));
        textStyle.put("grey", Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
        textStyle.put("blue", Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE));
        PlayerConnectedHandler.lapisPatreons.add(UUID.fromString("e4c7e475-c1ff-4f94-956c-ac5be02ce04a"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("8eb0578d-c113-49d3-abf6-a6d36f6d1116"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("2ea5efa1-756b-4c9e-9605-7f53830d6cfa"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("0bc51f06-9906-41ea-9fb4-7e9be169c980"));
        materialHarvestTool.put(Material.field_151574_g, "pickaxe");
        materialHarvestTool.put(Material.field_151592_s, "pickaxe");
        materialHarvestTool.put(Material.field_151588_w, "pickaxe");
        materialHarvestTool.put(Material.field_151573_f, "pickaxe");
        materialHarvestTool.put(Material.field_151598_x, "pickaxe");
        materialHarvestTool.put(Material.field_76233_E, "pickaxe");
        materialHarvestTool.put(Material.field_151591_t, "pickaxe");
        materialHarvestTool.put(Material.field_151576_e, "pickaxe");
        materialHarvestTool.put(Material.field_215711_w, "pickaxe");
        materialHarvestTool.put(Material.field_175972_I, "pickaxe");
        materialHarvestTool.put(Material.field_151594_q, "pickaxe");
        materialHarvestTool.put(Material.field_151575_d, "axe");
        materialHarvestTool.put(Material.field_151584_j, "axe");
        materialHarvestTool.put(Material.field_151572_C, "axe");
        materialHarvestTool.put(Material.field_151571_B, "shovel");
        materialHarvestTool.put(Material.field_151578_c, "shovel");
        materialHarvestTool.put(Material.field_151595_p, "shovel");
        materialHarvestTool.put(Material.field_151597_y, "shovel");
        materialHarvestTool.put(Material.field_204868_h, "shovel");
        materialHarvestTool.put(Material.field_151596_z, "shovel");
        materialHarvestTool.put(Material.field_151585_k, "hoe");
        materialHarvestTool.put(Material.field_203243_f, "hoe");
        materialHarvestTool.put(Material.field_151570_A, "hoe");
        materialHarvestTool.put(Material.field_151589_v, "hoe");
        materialHarvestTool.put(Material.field_151582_l, "hoe");
        materialHarvestTool.put(Material.field_215713_z, "hoe");
        materialHarvestTool.put(Material.field_215712_y, "hoe");
        materialHarvestTool.put(Material.field_151577_b, "hoe");
        materialHarvestTool.put(Material.field_151580_n, "shears");
        materialHarvestTool.put(Material.field_151593_r, "shears");
        materialHarvestTool.put(Material.field_151590_u, "shears");
        materialHarvestTool.put(Material.field_151566_D, "shears");
        materialHarvestTool.put(Material.field_151569_G, "shears");
        materialHarvestTool.put(Material.field_151568_F, "shears");
        materialHarvestTool.put(Material.field_151583_m, "shears");
    }

    public static Style getSkillStyle(Skill skill) {
        return skillStyle.getOrDefault((Object)skill, Style.field_240709_b_);
    }

    public static Skill getSkill(Material material) {
        return XP.getSkillFromTool(XP.correctHarvestTool(material));
    }

    public static Skill getSkill(BlockState state) {
        return XP.getSkill(state.func_185904_a());
    }

    public static Skill getSkillFromTool(String tool) {
        if (tool == null) {
            return Skill.INVALID_SKILL;
        }
        switch (tool) {
            case "pickaxe": {
                return Skill.MINING;
            }
            case "shovel": {
                return Skill.EXCAVATION;
            }
            case "axe": {
                return Skill.WOODCUTTING;
            }
            case "hoe": {
                return Skill.FARMING;
            }
            case "shears": {
                return Skill.CRAFTING;
            }
        }
        return Skill.INVALID_SKILL;
    }

    public static Map<String, Double> getXp(ResourceLocation registryName, JType jType) {
        HashMap<String, Double> theMap = new HashMap<String, Double>();
        if (JsonConfig.data.get((Object)jType).containsKey(registryName.toString())) {
            for (Map.Entry<String, Object> entry : JsonConfig.data.get((Object)jType).get(registryName.toString()).entrySet()) {
                if (!(entry.getValue() instanceof Double)) continue;
                theMap.put(entry.getKey(), (double)((Double)entry.getValue()));
            }
        }
        return theMap;
    }

    public static Integer getSkillColor(Skill skill) {
        return skillColors.getOrDefault((Object)skill, 0xFFFFFF);
    }

    public static String correctHarvestTool(Material material) {
        if (material == null) {
            return "none";
        }
        if (materialHarvestTool.get(material) != null) {
            return materialHarvestTool.get(material);
        }
        return "none";
    }

    public static String checkMaterial(Material material) {
        if (material.equals(Material.field_151579_a)) {
            return "AIR";
        }
        if (material.equals(Material.field_189963_J)) {
            return "STRUCTURE_VOID";
        }
        if (material.equals(Material.field_151567_E)) {
            return "PORTAL";
        }
        if (material.equals(Material.field_151593_r)) {
            return "CARPET";
        }
        if (material.equals(Material.field_151585_k)) {
            return "PLANTS";
        }
        if (material.equals(Material.field_203243_f)) {
            return "OCEAN_PLANT";
        }
        if (material.equals(Material.field_151582_l)) {
            return "TALL_PLANTS";
        }
        if (material.equals(Material.field_204868_h)) {
            return "SEA_GRASS";
        }
        if (material.equals(Material.field_151586_h)) {
            return "WATER";
        }
        if (material.equals(Material.field_203244_i)) {
            return "BUBBLE_COLUMN";
        }
        if (material.equals(Material.field_151587_i)) {
            return "LAVA";
        }
        if (material.equals(Material.field_151597_y)) {
            return "SNOW";
        }
        if (material.equals(Material.field_151581_o)) {
            return "FIRE";
        }
        if (material.equals(Material.field_151594_q)) {
            return "MISCELLANEOUS";
        }
        if (material.equals(Material.field_151569_G)) {
            return "WEB";
        }
        if (material.equals(Material.field_151591_t)) {
            return "REDSTONE_LIGHT";
        }
        if (material.equals(Material.field_151571_B)) {
            return "CLAY";
        }
        if (material.equals(Material.field_151578_c)) {
            return "EARTH";
        }
        if (material.equals(Material.field_151577_b)) {
            return "ORGANIC";
        }
        if (material.equals(Material.field_151598_x)) {
            return "PACKED_ICE";
        }
        if (material.equals(Material.field_151595_p)) {
            return "SAND";
        }
        if (material.equals(Material.field_151583_m)) {
            return "SPONGE";
        }
        if (material.equals(Material.field_215711_w)) {
            return "SHULKER";
        }
        if (material.equals(Material.field_151575_d)) {
            return "WOOD";
        }
        if (material.equals(Material.field_215712_y)) {
            return "BAMBOO_SAPLING";
        }
        if (material.equals(Material.field_215713_z)) {
            return "BAMBOO";
        }
        if (material.equals(Material.field_151580_n)) {
            return "WOOL";
        }
        if (material.equals(Material.field_151590_u)) {
            return "TNT";
        }
        if (material.equals(Material.field_151584_j)) {
            return "LEAVES";
        }
        if (material.equals(Material.field_151592_s)) {
            return "GLASS";
        }
        if (material.equals(Material.field_151588_w)) {
            return "ICE";
        }
        if (material.equals(Material.field_151570_A)) {
            return "CACTUS";
        }
        if (material.equals(Material.field_151576_e)) {
            return "ROCK";
        }
        if (material.equals(Material.field_151573_f)) {
            return "IRON";
        }
        if (material.equals(Material.field_151596_z)) {
            return "SNOW_BLOCK";
        }
        if (material.equals(Material.field_151574_g)) {
            return "ANVIL";
        }
        if (material.equals(Material.field_175972_I)) {
            return "BARRIER";
        }
        if (material.equals(Material.field_76233_E)) {
            return "PISTON";
        }
        if (material.equals(Material.field_151589_v)) {
            return "CORAL";
        }
        if (material.equals(Material.field_151572_C)) {
            return "GOURD";
        }
        if (material.equals(Material.field_151566_D)) {
            return "DRAGON_EGG";
        }
        if (material.equals(Material.field_151568_F)) {
            return "CAKE";
        }
        return "UNKNOWN";
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new StringTextComponent(msg), bar);
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player, TextFormatting format) {
        player.func_146105_b((ITextComponent)new StringTextComponent(msg).func_240703_c_(Style.field_240709_b_.func_240712_a_(format)), bar);
    }

    public static Map<String, Double> multiplyMap(Map<String, Double> mapOne, double multiplier) {
        for (String key : mapOne.keySet()) {
            mapOne.replace(key, mapOne.get(key) * multiplier);
        }
        return mapOne;
    }

    public static Map<String, Double> addMaps(Map<String, Double> mapOne, Map<String, Double> mapTwo) {
        for (String key : mapTwo.keySet()) {
            if (mapOne.containsKey(key)) {
                mapOne.replace(key, mapOne.get(key) + mapTwo.get(key));
                continue;
            }
            mapOne.put(key, mapTwo.get(key));
        }
        return mapOne;
    }

    public static int getLevel(Skill skill, PlayerEntity player) {
        return XP.levelAtXp(XP.getXp(skill, player));
    }

    public static double getXp(Skill skill, PlayerEntity player) {
        double startXp = 0.0;
        if (player.field_70170_p.func_201670_d()) {
            if (skills.containsKey(player.func_110124_au()) && skills.get(player.func_110124_au()).containsKey(skill.name().toLowerCase())) {
                startXp = skills.get(player.func_110124_au()).get(skill.name().toLowerCase());
            }
        } else {
            startXp = XP.getSkillsTag(player).func_74769_h(skill.name().toLowerCase());
        }
        return startXp;
    }

    public static double getXpOffline(Skill skill, UUID uuid) {
        double startXp = 0.0;
        if (skills.containsKey(uuid) && skills.get(uuid).containsKey(skill.name().toLowerCase())) {
            startXp = skills.get(uuid).get(skill.name().toLowerCase());
        }
        return startXp;
    }

    public static int getLevelOffline(Skill skill, UUID uuid) {
        return XP.levelAtXp(XP.getXpOffline(skill, uuid));
    }

    public static double getLevelDecimalOffline(Skill skill, UUID uuid) {
        double startLevel = 1.0;
        if (skills.containsKey(uuid) && skills.get(uuid).containsKey(skill.name().toLowerCase())) {
            startLevel = XP.levelAtXpDecimal(skills.get(uuid).get(skill.name().toLowerCase()));
        }
        return startLevel;
    }

    public static double getLevelDecimal(Skill skill, PlayerEntity player) {
        double startLevel = 1.0;
        if (player.field_70170_p.func_201670_d()) {
            if (XPOverlayGUI.skills.containsKey((Object)skill)) {
                startLevel = XP.levelAtXpDecimal(XPOverlayGUI.skills.get((Object)((Object)skill)).goalXp);
            }
        } else {
            startLevel = XP.levelAtXpDecimal(XP.getSkillsTag(player).func_74769_h(skill.name().toLowerCase()));
        }
        return startLevel;
    }

    private static int doubleObjectToInt(Object object) {
        return (int)Math.floor((Double)object);
    }

    public static double getExtraChance(PlayerEntity player, String resLoc, JType jType) {
        return XP.getExtraChance(player, XP.getResLoc(resLoc), jType);
    }

    public static double getExtraChance(PlayerEntity player, ResourceLocation resLoc, JType jType) {
        String regKey = resLoc.toString();
        double extraChancePerLevel = 0.0;
        int highestReq = 1;
        if (JsonConfig.data.get((Object)JType.REQ_BREAK).containsKey(resLoc.toString())) {
            highestReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(resLoc.toString()).entrySet().stream().map(a -> XP.doubleObjectToInt(a.getValue())).reduce(0, Math::max);
        }
        int startLevel = 1;
        switch (jType) {
            case INFO_ORE: {
                if (JsonConfig.data.get((Object)JType.INFO_ORE).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).containsKey("extraChance") && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).get("extraChance") instanceof Double) {
                    extraChancePerLevel = (Double)JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).get("extraChance");
                }
                startLevel = XP.getLevel(Skill.MINING, player);
                break;
            }
            case INFO_LOG: {
                if (JsonConfig.data.get((Object)JType.INFO_LOG).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).containsKey("extraChance") && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).get("extraChance") instanceof Double) {
                    extraChancePerLevel = (Double)JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).get("extraChance");
                }
                startLevel = XP.getLevel(Skill.WOODCUTTING, player);
                break;
            }
            case INFO_PLANT: {
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).containsKey("extraChance") && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).get("extraChance") instanceof Double) {
                    extraChancePerLevel = (Double)JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).get("extraChance");
                }
                startLevel = XP.getLevel(Skill.FARMING, player);
                break;
            }
            default: {
                LogHandler.LOGGER.error("WRONG getExtraChance CHANCE TYPE! PLEASE REPORT!");
                return 0.0;
            }
        }
        double extraChance = (double)(startLevel - highestReq) * extraChancePerLevel;
        if (extraChance < 0.0) {
            extraChance = 0.0;
        }
        return extraChance;
    }

    public static void dropItems(int dropsLeft, Item item, World world, BlockPos pos) {
        if (dropsLeft > 0) {
            while (dropsLeft > 64) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, 64));
                dropsLeft -= 64;
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, dropsLeft));
        }
    }

    public static void dropItemStack(ItemStack itemStack, World world, Vector3d pos) {
        XP.dropItemStack(itemStack, world, new BlockPos(pos));
    }

    public static void dropItemStack(ItemStack itemStack, World world, BlockPos pos) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
    }

    public static boolean isPlayerSurvival(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static Collection<PlayerEntity> getNearbyPlayers(Entity mob) {
        World world = mob.func_130014_f_();
        List allPlayers = world.func_217369_A();
        ArrayList<PlayerEntity> nearbyPlayers = new ArrayList<PlayerEntity>();
        Float closestDistance = null;
        for (PlayerEntity player : allPlayers) {
            float tempDistance = mob.func_70032_d((Entity)player);
            if (closestDistance != null && !(tempDistance < closestDistance.floatValue())) continue;
            closestDistance = Float.valueOf(tempDistance);
        }
        if (closestDistance != null) {
            float searchRange = closestDistance.floatValue() + 30.0f;
            for (PlayerEntity player : allPlayers) {
                if (!(mob.func_70032_d((Entity)player) < searchRange)) continue;
                nearbyPlayers.add(player);
            }
        }
        return nearbyPlayers;
    }

    public static float getPowerLevel(PlayerEntity player) {
        int enduranceLevel = XP.getLevel(Skill.ENDURANCE, player);
        int combatLevel = XP.getLevel(Skill.COMBAT, player);
        int archeryLevel = XP.getLevel(Skill.ARCHERY, player);
        int magicLevel = XP.getLevel(Skill.MAGIC, player);
        int maxOffensive = combatLevel;
        if (maxOffensive < archeryLevel) {
            maxOffensive = archeryLevel;
        }
        if (maxOffensive < magicLevel) {
            maxOffensive = magicLevel;
        }
        return ((float)enduranceLevel + (float)maxOffensive * 1.5f) / 50.0f;
    }

    public static void syncPlayerConfig(PlayerEntity player) {
        NetworkHandler.sendToPlayer(new MessageUpdateReq(JsonConfig.localData, 0), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdateNBT(NBTHelper.mapToNBT(Config.localConfig), 2), (ServerPlayerEntity)player);
    }

    public static void syncPlayer(PlayerEntity player) {
        CompoundNBT skillsTag = XP.getSkillsTag(player);
        CompoundNBT prefsTag = XP.getPreferencesTag(player);
        CompoundNBT abilitiesTag = XP.getAbilitiesTag(player);
        HashSet keySet = new HashSet(skillsTag.func_150296_c());
        XP.syncPlayerConfig(player);
        XP.updateRecipes((ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageXp(0.0, 42069, 0.0, true), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdateNBT(prefsTag, 0), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdateNBT(abilitiesTag, 1), (ServerPlayerEntity)player);
        AttributeHandler.updateAll(player);
        for (String tag : keySet) {
            if (Skill.getInt(tag) != 0) continue;
            if (Skill.getInt(tag.toLowerCase()) != 0) {
                skillsTag.func_218657_a(tag.toLowerCase(), skillsTag.func_74781_a(tag));
            }
            if (tag.toLowerCase().equals("repairing")) {
                skillsTag.func_218657_a("smithing", skillsTag.func_74781_a(tag));
            }
            LogHandler.LOGGER.info("REMOVING INVALID SKILL " + tag + " FROM PLAYER " + player.func_145748_c_().getString());
            skillsTag.func_82580_o(tag);
        }
        keySet = new HashSet(skillsTag.func_150296_c());
        for (String tag : keySet) {
            NetworkHandler.sendToPlayer(new MessageXp(skillsTag.func_74769_h(tag), Skill.getInt(tag), 0.0, true), (ServerPlayerEntity)player);
        }
    }

    public static boolean checkReq(PlayerEntity player, String res, JType jType) {
        return XP.checkReq(player, XP.getResLoc(res), jType);
    }

    public static ResourceLocation getResLoc(String regKey) {
        try {
            return new ResourceLocation(regKey);
        }
        catch (Exception e) {
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getResLoc(String firstPart, String secondPart) {
        try {
            return new ResourceLocation(firstPart, secondPart);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Double> getReqMap(String registryName, JType type) {
        Map<String, Map<String, Object>> fullMap = JsonConfig.data.get((Object)type);
        HashMap<String, Double> map = null;
        if (fullMap != null && fullMap.containsKey(registryName)) {
            map = new HashMap<String, Double>();
            for (Map.Entry<String, Object> entry : fullMap.get(registryName).entrySet()) {
                if (!(entry.getValue() instanceof Double)) continue;
                map.put(entry.getKey(), (Double)entry.getValue());
            }
        }
        return map;
    }

    public static boolean checkReq(PlayerEntity player, ResourceLocation res, JType jType) {
        if (res == null) {
            return true;
        }
        if (res.equals((Object)Items.field_190931_a.getRegistryName()) || player.func_184812_l_()) {
            return true;
        }
        if (JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).containsKey(player.func_110124_au().toString()) && JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).get(player.func_110124_au().toString()).containsKey("ignoreReq")) {
            return true;
        }
        String registryName = res.toString();
        Map<String, Double> reqMap = XP.getReqMap(registryName, jType);
        boolean failedReq = false;
        if (reqMap != null) {
            for (Map.Entry<String, Double> entry : reqMap.entrySet()) {
                double startLevel = XP.getLevelDecimal(Skill.getSkill(entry.getKey()), player);
                if (!(startLevel < entry.getValue())) continue;
                failedReq = true;
            }
        }
        return !failedReq;
    }

    public static int getHighestReq(String regKey, JType jType) {
        int highestReq = 1;
        Map<String, Double> map = XP.getReqMap(regKey, jType);
        if (map != null) {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!((double)highestReq < entry.getValue())) continue;
                highestReq = (int)entry.getValue().doubleValue();
            }
        }
        return highestReq;
    }

    public static Item getItem(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        if (resLoc != null) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resLoc);
            Item item2 = ((Block)ForgeRegistries.BLOCKS.getValue(resLoc)).func_199767_j();
            if (item != null && !item.equals(Items.field_190931_a)) {
                return item;
            }
            if (!item2.equals(Items.field_190931_a)) {
                return item2;
            }
            return Items.field_190931_a;
        }
        return Items.field_190931_a;
    }

    public static Item getItem(ResourceLocation resLoc) {
        return (Item)ForgeRegistries.ITEMS.getValue(resLoc);
    }

    public static boolean scanBlock(Block block, int radius, PlayerEntity player) {
        BlockPos playerPos = XP.vecToBlock(player.func_213303_ch());
        boolean matched = false;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block currBlock = player.field_70170_p.func_180495_p(new BlockPos(playerPos.func_177958_n() + x, playerPos.func_177956_o() + y, playerPos.func_177952_p() + z)).func_177230_c();
                    if (!currBlock.equals(block)) continue;
                    matched = true;
                    continue block1;
                }
            }
        }
        return matched;
    }

    public static CompoundNBT getPmmoTag(PlayerEntity player) {
        if (player != null) {
            CompoundNBT persistTag = player.getPersistentData();
            CompoundNBT pmmoTag = null;
            if (!persistTag.func_74764_b("pmmo")) {
                pmmoTag = new CompoundNBT();
                persistTag.func_218657_a("pmmo", (INBT)pmmoTag);
            } else {
                pmmoTag = persistTag.func_74775_l("pmmo");
            }
            return pmmoTag;
        }
        return new CompoundNBT();
    }

    public static CompoundNBT getPmmoTagElement(PlayerEntity player, String element) {
        if (player != null) {
            CompoundNBT pmmoTag = XP.getPmmoTag(player);
            CompoundNBT elementTag = null;
            if (!pmmoTag.func_74764_b(element)) {
                elementTag = new CompoundNBT();
                pmmoTag.func_218657_a(element, (INBT)elementTag);
            } else {
                elementTag = pmmoTag.func_74775_l(element);
            }
            return elementTag;
        }
        return new CompoundNBT();
    }

    public static CompoundNBT getSkillsTag(PlayerEntity player) {
        return XP.getPmmoTagElement(player, "skills");
    }

    public static CompoundNBT getPreferencesTag(PlayerEntity player) {
        return XP.getPmmoTagElement(player, "preferences");
    }

    public static CompoundNBT getAbilitiesTag(PlayerEntity player) {
        return XP.getPmmoTagElement(player, "abilities");
    }

    public static double getWornXpBoost(PlayerEntity player, Item item, String skillName) {
        double boost = 0.0;
        if (!item.equals(Items.field_190931_a)) {
            String regName = item.getRegistryName().toString();
            Map<String, Object> itemXpMap = JsonConfig.data.get((Object)JType.XP_BONUS_WORN).get(regName);
            if (itemXpMap != null && itemXpMap.containsKey(skillName) && XP.checkReq(player, item.getRegistryName(), JType.REQ_WEAR)) {
                boost = (Double)itemXpMap.get(skillName);
            }
        }
        return boost;
    }

    public static double getSkillMultiplier(Skill skill) {
        double skillMultiplier = 1.0;
        switch (skill) {
            case MINING: {
                skillMultiplier = Config.forgeConfig.miningMultiplier.get();
                break;
            }
            case BUILDING: {
                skillMultiplier = Config.forgeConfig.buildingMultiplier.get();
                break;
            }
            case EXCAVATION: {
                skillMultiplier = Config.forgeConfig.excavationMultiplier.get();
                break;
            }
            case WOODCUTTING: {
                skillMultiplier = Config.forgeConfig.woodcuttingMultiplier.get();
                break;
            }
            case FARMING: {
                skillMultiplier = Config.forgeConfig.farmingMultiplier.get();
                break;
            }
            case AGILITY: {
                skillMultiplier = Config.forgeConfig.agilityMultiplier.get();
                break;
            }
            case ENDURANCE: {
                skillMultiplier = Config.forgeConfig.enduranceMultiplier.get();
                break;
            }
            case COMBAT: {
                skillMultiplier = Config.forgeConfig.combatMultiplier.get();
                break;
            }
            case ARCHERY: {
                skillMultiplier = Config.forgeConfig.archeryMultiplier.get();
                break;
            }
            case SMITHING: {
                skillMultiplier = Config.forgeConfig.smithingMultiplier.get();
                break;
            }
            case FLYING: {
                skillMultiplier = Config.forgeConfig.flyingMultiplier.get();
                break;
            }
            case SWIMMING: {
                skillMultiplier = Config.forgeConfig.swimmingMultiplier.get();
                break;
            }
            case FISHING: {
                skillMultiplier = Config.forgeConfig.fishingMultiplier.get();
                break;
            }
            case CRAFTING: {
                skillMultiplier = Config.forgeConfig.craftingMultiplier.get();
                break;
            }
        }
        return skillMultiplier;
    }

    public static double getDifficultyMultiplier(PlayerEntity player, Skill skill) {
        double difficultyMultiplier = 1.0;
        if (skill == Skill.COMBAT || skill == Skill.ARCHERY || skill == Skill.ENDURANCE) {
            switch (player.field_70170_p.func_175659_aa()) {
                case PEACEFUL: {
                    difficultyMultiplier = Config.forgeConfig.peacefulMultiplier.get();
                    break;
                }
                case EASY: {
                    difficultyMultiplier = Config.forgeConfig.easyMultiplier.get();
                    break;
                }
                case NORMAL: {
                    difficultyMultiplier = Config.forgeConfig.normalMultiplier.get();
                    break;
                }
                case HARD: {
                    difficultyMultiplier = Config.forgeConfig.hardMultiplier.get();
                    break;
                }
            }
        }
        return difficultyMultiplier;
    }

    public static double getItemBoost(PlayerEntity player, Skill skill) {
        if (player.func_184614_ca().func_77973_b().getRegistryName() == null) {
            return 0.0;
        }
        double itemBoost = 0.0;
        String skillName = skill.toString().toLowerCase();
        String regKey = player.func_184614_ca().func_77973_b().getRegistryName().toString();
        Map<String, Object> heldMap = JsonConfig.data.get((Object)JType.XP_BONUS_HELD).get(regKey);
        PlayerInventory inv = player.field_71071_by;
        if (heldMap != null && heldMap.containsKey(skillName)) {
            itemBoost += ((Double)heldMap.get(skillName)).doubleValue();
        }
        if (Curios.isLoaded()) {
            Collection curiosItems = Curios.getCurios(player).collect(Collectors.toSet());
            for (ICurioStacksHandler value : curiosItems) {
                for (int i = 0; i < value.getSlots(); ++i) {
                    itemBoost += XP.getWornXpBoost(player, value.getStacks().getStackInSlot(i).func_77973_b(), skillName);
                }
            }
        }
        if (!inv.func_70301_a(39).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(39).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(38).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(38).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(37).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(37).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(36).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(36).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(40).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(40).func_77973_b(), skillName);
        }
        return itemBoost;
    }

    public static CompoundNBT writeUniqueId(UUID uuid) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74772_a("M", uuid.getMostSignificantBits());
        compoundnbt.func_74772_a("L", uuid.getLeastSignificantBits());
        return compoundnbt;
    }

    public static double getBiomeBoost(PlayerEntity player, Skill skill) {
        double biomeBoost = 0.0;
        double theBiomeBoost = 0.0;
        double biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        String skillName = skill.toString().toLowerCase();
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = biome.getRegistryName();
        String biomeKey = resLoc.toString();
        Map<String, Object> biomeMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(biomeKey);
        if (biomeMap != null && biomeMap.containsKey(skillName)) {
            theBiomeBoost = (Double)biomeMap.get(skillName);
        }
        biomeBoost = XP.checkReq(player, resLoc, JType.REQ_BIOME) ? theBiomeBoost : Math.min(theBiomeBoost, -biomePenaltyMultiplier * 100.0);
        return biomeBoost;
    }

    public static double getMultiplier(PlayerEntity player, Skill skill) {
        double multiplier = 1.0;
        double skillMultiplier = XP.getSkillMultiplier(skill);
        double difficultyMultiplier = XP.getDifficultyMultiplier(player, skill);
        double itemBoost = XP.getItemBoost(player, skill);
        double biomeBoost = XP.getBiomeBoost(player, skill);
        double additiveMultiplier = 1.0 + (itemBoost + biomeBoost) / 100.0;
        multiplier *= skillMultiplier;
        multiplier *= difficultyMultiplier;
        return multiplier *= additiveMultiplier;
    }

    public static int getMaxVein(PlayerEntity player, Skill skill) {
        int maxVein = 0;
        int level = skill.getLevel(player) - 1;
        switch (skill) {
            case MINING: {
                maxVein = level / 5;
                break;
            }
            case WOODCUTTING: {
                maxVein = level / 2;
                break;
            }
            case EXCAVATION: {
                maxVein = level;
                break;
            }
            case FARMING: {
                maxVein = level;
            }
        }
        return maxVein;
    }

    public static void awardXp(PlayerEntity player, Skill skill, @Nullable String sourceName, double amount, boolean skip, boolean ignoreBonuses) {
        int startLevel;
        double maxXp = Config.getConfig("maxXp");
        if (!(player instanceof ServerPlayerEntity)) {
            LogHandler.LOGGER.error("NOT ServerPlayerEntity PLAYER XP AWARD ATTEMPTED! THIS SHOULD NOT HAPPEN! SOURCE: " + sourceName + ", SKILL: " + skill.name() + ", AMOUNT: " + amount);
            return;
        }
        if (amount <= 0.0 || player.field_70170_p.field_72995_K || player instanceof FakePlayer) {
            return;
        }
        if (skill.getValue() == 0) {
            LogHandler.LOGGER.error("INVALID SKILL AT AWARD XP! SOURCE: " + sourceName + ", AMOUNT: " + amount);
            return;
        }
        String skillName = skill.name().toLowerCase();
        if (!ignoreBonuses) {
            amount *= XP.getMultiplier(player, skill);
        }
        if (amount == 0.0) {
            return;
        }
        String playerName = player.func_145748_c_().getString();
        double startXp = 0.0;
        CompoundNBT skillsTag = XP.getSkillsTag(player);
        if (!skillsTag.func_74764_b(skillName)) {
            skillsTag.func_74780_a(skillName, amount);
            startLevel = 1;
        } else {
            startLevel = XP.levelAtXp(skillsTag.func_74769_h(skillName));
            startXp = skillsTag.func_74769_h(skillName);
            if (startXp >= 2.0E9) {
                return;
            }
            if (startXp + amount >= 2.0E9) {
                XP.sendMessage(skillName + " cap of 2b xp reached, you fucking psycho!", false, player, TextFormatting.LIGHT_PURPLE);
                LogHandler.LOGGER.info(player.func_145748_c_().getString() + " " + skillName + " 2b cap reached");
                amount = 2.0E9 - startXp;
            }
            skillsTag.func_74780_a(skillName, startXp + amount);
        }
        int currLevel = XP.levelAtXp(skillsTag.func_74769_h(skillName));
        if (startLevel != currLevel) {
            AttributeHandler.updateAll(player);
            XP.updateRecipes((ServerPlayerEntity)player);
            if (ModList.get().isLoaded("compatskills")) {
                String commandArgs = "reskillable incrementskill " + playerName + " compatskills." + (Object)((Object)skill) + " 1";
                try {
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_184102_h().func_195571_aL().func_197054_a().execute(commandArgs, (Object)player.func_195051_bN().func_197031_a());
                    }
                }
                catch (CommandSyntaxException e) {
                    LogHandler.LOGGER.error("PMMO Level Up - compatskills command went wrong! args: " + commandArgs, (Throwable)e);
                }
            }
            if (JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skillName.toLowerCase()) != null) {
                Map<String, Object> commandMap = JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skillName.toLowerCase());
                for (Map.Entry<String, Object> entry : commandMap.entrySet()) {
                    int commandLevel = (int)Math.floor((Double)entry.getValue());
                    if (startLevel >= commandLevel || currLevel < commandLevel) continue;
                    String command = entry.getKey().replace(">player<", playerName).replace(">level<", "" + commandLevel);
                    try {
                        player.func_184102_h().func_195571_aL().func_197054_a().execute(command, (Object)player.func_184102_h().func_195573_aM());
                        LogHandler.LOGGER.info("Executing command \"" + command + "\"\nTrigger: " + playerName + " level up from " + startLevel + " to " + currLevel + " in " + skill.name() + ", trigger level " + commandLevel);
                    }
                    catch (CommandSyntaxException e) {
                        LogHandler.LOGGER.error("Invalid level up command \"" + command + "\"", (Throwable)e);
                    }
                }
            }
        }
        if (player instanceof ServerPlayerEntity) {
            NetworkHandler.sendToPlayer(new MessageXp(startXp, skill.getValue(), amount, skip), (ServerPlayerEntity)player);
        }
        if (!skip) {
            LogHandler.LOGGER.debug(playerName + " +" + amount + "xp in " + skillName + " for " + sourceName + " total xp: " + skillsTag.func_74769_h(skillName));
        }
        if (startXp + amount >= maxXp && startXp < maxXp) {
            XP.sendMessage(skillName + " max startLevel reached, you psycho!", false, player, TextFormatting.LIGHT_PURPLE);
            LogHandler.LOGGER.info(playerName + " " + skillName + " max startLevel reached");
        }
    }

    public static void awardXpTrigger(ServerPlayerEntity player, String triggerKey, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        if (JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).containsKey(triggerKey)) {
            XP.awardXpMap((PlayerEntity)player, JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).get(triggerKey), sourceName, skip, ignoreBonuses);
        } else {
            LogHandler.LOGGER.error("TRIGGER XP AWARD \"" + triggerKey + "\" DOES NOT HAVE ANY VALUES, CANNOT AWARD");
        }
    }

    public static void awardXpMap(PlayerEntity player, Map<String, Object> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            XP.awardXp(player, Skill.getSkill(entry.getKey()), sourceName, (Double)entry.getValue(), skip, ignoreBonuses);
        }
    }

    public static void awardXpMapDouble(PlayerEntity player, Map<String, Double> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            XP.awardXp(player, Skill.getSkill(entry.getKey()), sourceName, entry.getValue(), skip, ignoreBonuses);
        }
    }

    public static void updateRecipes(ServerPlayerEntity player) {
        Collection allRecipes = player.func_184102_h().func_199529_aN().func_199510_b();
        HashSet<IRecipe> removeRecipes = new HashSet<IRecipe>();
        HashSet<IRecipe> newRecipes = new HashSet<IRecipe>();
        for (IRecipe recipe : allRecipes) {
            if (XP.checkReq((PlayerEntity)player, recipe.func_77571_b().func_77973_b().getRegistryName(), JType.REQ_CRAFT)) {
                newRecipes.add(recipe);
                continue;
            }
            removeRecipes.add(recipe);
        }
        player.func_192037_E().func_197925_b(removeRecipes, player);
        player.func_192037_E().func_197926_a(newRecipes, player);
    }

    public static void scanUnlocks(int level, Skill skill) {
    }

    private static int getGap(int a, int b) {
        return a - b;
    }

    public static int getSkillReqGap(PlayerEntity player, ResourceLocation res, JType jType) {
        Map<String, Double> reqs;
        int gap = 0;
        if (!XP.checkReq(player, res, jType) && (reqs = XP.getReqMap(res.toString(), jType)) != null) {
            gap = (int)Math.floor(reqs.entrySet().stream().map(entry -> XP.getGap((int)Math.floor((Double)entry.getValue()), XP.getLevel(Skill.getSkill((String)entry.getKey()), player))).reduce(0, Math::max).intValue());
        }
        return gap;
    }

    public static BlockPos vecToBlock(Vector3d pos) {
        return new BlockPos(pos);
    }

    public static Vector3d blockToVec(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static void spawnRocket(World world, BlockPos pos, Skill skill) {
        XP.spawnRocket(world, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), skill);
    }

    public static void spawnRocket(World world, Vector3d pos, Skill skill) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT fw = new CompoundNBT();
        ListNBT explosion = new ListNBT();
        CompoundNBT l = new CompoundNBT();
        int[] colors = new int[]{XP.getSkillColor(skill)};
        l.func_74768_a("Flicker", 1);
        l.func_74768_a("Trail", 0);
        l.func_74768_a("Type", 1);
        l.func_218657_a("Colors", (INBT)new IntArrayNBT(colors));
        explosion.add((Object)l);
        fw.func_218657_a("Explosions", (INBT)explosion);
        fw.func_74768_a("Flight", 0);
        nbt.func_218657_a("Fireworks", (INBT)fw);
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196152_dE);
        itemStack.func_77982_d(nbt);
        PMMOFireworkEntity fireworkRocketEntity = new PMMOFireworkEntity(world, pos.func_82615_a() + 0.5, pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, itemStack);
        world.func_217376_c((Entity)fireworkRocketEntity);
    }

    public static void applyWornPenalty(PlayerEntity player, ItemStack itemStack) {
        ResourceLocation resLoc = itemStack.func_77973_b().getRegistryName();
        if (!XP.checkReq(player, resLoc, JType.REQ_WEAR)) {
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_WEAR);
            if (gap > 9) {
                gap = 9;
            }
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 75, gap, false, true));
            if (alwaysDropWornItems || EnchantmentHelper.func_190938_b((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.func_77946_l();
                player.func_146097_a(droppedItemStack, false, false);
                itemStack.func_190920_e(0);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToWearDropped", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_240703_c_(textStyle.get("red")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToWearDropped", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_240703_c_(textStyle.get("red")), false);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToWear", new Object[]{new TranslationTextComponent(itemStack.func_77973_b().func_77658_a())}).func_240703_c_(textStyle.get("red")), true);
            }
        }
    }

    public static void checkBiomeLevelReq(PlayerEntity player) {
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = biome.getRegistryName();
        String biomeKey = resLoc.toString();
        UUID playerUUID = player.func_110124_au();
        Map<String, Object> biomeReq = JsonConfig.data.get((Object)JType.REQ_BIOME).get(biomeKey);
        Map<String, Object> biomeEffect = JsonConfig.data.get((Object)JType.BIOME_EFFECT).get(biomeKey);
        if (!lastBiome.containsKey(playerUUID)) {
            lastBiome.put(playerUUID, "none");
        }
        if (biomeReq != null && biomeEffect != null && !XP.checkReq(player, resLoc, JType.REQ_BIOME)) {
            for (Map.Entry<String, Object> entry : biomeEffect.entrySet()) {
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                if (effect == null) continue;
                player.func_195064_c(new EffectInstance(effect, 75, (int)Math.floor((Double)entry.getValue()), false, true));
            }
            if (player.field_70170_p.func_201670_d() && !lastBiome.get(playerUUID).equals(biomeKey)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(biome.func_210773_k())}).func_240703_c_(textStyle.get("red")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(biome.func_210773_k())}).func_240703_c_(textStyle.get("red")), false);
                for (Map.Entry<String, Object> entry : biomeReq.entrySet()) {
                    int startLevel = XP.getLevel(Skill.getSkill(entry.getKey()), player);
                    if ((double)startLevel < (Double)entry.getValue()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey()).getString(), "" + (int)Math.floor((Double)entry.getValue())}).func_240703_c_(textStyle.get("red")), false);
                        continue;
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey()).getString(), "" + (int)Math.floor((Double)entry.getValue())}).func_240703_c_(textStyle.get("green")), false);
                }
            }
        }
        lastBiome.put(playerUUID, biomeKey);
    }

    public static double getWeight(int startLevel, Map<String, Object> fishItem) {
        return DP.map(startLevel, (Double)fishItem.get("startLevel"), (Double)fishItem.get("endLevel"), (Double)fishItem.get("startWeight"), (Double)fishItem.get("endWeight"));
    }

    public static int levelAtXp(float xp) {
        return XP.levelAtXp((double)xp);
    }

    public static int levelAtXp(double xp) {
        double baseXp = Config.getConfig("baseXp");
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        int theXp = 0;
        int startLevel = 0;
        while (!(xp < (double)theXp) && startLevel < maxLevel) {
            theXp = (int)((double)theXp + (baseXp + (double)startLevel * xpIncreasePerLevel));
            ++startLevel;
        }
        return startLevel;
    }

    public static float levelAtXpDecimal(float xp) {
        return (float)XP.levelAtXpDecimal((double)xp);
    }

    public static double levelAtXpDecimal(double xp) {
        double goalXp;
        int startLevel;
        double startXp;
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        if (XP.levelAtXp(xp) == maxLevel) {
            xp = XP.xpAtLevel(maxLevel);
        }
        if ((startXp = XP.xpAtLevel(startLevel = XP.levelAtXp(xp))) == (goalXp = XP.xpAtLevel(startLevel + 1))) {
            return maxLevel;
        }
        return (double)startLevel + (xp - startXp) / (goalXp - startXp);
    }

    public static double xpAtLevel(float givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(double givenLevel) {
        double baseXp = Config.getConfig("baseXp");
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        double theXp = 0.0;
        if (givenLevel > (double)maxLevel) {
            givenLevel = maxLevel;
        }
        int startLevel = 1;
        while ((double)startLevel < givenLevel) {
            theXp += baseXp + (double)(startLevel - 1) * xpIncreasePerLevel;
            ++startLevel;
        }
        return theXp;
    }

    public static float xpAtLevelDecimal(float givenLevel) {
        return (float)XP.xpAtLevelDecimal((double)givenLevel);
    }

    public static double xpAtLevelDecimal(double givenLevel) {
        double startXp = XP.xpAtLevel(Math.floor(givenLevel));
        double endXp = XP.xpAtLevel(Math.floor(givenLevel + 1.0));
        double pos = givenLevel - Math.floor(givenLevel);
        return startXp + (endXp - startXp) * pos;
    }
}

