/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.AUTOMATION)
public class DispensersPlaceBlocksModule
extends Module {
    @Config
    public static List<String> blacklist = Lists.newArrayList((Object[])new String[]{"minecraft:water", "minecraft:lava", "minecraft:fire"});

    @Override
    public void loadComplete() {
        if (!this.enabled) {
            return;
        }
        Map registry = DispenserBlock.field_149943_a;
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            Item item;
            if (blacklist.contains(Objects.toString(block.getRegistryName())) || !((item = block.func_199767_j()) instanceof BlockItem) || registry.containsKey(item)) continue;
            registry.put(item, new BlockBehaviour((BlockItem)item));
        }
    }

    private static class NotStupidDirectionalPlaceContext
    extends DirectionalPlaceContext {
        protected boolean field_196013_a = true;

        public NotStupidDirectionalPlaceContext(World worldIn, BlockPos p_i50051_2_, Direction p_i50051_3_, ItemStack p_i50051_4_, Direction against) {
            super(worldIn, p_i50051_2_, p_i50051_3_, p_i50051_4_, against);
            this.field_196013_a = worldIn.func_180495_p(this.field_221535_d.func_216350_a()).func_196953_a((BlockItemUseContext)this);
        }

        public boolean func_196011_b() {
            return this.field_196013_a;
        }
    }

    public static class BlockBehaviour
    extends OptionalDispenseBehavior {
        private final BlockItem item;

        public BlockBehaviour(BlockItem item) {
            this.item = item;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction;
            this.field_218407_b = false;
            Direction against = direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(direction);
            Block block = this.item.func_179223_d();
            if (block instanceof StairsBlock && direction.func_176740_k() != Direction.Axis.Y) {
                direction = direction.func_176734_d();
            } else if (block instanceof SlabBlock) {
                against = Direction.UP;
            }
            this.field_218407_b = this.item.func_195942_a((BlockItemUseContext)new NotStupidDirectionalPlaceContext(source.func_197524_h(), pos, direction, stack, against)) == ActionResultType.SUCCESS;
            return stack;
        }
    }
}

