/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.ConfigResolver;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleFinder;

public final class ModuleLoader {
    public static final ModuleLoader INSTANCE = new ModuleLoader();
    private Map<Class<? extends Module>, Module> foundModules = new HashMap<Class<? extends Module>, Module>();
    private ConfigResolver config;

    private ModuleLoader() {
    }

    public void start() {
        this.findModules();
        this.dispatch(Module::construct);
        this.dispatch(Module::modulesStarted);
        this.resolveConfigSpec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        this.dispatch(Module::constructClient);
    }

    private void findModules() {
        ModuleFinder finder = new ModuleFinder();
        finder.findModules();
        this.foundModules = finder.getFoundModules();
    }

    private void resolveConfigSpec() {
        this.config = new ConfigResolver();
        this.config.makeSpec();
    }

    public void configChanged() {
        this.config.configChanged();
        this.dispatch(Module::configChanged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        this.dispatch(Module::configChangedClient);
    }

    public void setup() {
        this.dispatch(Module::earlySetup);
        Quark.proxy.handleQuarkConfigChange();
        this.dispatch(Module::setup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.dispatch(Module::clientSetup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        this.dispatch(Module::modelRegistry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.dispatch(m -> m.textureStitch(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post event) {
        this.dispatch(m -> m.postTextureStitch(event));
    }

    public void loadComplete() {
        this.dispatch(Module::loadComplete);
    }

    private void dispatch(Consumer<Module> run) {
        this.foundModules.values().forEach(run);
    }

    public boolean isModuleEnabled(Class<? extends Module> moduleClazz) {
        Module module = this.getModuleInstance(moduleClazz);
        return module != null && module.enabled;
    }

    public Module getModuleInstance(Class<? extends Module> moduleClazz) {
        return this.foundModules.get(moduleClazz);
    }
}

