/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class JigsawRegistryHelper {
    public static final FakeAirProcessor FAKE_AIR = new FakeAirProcessor();
    private static Codec<FakeAirProcessor> fakeAirCodec = Codec.unit((Object)((Object)FAKE_AIR));
    private static IStructureProcessorType<FakeAirProcessor> fakeAirType = () -> fakeAirCodec;

    public static PoolBuilder pool(String namespace, String name) {
        return new PoolBuilder(namespace, name);
    }

    public static void setup() {
        Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"quark:fake_air", fakeAirType);
    }

    private static class FakeAirProcessor
    extends StructureProcessor {
        public Template.BlockInfo process(IWorldReader worldReaderIn, BlockPos pos, BlockPos otherposidk, Template.BlockInfo p_215194_3_, Template.BlockInfo blockInfo, PlacementSettings placementSettingsIn, Template template) {
            if (blockInfo.field_186243_b.func_177230_c() == Blocks.field_180401_cv) {
                return new Template.BlockInfo(blockInfo.field_186242_a, Blocks.field_201941_jj.func_176223_P(), new CompoundNBT());
            }
            if (blockInfo.field_186243_b.func_206871_b().containsKey((Object)BlockStateProperties.field_208198_y) && ((Boolean)blockInfo.field_186243_b.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                return new Template.BlockInfo(blockInfo.field_186242_a, (BlockState)blockInfo.field_186243_b.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), blockInfo.field_186244_c);
            }
            return blockInfo;
        }

        protected IStructureProcessorType<?> func_215192_a() {
            return fakeAirType;
        }
    }

    public static class PoolBuilder {
        private final String namespace;
        private final String name;
        private final List<PiecePrototype> pieces = new LinkedList<PiecePrototype>();
        private final List<StructureProcessor> globalProcessors = new LinkedList<StructureProcessor>();

        private PoolBuilder(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.globalProcessors.add(FAKE_AIR);
        }

        public PoolBuilder processor(StructureProcessor ... processors) {
            for (StructureProcessor p : processors) {
                this.globalProcessors.add(p);
            }
            return this;
        }

        public PoolBuilder add(String name, int weight) {
            this.pieces.add(new PiecePrototype(name, weight));
            return this;
        }

        public PoolBuilder add(String name, int weight, StructureProcessor ... processors) {
            this.pieces.add(new PiecePrototype(name, weight, processors));
            return this;
        }

        public PoolBuilder addMult(String dir, Iterable<String> names, int weight) {
            String pref = dir.isEmpty() ? "" : dir + "/";
            for (String s : names) {
                this.add(pref + s, weight);
            }
            return this;
        }

        public void register(JigsawPattern.PlacementBehaviour placementBehaviour) {
            ResourceLocation resource = new ResourceLocation("quark", this.namespace + "/" + this.name);
            List createdPieces = (List)this.pieces.stream().map(proto -> Pair.of((Object)new SingleJigsawPiece("quark:" + this.namespace + "/" + proto.name, proto.processors), (Object)proto.weight)).collect(ImmutableList.toImmutableList());
            JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(resource, new ResourceLocation("empty"), createdPieces, placementBehaviour));
        }

        private class PiecePrototype {
            final String name;
            final int weight;
            final List<StructureProcessor> processors;

            public PiecePrototype(String name, int weight) {
                this(name, weight, new StructureProcessor[0]);
            }

            public PiecePrototype(String name, int weight, StructureProcessor ... processors) {
                this.name = name;
                this.weight = weight;
                this.processors = (List)Streams.concat((Stream[])new Stream[]{Arrays.stream(processors), PoolBuilder.this.globalProcessors.stream()}).collect(ImmutableList.toImmutableList());
            }
        }
    }
}

