/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.ConfigFlagManager;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreStoneVariantsModule
extends Module {
    @Config(flag="stone_bricks")
    public boolean enableBricks = true;
    @Config(flag="stone_chiseled")
    public boolean enableChiseledBricks = true;
    @Config(flag="stone_pavement")
    public boolean enablePavement = true;
    @Config(flag="stone_pillar")
    public boolean enablePillar = true;

    @Override
    public void construct() {
        BooleanSupplier _true = () -> true;
        this.add("granite", MaterialColor.field_151664_l, _true);
        this.add("diorite", MaterialColor.field_151677_p, _true);
        this.add("andesite", MaterialColor.field_151665_m, _true);
        this.add("marble", MaterialColor.field_151677_p, () -> ModuleLoader.INSTANCE.isModuleEnabled(NewStoneTypesModule.class) && NewStoneTypesModule.enableMarble);
        this.add("limestone", MaterialColor.field_151665_m, () -> ModuleLoader.INSTANCE.isModuleEnabled(NewStoneTypesModule.class) && NewStoneTypesModule.enableLimestone);
        this.add("jasper", MaterialColor.field_193559_aa, () -> ModuleLoader.INSTANCE.isModuleEnabled(NewStoneTypesModule.class) && NewStoneTypesModule.enableJasper);
        this.add("slate", MaterialColor.field_151657_g, () -> ModuleLoader.INSTANCE.isModuleEnabled(NewStoneTypesModule.class) && NewStoneTypesModule.enableSlate);
        this.add("basalt", MaterialColor.field_151646_E, () -> ModuleLoader.INSTANCE.isModuleEnabled(NewStoneTypesModule.class) && NewStoneTypesModule.enableVoidstone);
    }

    @Override
    public void pushFlags(ConfigFlagManager manager) {
        manager.putFlag(this, "granite", true);
        manager.putFlag(this, "diorite", true);
        manager.putFlag(this, "andesite", true);
    }

    private void add(String name, MaterialColor color, BooleanSupplier cond) {
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f);
        QuarkBlock bricks = new QuarkBlock(name + "_bricks", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks);
        VariantHandler.addSlabStairsWall(bricks);
        new QuarkBlock("chiseled_" + name + "_bricks", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks && this.enableChiseledBricks);
        new QuarkBlock(name + "_pavement", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enablePavement);
        new QuarkPillarBlock(name + "_pillar", this, ItemGroup.field_78030_b, props).setCondition(() -> cond.getAsBoolean() && this.enablePillar);
    }
}

