/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.quark.management.entity.ChestPassengerEntity;

public class ChestPassengerRenderer
extends EntityRenderer<ChestPassengerEntity> {
    public ChestPassengerRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(ChestPassengerEntity entity, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int light) {
        float rock;
        if (!entity.func_184218_aH()) {
            return;
        }
        Entity riding = entity.func_184187_bx();
        if (riding == null) {
            return;
        }
        BoatEntity boat = (BoatEntity)riding;
        super.func_225623_a_((Entity)entity, yaw, partialTicks, matrix, buffer, light);
        float rot = 180.0f - yaw;
        ItemStack stack = entity.getChestType();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.375, 0.0);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
        float timeSinceHit = (float)boat.func_70268_h() - partialTicks;
        float damageTaken = boat.func_70271_g() - partialTicks;
        if (damageTaken < 0.0f) {
            damageTaken = 0.0f;
        }
        if (timeSinceHit > 0.0f) {
            double angle = MathHelper.func_76126_a((float)timeSinceHit) * timeSinceHit * damageTaken / 10.0f * (float)boat.func_70267_i();
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)angle));
        }
        if (!MathHelper.func_180185_a((float)(rock = boat.func_203056_b(partialTicks)), (float)0.0f)) {
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rock));
        }
        if (riding.func_184188_bt().size() > 1) {
            matrix.func_227861_a_(0.0, 0.0, (double)-0.6f);
        } else {
            matrix.func_227861_a_(0.0, 0.0, (double)-0.45f);
        }
        matrix.func_227861_a_(0.0, (double)0.325f, 0.45000001788139343);
        matrix.func_227862_a_(1.75f, 1.75f, 1.75f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, OverlayTexture.field_229196_a_, matrix, buffer);
        matrix.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(@Nonnull ChestPassengerEntity entity) {
        return null;
    }
}

