/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.module;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.LinkItemMessage;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ItemSharingModule
extends Module {
    @Config
    public static boolean renderItemsInChat = true;
    private static int chatX;
    private static int chatY;
    public static final int RGB_MASK = 0xFFFFFF;
    private static int alphaValue;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        ItemStack stack;
        ContainerScreen gui;
        Slot slot;
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings settings = mc.field_71474_y;
        if (InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)settings.field_74310_D.getKey().func_197937_c()) && event.getGui() instanceof ContainerScreen && Screen.func_231173_s_() && (slot = (gui = (ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot.field_75224_c != null && !(stack = slot.func_75211_c()).func_190926_b() && !MinecraftForge.EVENT_BUS.post((Event)new ClientChatEvent(stack.func_151000_E().getString()))) {
            QuarkNetwork.sendToServer(new LinkItemMessage(stack));
            event.setCanceled(true);
        }
    }

    public static void linkItem(PlayerEntity player, ItemStack item) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class)) {
            return;
        }
        if (!item.func_190926_b() && player instanceof ServerPlayerEntity) {
            ITextComponent comp = item.func_151000_E();
            TranslationTextComponent fullComp = new TranslationTextComponent("chat.type.text", new Object[]{player.func_145748_c_(), comp});
            PlayerList players = ((ServerPlayerEntity)player).field_71133_b.func_184103_al();
            ServerChatEvent event = new ServerChatEvent((ServerPlayerEntity)player, comp.getString(), (ITextComponent)fullComp);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                players.func_232641_a_((ITextComponent)fullComp, ChatType.CHAT, player.func_110124_au());
                ServerPlayNetHandler handler = ((ServerPlayerEntity)player).field_71135_a;
                int threshold = handler.field_147374_l;
                if ((threshold += 20) > 200 && !players.func_152596_g(player.func_146103_bH())) {
                    handler.func_147231_a((ITextComponent)new TranslationTextComponent("disconnect.spam"));
                }
                handler.field_147374_l = threshold;
            }
        }
    }

    public static IFormattableTextComponent createStackComponent(ItemStack stack, IFormattableTextComponent component) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return component;
        }
        Style style = component.func_150256_b();
        if (stack.func_190916_E() > 64) {
            ItemStack copyStack = stack.func_77946_l();
            copyStack.func_190920_e(64);
            style = style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover(copyStack)));
            component.func_230530_a_(style);
        }
        StringTextComponent out = new StringTextComponent("   ");
        out.func_230530_a_(style);
        return out.func_230529_a_((ITextComponent)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void getChatPos(RenderGameOverlayEvent.Chat event) {
        chatX = event.getPosX();
        chatY = event.getPosY();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderSymbols(RenderGameOverlayEvent.Post event) {
        if (!renderItemsInChat) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        IngameGui gameGui = mc.field_71456_v;
        NewChatGui chatGui = gameGui.func_146158_b();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            int shift;
            int updateCounter = gameGui.func_73834_c();
            List lines = chatGui.field_146253_i;
            for (int idx = shift = chatGui.field_146250_j; idx < lines.size() && idx - shift < chatGui.func_146232_i(); ++idx) {
                ChatLine line = (ChatLine)lines.get(idx);
                String before = "";
                ITextProperties lineProperties = line.func_238169_a_();
                if (!(lineProperties instanceof ITextComponent)) continue;
                ITextComponent lineComponent = (ITextComponent)lineProperties;
                String currentText = TextFormatting.func_110646_a((String)lineComponent.getString());
                if (currentText != null && currentText.startsWith("   ")) {
                    ItemSharingModule.render(mc, chatGui, updateCounter, before, line, idx - shift, lineComponent);
                }
                before = before + currentText;
                for (ITextComponent sibling : lineComponent.func_150253_a()) {
                    currentText = TextFormatting.func_110646_a((String)sibling.getString());
                    if (currentText != null && currentText.startsWith("   ")) {
                        ItemSharingModule.render(mc, chatGui, updateCounter, before, line, idx - shift, sibling);
                    }
                    before = before + currentText;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, NewChatGui chatGui, int updateCounter, String before, ChatLine line, int lineHeight, ITextComponent component) {
        Style style = component.func_150256_b();
        HoverEvent hoverEvent = style.func_150210_i();
        if (hoverEvent != null && hoverEvent.func_150701_a() == HoverEvent.Action.field_230551_b_) {
            ItemStack stack;
            HoverEvent.ItemHover contents = (HoverEvent.ItemHover)hoverEvent.func_240662_a_(HoverEvent.Action.field_230551_b_);
            ItemStack itemStack = stack = contents != null ? contents.func_240689_a_() : ItemStack.field_190927_a;
            if (stack.func_190926_b()) {
                stack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
            }
            int timeSinceCreation = updateCounter - line.func_74540_b();
            if (chatGui.func_146241_e()) {
                timeSinceCreation = 0;
            }
            if (timeSinceCreation < 200) {
                double chatOpacity = mc.field_71474_y.field_74357_r * (double)0.9f + (double)0.1f;
                float fadeOut = MathHelper.func_76131_a((float)((1.0f - (float)timeSinceCreation / 200.0f) * 10.0f), (float)0.0f, (float)1.0f);
                double alpha = (double)(fadeOut * fadeOut) * chatOpacity;
                int x = chatX + 3 + mc.field_71466_p.func_78256_a(before);
                mc.field_71466_p.getClass();
                int y = chatY - 9 * lineHeight;
                if (alpha > 0.0) {
                    RenderHelper.func_227780_a_();
                    alphaValue = (int)(alpha * 255.0) << 24;
                    ItemSharingModule.renderItemIntoGUI(mc, mc.func_175599_af(), stack, x, y);
                    alphaValue = -1;
                    RenderHelper.func_74518_a();
                }
            }
        }
    }

    public static int transformColor(int src) {
        if (alphaValue == -1) {
            return src;
        }
        return src & 0xFFFFFF | alphaValue;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderItemIntoGUI(Minecraft mc, ItemRenderer render, ItemStack stack, int x, int y) {
        ItemSharingModule.renderItemModelIntoGUI(mc, render, stack, x, y, render.func_184393_a(stack, null, null));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderItemModelIntoGUI(Minecraft mc, ItemRenderer render, ItemStack stack, int x, int y, IBakedModel model) {
        TextureManager textureManager = mc.func_110434_K();
        RenderSystem.pushMatrix();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)(x - 2), (float)(y - 2), (float)-2.0f);
        RenderSystem.scalef((float)0.65f, (float)0.65f, (float)0.65f);
        render.func_175042_a(stack, 0, 0);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        RenderSystem.popMatrix();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
    }

    static {
        alphaValue = -1;
    }
}

