/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.recipe.FlagIngredient;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.mobs.client.render.FrogRenderer;
import vazkii.quark.mobs.entity.FrogEntity;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class FrogsModule
extends Module {
    public static EntityType<FrogEntity> frogType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config(flag="frog_brewing")
    public static boolean enableBrewing;
    @Config
    public static boolean enableBigFunny;

    @Override
    public void construct() {
        new QuarkItem("frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(2).func_221454_a(0.3f).func_221453_d()));
        new QuarkItem("cooked_frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(4).func_221454_a(1.25f).func_221453_d()));
        QuarkItem goldenLeg = new QuarkItem("golden_frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78038_k).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(4).func_221454_a(2.5f).func_221453_d())).setCondition(() -> enableBrewing);
        BrewingHandler.addPotionMix("frog_brewing", () -> FrogsModule.lambda$construct$1((Item)goldenLeg), Potions.field_185238_j, Potions.field_185239_k, Potions.field_185240_l);
        frogType = EntityType.Builder.func_220322_a(FrogEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.65f, 0.5f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new FrogEntity((EntityType<? extends FrogEntity>)frogType, (World)world)).func_206830_a("frog");
        RegistryHelper.register(frogType, (String)"frog");
        EntitySpawnHandler.registerSpawn(this, frogType, EntityClassification.CREATURE, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b, spawnConfig);
        EntitySpawnHandler.addEgg(frogType, 12359785, 16770733, spawnConfig);
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(frogType, (AttributeModifierMap)FrogEntity.prepareAttributes().func_233813_a_());
    }

    @Override
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(frogType, FrogRenderer::new);
    }

    private static /* synthetic */ Ingredient lambda$construct$1(Item goldenLeg) {
        return new FlagIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{goldenLeg}), "frogs");
    }

    static {
        spawnConfig = new EntitySpawnConfig(40, 1, 3, new BiomeTypeConfig(false, BiomeDictionary.Type.SWAMP));
        enableBrewing = true;
        enableBigFunny = false;
    }
}

