/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.block.CandleBlock;
import vazkii.quark.oddities.module.MatrixEnchantingModule;
import vazkii.quark.oddities.tile.MatrixEnchantingTableTileEntity;

public class MatrixEnchantingTableBlock
extends EnchantingTableBlock {
    public MatrixEnchantingTableBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150381_bn));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MatrixEnchantingTableTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult raytrace) {
        if (!(worldIn.func_175625_s(pos) instanceof MatrixEnchantingTableTileEntity)) {
            worldIn.func_175690_a(pos, this.createTileEntity(state, (IBlockReader)worldIn));
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(MatrixEnchantingModule.class)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((MatrixEnchantingTableTileEntity)worldIn.func_175625_s(pos)), (BlockPos)pos);
            }
        } else if (!worldIn.field_72995_K) {
            SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((p_220147_2_, p_220147_3_, p_220147_4_) -> new EnchantmentContainer(p_220147_2_, p_220147_3_, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos)), ((MatrixEnchantingTableTileEntity)worldIn.func_175625_s(pos)).func_145748_c_());
            player.func_213829_a((INamedContainerProvider)provider);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        boolean enabled = ModuleLoader.INSTANCE.isModuleEnabled(MatrixEnchantingModule.class);
        boolean showInfluences = enabled && MatrixEnchantingModule.allowInfluencing;
        boolean allowUnderwater = enabled && MatrixEnchantingModule.allowUnderwaterEnchanting;
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.func_177982_a(i, k, j);
                    BlockState state = worldIn.func_180495_p(blockpos);
                    if (!(state.getEnchantPowerBonus((IWorldReader)worldIn, pos) > 0.0f)) continue;
                    BlockPos test = pos.func_177982_a(i / 2, 0, j / 2);
                    if (!worldIn.func_175623_d(test) && (!allowUnderwater || worldIn.func_180495_p(test).func_177230_c() != Blocks.field_150355_j)) continue block1;
                    if (showInfluences && state.func_177230_c() instanceof CandleBlock) {
                        DyeColor color = ((CandleBlock)state.func_177230_c()).color;
                        float[] comp = color.func_193349_f();
                        int steps = 20;
                        double dx = (double)(pos.func_177958_n() - blockpos.func_177958_n()) / (double)steps;
                        double dy = (double)(pos.func_177956_o() - blockpos.func_177956_o()) / (double)steps;
                        double dz = (double)(pos.func_177952_p() - blockpos.func_177952_p()) / (double)steps;
                        for (int p = 0; p < steps; ++p) {
                            if (rand.nextDouble() < 0.5) continue;
                            double px = (double)blockpos.func_177958_n() + 0.5 + dx * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            double py = (double)blockpos.func_177956_o() + 0.5 + dy * (double)p + Math.sin((double)p / (double)steps * Math.PI) * 0.5 + rand.nextDouble() * 0.2 - 0.1;
                            double pz = (double)blockpos.func_177952_p() + 0.5 + dz * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(comp[0], comp[1], comp[2], 1.0f), px, py, pz, 0.0, 0.0, 0.0);
                        }
                    }
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat()) - 1.0, (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof MatrixEnchantingTableTileEntity) {
            ((MatrixEnchantingTableTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof MatrixEnchantingTableTileEntity) {
            MatrixEnchantingTableTileEntity enchanter = (MatrixEnchantingTableTileEntity)tileentity;
            enchanter.dropItem(0);
            enchanter.dropItem(1);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }
}

