/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.magnetsystem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.api.IMagnetMoveAction;
import vazkii.quark.api.IMagnetTracker;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.oddities.magnetsystem.DefaultMoveActions;
import vazkii.quark.oddities.module.MagnetsModule;
import vazkii.quark.oddities.tile.MagnetTileEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="quark")
public class MagnetSystem {
    private static HashSet<Block> magnetizableBlocks = new HashSet();
    private static final HashMap<Block, IMagnetMoveAction> BLOCK_MOVE_ACTIONS = new HashMap();

    public static IMagnetMoveAction getMoveAction(Block block) {
        return BLOCK_MOVE_ACTIONS.get(block);
    }

    public static LazyOptional<IMagnetTracker> getCapability(World world) {
        return world.getCapability(QuarkCapabilities.MAGNET_TRACKER_CAPABILITY);
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(MagnetsModule.class)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MagnetSystem.getCapability(event.world).ifPresent(IMagnetTracker::clear);
        } else {
            if (magnetizableBlocks.isEmpty()) {
                MagnetSystem.loadMagnetizableBlocks(event.world);
            }
            MagnetSystem.getCapability(event.world).ifPresent(magnetTracker -> {
                for (BlockPos pos : magnetTracker.getTrackedPositions()) {
                    magnetTracker.actOnForces(pos);
                }
                magnetTracker.clear();
            });
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(MagnetsModule.class)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            magnetizableBlocks.clear();
        }
    }

    public static void applyForce(World world, BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        MagnetSystem.getCapability(world).ifPresent(magnetTracker -> magnetTracker.applyForce(pos, magnitude, pushing, dir, distance, origin));
    }

    public static PushReaction getPushAction(MagnetTileEntity magnet, BlockPos pos, BlockState state, Direction moveDir) {
        World world = magnet.func_145831_w();
        if (world != null && MagnetSystem.isBlockMagnetic(state)) {
            BlockPos targetLocation = pos.func_177972_a(moveDir);
            BlockState stateAtTarget = world.func_180495_p(targetLocation);
            if (stateAtTarget.isAir((IBlockReader)world, targetLocation)) {
                return PushReaction.IGNORE;
            }
            if (stateAtTarget.func_185905_o() == PushReaction.DESTROY) {
                return PushReaction.DESTROY;
            }
        }
        return PushReaction.BLOCK;
    }

    public static boolean isBlockMagnetic(BlockState state) {
        Block block = state.func_177230_c();
        if ((block == Blocks.field_150331_J || block == Blocks.field_150320_F) && ((Boolean)state.func_177229_b((Property)PistonBlock.field_176320_b)).booleanValue()) {
            return false;
        }
        return block != MagnetsModule.magnet && (magnetizableBlocks.contains(block) || BLOCK_MOVE_ACTIONS.containsKey(block) || block instanceof IMagnetMoveAction);
    }

    private static void loadMagnetizableBlocks(World world) {
        RecipeManager manager = world.func_199532_z();
        if (!manager.func_199510_b().isEmpty()) {
            Collection recipes = manager.func_199510_b();
            HashMultimap recipeDigestion = HashMultimap.create();
            for (IRecipe recipe : recipes) {
                Item out = recipe.func_77571_b().func_77973_b();
                NonNullList ingredients = recipe.func_192400_c();
                for (Ingredient ingredient : ingredients) {
                    for (ItemStack inStack : ingredient.func_193365_a()) {
                        recipeDigestion.put((Object)inStack.func_77973_b(), (Object)out);
                    }
                }
            }
            List magneticDerivationList = MiscUtil.massRegistryGet(MagnetsModule.magneticDerivationList, ForgeRegistries.ITEMS);
            List magneticWhitelist = MiscUtil.massRegistryGet(MagnetsModule.magneticWhitelist, ForgeRegistries.ITEMS);
            List magneticBlacklist = MiscUtil.massRegistryGet(MagnetsModule.magneticBlacklist, ForgeRegistries.ITEMS);
            Streams.concat((Stream[])new Stream[]{magneticDerivationList.stream(), magneticWhitelist.stream()}).filter(i -> i instanceof BlockItem).map(i -> ((BlockItem)i).func_179223_d()).forEach(magnetizableBlocks::add);
            HashSet scanned = Sets.newHashSet(magneticDerivationList);
            ArrayList magnetizableToScan = Lists.newArrayList(magneticDerivationList);
            while (!magnetizableToScan.isEmpty()) {
                Item scan = (Item)magnetizableToScan.remove(0);
                if (!recipeDigestion.containsKey((Object)scan)) continue;
                for (Item candidate : recipeDigestion.get((Object)scan)) {
                    if (scanned.contains(candidate)) continue;
                    scanned.add(candidate);
                    magnetizableToScan.add(candidate);
                    if (!(candidate instanceof BlockItem) || magneticBlacklist.contains(candidate)) continue;
                    magnetizableBlocks.add(((BlockItem)candidate).func_179223_d());
                }
            }
        }
    }

    static {
        DefaultMoveActions.addActions(BLOCK_MOVE_ACTIONS);
    }
}

